/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.registry.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite.internal.cli.logger.CliLoggers;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.jetbrains.annotations.Nullable;

public final class LazyObjectRef<R> {
    private static final IgniteLogger LOG = CliLoggers.forClass(LazyObjectRef.class);
    private final Supplier<R> source;
    private final AtomicReference<R> ref = new AtomicReference<Object>(null);
    private final AtomicReference<Boolean> execInProgress = new AtomicReference<Boolean>(false);

    public LazyObjectRef(Supplier<R> source) {
        this.source = source;
        this.fetchFrom(source);
    }

    private void fetchFrom(Supplier<R> source) {
        this.execInProgress.set(true);
        ((CompletableFuture)CompletableFuture.supplyAsync(source).thenAccept(this.ref::set)).whenComplete((v, t) -> {
            if (t != null) {
                LOG.warn("Got exception when fetch from source", t);
            }
            this.execInProgress.set(false);
        });
    }

    @Nullable
    public R get() {
        if (this.ref.get() == null && this.execInProgress.get().booleanValue()) {
            return null;
        }
        if (this.ref.get() == null && !this.execInProgress.get().booleanValue()) {
            this.fetchFrom(this.source);
        }
        return this.ref.get();
    }
}

