/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.configuration.utils.SystemDistributedConfigurationPropertyHolder;
import org.apache.ignite.internal.distributionzones.rebalance.PartitionMover;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite.internal.metastorage.dsl.StatementResult;
import org.apache.ignite.internal.metastorage.dsl.Statements;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsChain;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.RaftError;
import org.apache.ignite.internal.raft.RaftGroupEventsListener;
import org.apache.ignite.internal.raft.Status;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.jetbrains.annotations.TestOnly;

public class RebalanceRaftGroupEventsListener
implements RaftGroupEventsListener {
    private static final IgniteLogger LOG = Loggers.forClass(RebalanceRaftGroupEventsListener.class);
    private static final int REBALANCE_RETRY_THRESHOLD = 10;
    private static final int SWITCH_APPEND_SUCCESS = 1;
    private static final int SWITCH_REDUCE_SUCCESS = 2;
    private static final int SCHEDULE_PENDING_REBALANCE_SUCCESS = 3;
    private static final int FINISH_REBALANCE_SUCCESS = 4;
    private static final int SWITCH_APPEND_FAIL = -1;
    private static final int SWITCH_REDUCE_FAIL = -2;
    private static final int SCHEDULE_PENDING_REBALANCE_FAIL = -3;
    private static final int FINISH_REBALANCE_FAIL = -4;
    private final MetaStorageManager metaStorageMgr;
    private final TablePartitionId tablePartitionId;
    private final IgniteSpinBusyLock busyLock;
    private final ScheduledExecutorService rebalanceScheduler;
    private final PartitionMover partitionMover;
    private final AtomicInteger rebalanceAttempts = new AtomicInteger(0);
    private final SystemDistributedConfigurationPropertyHolder<Integer> retryDelayConfiguration;
    private final BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn;

    public RebalanceRaftGroupEventsListener(MetaStorageManager metaStorageMgr, TablePartitionId tablePartitionId, IgniteSpinBusyLock busyLock, PartitionMover partitionMover, BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn, ScheduledExecutorService rebalanceScheduler, SystemDistributedConfigurationPropertyHolder<Integer> retryDelayConfiguration) {
        this.metaStorageMgr = metaStorageMgr;
        this.tablePartitionId = tablePartitionId;
        this.busyLock = busyLock;
        this.partitionMover = partitionMover;
        this.calculateAssignmentsFn = calculateAssignmentsFn;
        this.rebalanceScheduler = rebalanceScheduler;
        this.retryDelayConfiguration = retryDelayConfiguration;
    }

    public void onLeaderElected(long term) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewPeersConfigurationApplied(PeersAndLearners configuration, long term, long index) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.rebalanceScheduler.schedule(() -> {
                if (!this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    Set<Assignment> stable = RebalanceRaftGroupEventsListener.createAssignments(configuration);
                    RebalanceRaftGroupEventsListener.doStableKeySwitch(stable, this.tablePartitionId, this.metaStorageMgr, this.calculateAssignmentsFn);
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReconfigurationError(Status status, PeersAndLearners configuration, long term) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            assert (status != null);
            if (status.equals((Object)Status.LEADER_STEPPED_DOWN)) {
                LOG.info("Leader stepped down during rebalance [partId={}]", new Object[]{this.tablePartitionId});
                return;
            }
            RaftError raftError = status.error();
            assert (raftError == RaftError.ECATCHUP) : "According to the JRaft protocol, " + String.valueOf(RaftError.ECATCHUP) + " is expected, got " + String.valueOf(raftError);
            LOG.debug("Error occurred during rebalance [partId={}]", new Object[]{this.tablePartitionId});
            if (this.rebalanceAttempts.incrementAndGet() < 10) {
                this.scheduleChangePeersAndLearners(configuration, term);
            } else {
                LOG.info("Number of retries for rebalance exceeded the threshold [partId={}, threshold={}]", new Object[]{this.tablePartitionId, 10});
                this.scheduleChangePeersAndLearners(configuration, term);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @TestOnly
    public int currentRetryDelay() {
        return (Integer)this.retryDelayConfiguration.currentValue();
    }

    private void scheduleChangePeersAndLearners(PeersAndLearners peersAndLearners, long term) {
        this.rebalanceScheduler.schedule(() -> {
            if (!this.busyLock.enterBusy()) {
                return;
            }
            LOG.info("Going to retry rebalance [attemptNo={}, partId={}]", new Object[]{this.rebalanceAttempts.get(), this.tablePartitionId});
            try {
                this.partitionMover.movePartition(peersAndLearners, term).join();
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }, (long)((Integer)this.retryDelayConfiguration.currentValue()).intValue(), TimeUnit.MILLISECONDS);
    }

    private static void doStableKeySwitch(Set<Assignment> stableFromRaft, TablePartitionId tablePartitionId, MetaStorageManager metaStorageMgr, BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn) {
        try {
            Update failCase;
            Update successCase;
            ByteArray pendingPartAssignmentsKey = RebalanceUtil.pendingPartAssignmentsKey(tablePartitionId);
            ByteArray stablePartAssignmentsKey = RebalanceUtil.stablePartAssignmentsKey(tablePartitionId);
            ByteArray plannedPartAssignmentsKey = RebalanceUtil.plannedPartAssignmentsKey(tablePartitionId);
            ByteArray switchReduceKey = RebalanceUtil.switchReduceKey(tablePartitionId);
            ByteArray switchAppendKey = RebalanceUtil.switchAppendKey(tablePartitionId);
            ByteArray assignmentsChainKey = RebalanceUtil.assignmentsChainKey(tablePartitionId);
            Map values = (Map)metaStorageMgr.getAll(Set.of(plannedPartAssignmentsKey, pendingPartAssignmentsKey, stablePartAssignmentsKey, switchReduceKey, switchAppendKey, assignmentsChainKey)).get();
            Entry stableEntry = (Entry)values.get(stablePartAssignmentsKey);
            Entry pendingEntry = (Entry)values.get(pendingPartAssignmentsKey);
            Entry plannedEntry = (Entry)values.get(plannedPartAssignmentsKey);
            Entry switchReduceEntry = (Entry)values.get(switchReduceKey);
            Entry switchAppendEntry = (Entry)values.get(switchAppendKey);
            Entry assignmentsChainEntry = (Entry)values.get(assignmentsChainKey);
            Set retrievedStable = RebalanceRaftGroupEventsListener.readAssignments(stableEntry).nodes();
            Set retrievedSwitchReduce = RebalanceRaftGroupEventsListener.readAssignments(switchReduceEntry).nodes();
            Set retrievedSwitchAppend = RebalanceRaftGroupEventsListener.readAssignments(switchAppendEntry).nodes();
            Assignments pendingAssignments = RebalanceRaftGroupEventsListener.readAssignments(pendingEntry);
            Set retrievedPending = pendingAssignments.nodes();
            if (!retrievedPending.equals(stableFromRaft)) {
                return;
            }
            Set<Assignment> calculatedAssignments = calculateAssignmentsFn.apply(tablePartitionId, pendingAssignments.timestamp()).get();
            Set reducedNodes = CollectionUtils.difference((Set)retrievedSwitchReduce, stableFromRaft);
            Set addedNodes = CollectionUtils.difference(stableFromRaft, (Set)retrievedStable);
            Set calculatedSwitchReduce = CollectionUtils.difference((Set)retrievedSwitchReduce, (Set)reducedNodes);
            Set calculatedSwitchAppend = RebalanceUtil.union(retrievedSwitchAppend, reducedNodes);
            calculatedSwitchAppend = CollectionUtils.difference(calculatedSwitchAppend, (Set)addedNodes);
            calculatedSwitchAppend = CollectionUtils.intersect(calculatedAssignments, (Set)calculatedSwitchAppend);
            Set calculatedPendingReduction = CollectionUtils.difference(stableFromRaft, (Set)retrievedSwitchReduce);
            Set calculatedPendingAddition = RebalanceUtil.union(stableFromRaft, reducedNodes);
            calculatedPendingAddition = CollectionUtils.intersect(calculatedAssignments, calculatedPendingAddition);
            SimpleCondition con1 = stableEntry.empty() ? Conditions.notExists((ByteArray)stablePartAssignmentsKey) : Conditions.revision((ByteArray)stablePartAssignmentsKey).eq(stableEntry.revision());
            SimpleCondition con2 = Conditions.revision((ByteArray)pendingPartAssignmentsKey).eq(pendingEntry.revision());
            SimpleCondition con3 = switchReduceEntry.empty() ? Conditions.notExists((ByteArray)switchReduceKey) : Conditions.revision((ByteArray)switchReduceKey).eq(switchReduceEntry.revision());
            SimpleCondition con4 = switchAppendEntry.empty() ? Conditions.notExists((ByteArray)switchAppendKey) : Conditions.revision((ByteArray)switchAppendKey).eq(switchAppendEntry.revision());
            CompoundCondition retryPreconditions = Conditions.and((Condition)con1, (Condition)Conditions.and((Condition)con2, (Condition)Conditions.and((Condition)con3, (Condition)con4)));
            long catalogTimestamp = pendingAssignments.timestamp();
            Assignments newStableAssignments = Assignments.of(stableFromRaft, (long)catalogTimestamp);
            Operation assignmentChainChangeOp = RebalanceRaftGroupEventsListener.handleAssignmentsChainChange(assignmentsChainKey, assignmentsChainEntry, pendingAssignments, newStableAssignments);
            byte[] stableFromRaftByteArray = newStableAssignments.toBytes();
            byte[] additionByteArray = Assignments.toBytes((Set)calculatedPendingAddition, (long)catalogTimestamp);
            byte[] reductionByteArray = Assignments.toBytes((Set)calculatedPendingReduction, (long)catalogTimestamp);
            byte[] switchReduceByteArray = Assignments.toBytes((Set)calculatedSwitchReduce, (long)catalogTimestamp);
            byte[] switchAppendByteArray = Assignments.toBytes((Set)calculatedSwitchAppend, (long)catalogTimestamp);
            if (!calculatedSwitchAppend.isEmpty()) {
                successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])stableFromRaftByteArray), Operations.put((ByteArray)pendingPartAssignmentsKey, (byte[])additionByteArray), Operations.put((ByteArray)switchReduceKey, (byte[])switchReduceByteArray), Operations.put((ByteArray)switchAppendKey, (byte[])switchAppendByteArray), assignmentChainChangeOp}).yield(1);
                failCase = Operations.ops((Operation[])new Operation[0]).yield(-1);
            } else if (!calculatedSwitchReduce.isEmpty()) {
                successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])stableFromRaftByteArray), Operations.put((ByteArray)pendingPartAssignmentsKey, (byte[])reductionByteArray), Operations.put((ByteArray)switchReduceKey, (byte[])switchReduceByteArray), Operations.put((ByteArray)switchAppendKey, (byte[])switchAppendByteArray), assignmentChainChangeOp}).yield(2);
                failCase = Operations.ops((Operation[])new Operation[0]).yield(-2);
            } else {
                SimpleCondition con5;
                if (plannedEntry.value() != null) {
                    con5 = Conditions.revision((ByteArray)plannedPartAssignmentsKey).eq(plannedEntry.revision());
                    successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])stableFromRaftByteArray), Operations.put((ByteArray)pendingPartAssignmentsKey, (byte[])plannedEntry.value()), Operations.remove((ByteArray)plannedPartAssignmentsKey), assignmentChainChangeOp}).yield(3);
                    failCase = Operations.ops((Operation[])new Operation[0]).yield(-3);
                } else {
                    con5 = Conditions.notExists((ByteArray)plannedPartAssignmentsKey);
                    successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])stableFromRaftByteArray), Operations.remove((ByteArray)pendingPartAssignmentsKey), assignmentChainChangeOp}).yield(4);
                    failCase = Operations.ops((Operation[])new Operation[0]).yield(-4);
                }
                retryPreconditions = Conditions.and((Condition)retryPreconditions, (Condition)con5);
            }
            int res = ((StatementResult)metaStorageMgr.invoke(Statements.iif((Condition)retryPreconditions, (Update)successCase, (Update)failCase)).get()).getAsInt();
            if (res < 0) {
                switch (res) {
                    case -1: {
                        LOG.info("Rebalance keys changed while trying to update rebalance pending addition information. Going to retry [tablePartitionID={}, appliedPeers={}]", new Object[]{tablePartitionId, stableFromRaft});
                        break;
                    }
                    case -2: {
                        LOG.info("Rebalance keys changed while trying to update rebalance pending reduce information. Going to retry [tablePartitionID={}, appliedPeers={}]", new Object[]{tablePartitionId, stableFromRaft});
                        break;
                    }
                    case -4: 
                    case -3: {
                        LOG.info("Rebalance keys changed while trying to update rebalance information. Going to retry [tablePartitionId={}, appliedPeers={}]", new Object[]{tablePartitionId, stableFromRaft});
                        break;
                    }
                    default: {
                        assert (false) : res;
                        break;
                    }
                }
                RebalanceRaftGroupEventsListener.doStableKeySwitch(stableFromRaft, tablePartitionId, metaStorageMgr, calculateAssignmentsFn);
                return;
            }
            switch (res) {
                case 1: {
                    LOG.info("Rebalance finished. Going to schedule next rebalance with addition [tablePartitionId={}, appliedPeers={}, plannedPeers={}]", new Object[]{tablePartitionId, stableFromRaft, calculatedPendingAddition});
                    break;
                }
                case 2: {
                    LOG.info("Rebalance finished. Going to schedule next rebalance with reduction [tablePartitionId={}, appliedPeers={}, plannedPeers={}]", new Object[]{tablePartitionId, stableFromRaft, calculatedPendingReduction});
                    break;
                }
                case 3: {
                    LOG.info("Rebalance finished. Going to schedule next rebalance [tablePartitionId={}, appliedPeers={}, plannedPeers={}]", new Object[]{tablePartitionId, stableFromRaft, Assignments.fromBytes((byte[])plannedEntry.value()).nodes()});
                    break;
                }
                case 4: {
                    LOG.info("Rebalance finished [tablePartitionId={}, appliedPeers={}]", new Object[]{tablePartitionId, stableFromRaft});
                    break;
                }
                default: {
                    assert (false) : res;
                    break;
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Unable to commit partition configuration to metastore: " + String.valueOf(tablePartitionId), (Throwable)e);
        }
    }

    private static Operation handleAssignmentsChainChange(ByteArray assignmentsChainKey, Entry assignmentsChainEntry, Assignments pendingAssignments, Assignments stableAssignments) {
        if (assignmentsChainEntry.value() != null) {
            AssignmentsChain updatedAssignmentsChain = RebalanceRaftGroupEventsListener.updateAssignmentsChain(AssignmentsChain.fromBytes((byte[])assignmentsChainEntry.value()), stableAssignments, pendingAssignments);
            return Operations.put((ByteArray)assignmentsChainKey, (byte[])updatedAssignmentsChain.toBytes());
        }
        return Operations.noop();
    }

    private static AssignmentsChain updateAssignmentsChain(AssignmentsChain assignmentsChain, Assignments newStable, Assignments pendingAssignments) {
        assert (assignmentsChain != null) : "Assignments chain cannot be null in HA mode.";
        assert (!assignmentsChain.chain().isEmpty()) : "Assignments chain cannot be empty on stable switch.";
        AssignmentsChain newAssignmentsChain = !pendingAssignments.force() && !pendingAssignments.fromReset() ? AssignmentsChain.of((Assignments)newStable) : (!pendingAssignments.force() && pendingAssignments.fromReset() ? assignmentsChain.replaceLast(newStable) : assignmentsChain.addLast(newStable));
        return newAssignmentsChain;
    }

    private static Set<Assignment> createAssignments(PeersAndLearners configuration) {
        Stream<Assignment> newAssignments = Stream.concat(configuration.peers().stream().map(peer -> Assignment.forPeer((String)peer.consistentId())), configuration.learners().stream().map(peer -> Assignment.forLearner((String)peer.consistentId())));
        return newAssignments.collect(Collectors.toSet());
    }

    private static Assignments readAssignments(Entry entry) {
        byte[] value = entry.value();
        return value == null ? Assignments.EMPTY : Assignments.fromBytes((byte[])value);
    }
}

