/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.ignite.internal.sql.engine.QueryCancelledException;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.ExceptionUtils;

public class RootNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT>,
Iterator<RowT> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private final Runnable onClose;
    private final AtomicReference<Throwable> ex = new AtomicReference();
    private final Function<RowT, RowT> converter;
    private int waiting;
    private Deque<RowT> inBuff = new ArrayDeque<RowT>(512);
    private Deque<RowT> outBuff = new ArrayDeque<RowT>(512);
    private volatile boolean closed;

    public RootNode(ExecutionContext<RowT> ctx) {
        this(ctx, Function.identity());
    }

    public RootNode(ExecutionContext<RowT> ctx, Function<RowT, RowT> converter) {
        super(ctx);
        this.converter = converter;
        this.onClose = this::closeInternal;
    }

    public RootNode(ExecutionContext<RowT> ctx, Function<RowT, RowT> converter, Runnable onClose) {
        super(ctx);
        this.converter = converter;
        this.onClose = onClose;
    }

    public UUID queryId() {
        return this.context().queryId();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.lock.lock();
        try {
            if (this.waiting != -1 || !this.outBuff.isEmpty()) {
                this.ex.compareAndSet(null, (Throwable)((Object)new QueryCancelledException()));
            }
            this.closed = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.onClose.run();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void closeInternal() {
        this.context().execute(() -> this.sources().forEach(Commons::closeQuiet), this::onError);
    }

    @Override
    public void push(RowT row) throws Exception {
        this.lock.lock();
        try {
            assert (this.waiting > 0);
            this.checkState();
            --this.waiting;
            this.inBuff.offer(row);
            if (this.inBuff.size() == 512) {
                this.cond.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.waiting > 0);
        this.lock.lock();
        try {
            this.checkState();
            this.waiting = -1;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onError(Throwable e) {
        if (!this.ex.compareAndSet(null, e)) {
            this.ex.get().addSuppressed(e);
        }
        Commons.closeQuiet(this);
    }

    @Override
    public boolean hasNext() {
        this.checkException();
        if (!this.outBuff.isEmpty()) {
            return true;
        }
        if (this.closed && this.ex.get() == null) {
            return false;
        }
        this.exchangeBuffers();
        return !this.outBuff.isEmpty();
    }

    @Override
    public RowT next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.converter.apply(this.outBuff.remove());
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public void onRegister(Downstream<RowT> downstream) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rewindInternal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void request(int rowsCnt) {
        throw new UnsupportedOperationException();
    }

    private void exchangeBuffers() {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        this.lock.lock();
        try {
            while (this.ex.get() == null) {
                assert (this.outBuff.isEmpty());
                if (this.inBuff.size() == 512 || this.waiting == -1) {
                    Deque<RowT> tmp = this.inBuff;
                    this.inBuff = this.outBuff;
                    this.outBuff = tmp;
                }
                if (this.waiting == -1 && this.outBuff.isEmpty()) {
                    this.close();
                } else if (this.inBuff.isEmpty() && this.waiting == 0) {
                    this.waiting = 512;
                    int req = 512;
                    this.context().execute(() -> this.source().request(req), this::onError);
                }
                if (!this.outBuff.isEmpty()) break;
                if (this.waiting == -1) {
                    break;
                }
                this.cond.await();
            }
        }
        catch (InterruptedException e) {
            throw new QueryCancelledException(e);
        }
        finally {
            this.lock.unlock();
        }
        this.checkException();
    }

    private void checkException() {
        Throwable e = this.ex.get();
        if (e == null) {
            return;
        }
        ExceptionUtils.sneakyThrow((Throwable)e);
    }
}

