/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.InternalSqlRowImpl;
import org.apache.ignite.internal.sql.engine.QueryPrefetchCallback;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.ExecutablePlan;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlProjection;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite.internal.sql.engine.prepare.ParameterMetadata;
import org.apache.ignite.internal.sql.engine.prepare.PlanId;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteSelectCount;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.util.Cloner;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.internal.util.AsyncWrapper;
import org.apache.ignite.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class SelectCountPlan
implements ExplainablePlan,
ExecutablePlan {
    private static final IgniteLogger LOG = Loggers.forClass(SelectCountPlan.class);
    private final PlanId id;
    private final int catalogVersion;
    private final IgniteSelectCount selectCountNode;
    private final List<RexNode> expressions;
    private final ResultSetMetadata metadata;
    private final ParameterMetadata parameterMetadata;

    SelectCountPlan(PlanId id, int catalogVersion, IgniteSelectCount getCount, ResultSetMetadata resultSetMetadata, ParameterMetadata parameterMetadata) {
        this.id = id;
        this.selectCountNode = getCount;
        this.expressions = getCount.expressions();
        this.catalogVersion = catalogVersion;
        this.metadata = resultSetMetadata;
        this.parameterMetadata = parameterMetadata;
    }

    public IgniteSelectCount selectCountNode() {
        return this.selectCountNode;
    }

    @Override
    public <RowT> AsyncCursor<InternalSqlRow> execute(ExecutionContext<RowT> ctx, InternalTransaction ignored, ExecutableTableRegistry tableRegistry, @Nullable QueryPrefetchCallback firstPageReadyCallback) {
        RelOptTable optTable = this.selectCountNode.getTable();
        IgniteTable igniteTable = (IgniteTable)optTable.unwrap(IgniteTable.class);
        assert (igniteTable != null);
        ExecutableTable execTable = tableRegistry.getTable(this.catalogVersion, igniteTable.id());
        CompletableFuture<Long> countFut = execTable.scannableTable().estimatedSize();
        Executor resultExecutor = task -> ctx.execute(task::run, error -> LOG.error("Unexpected error", error));
        CompletionStage result = countFut.thenApplyAsync(rs -> {
            Function<Long, Iterator<InternalSqlRow>> postProcess = this.createResultProjection(ctx);
            return postProcess.apply((Long)rs);
        }, resultExecutor);
        if (firstPageReadyCallback != null) {
            ((CompletableFuture)result).whenComplete((res, err) -> firstPageReadyCallback.onPrefetchComplete((Throwable)err));
        }
        ctx.scheduleTimeout((CompletableFuture<?>)result);
        return new AsyncWrapper((CompletableFuture)result, Runnable::run);
    }

    @Override
    public String explain() {
        IgniteRel clonedRoot = Cloner.clone(this.selectCountNode, Commons.cluster());
        return RelOptUtil.toString((RelNode)clonedRoot, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES);
    }

    @Override
    public PlanId id() {
        return this.id;
    }

    @Override
    public SqlQueryType type() {
        return SqlQueryType.QUERY;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ParameterMetadata parameterMetadata() {
        return this.parameterMetadata;
    }

    private <RowT> Function<Long, Iterator<InternalSqlRow>> createResultProjection(ExecutionContext<RowT> ctx) {
        RelDataType getCountType = new RelDataTypeFactory.Builder((RelDataTypeFactory)ctx.getTypeFactory()).add("ROWCOUNT", SqlTypeName.BIGINT).build();
        RelDataType resultType = this.selectCountNode.getRowType();
        SqlProjection projection = ctx.expressionFactory().project(this.expressions, getCountType);
        RowHandler rowHandler = ctx.rowHandler();
        BiFunction<Integer, Object, Object> internalTypeConverter = TypeUtils.resultTypeConverter(ctx, resultType);
        return rowCount -> {
            RowSchema rowSchema = RowSchema.builder().addField(NativeTypes.INT64).build();
            Object rowCountRow = ctx.rowHandler().factory(rowSchema).rowBuilder().addField(rowCount).build();
            Object projectRow = projection.project(ctx, rowCountRow);
            return List.of(new InternalSqlRowImpl(projectRow, rowHandler, internalTypeConverter)).iterator();
        };
    }
}

