/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomType;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomTypeCoercionRules;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomTypeSpec;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeSystem;
import org.apache.ignite.internal.sql.engine.type.UuidType;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteTypeFactory
extends JavaTypeFactoryImpl {
    private static final SqlIntervalQualifier INTERVAL_QUALIFIER_YEAR_MONTH = new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO);
    private static final SqlIntervalQualifier INTERVAL_QUALIFIER_DAY_TIME = new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO);
    public static final IgniteTypeFactory INSTANCE = new IgniteTypeFactory((RelDataTypeSystem)IgniteTypeSystem.INSTANCE);
    private final Map<Class<?>, Supplier<RelDataType>> implementedJavaTypes = new IdentityHashMap();
    private final Charset charset;
    private final CustomDataTypes customDataTypes;

    public IgniteTypeFactory(RelDataTypeSystem typeSystem) {
        super(typeSystem);
        this.implementedJavaTypes.put(LocalDate.class, () -> this.createTypeWithNullability(this.createSqlType(SqlTypeName.DATE), true));
        this.implementedJavaTypes.put(LocalTime.class, () -> this.createTypeWithNullability(this.createSqlType(SqlTypeName.TIME), true));
        this.implementedJavaTypes.put(LocalDateTime.class, () -> this.createTypeWithNullability(this.createSqlType(SqlTypeName.TIMESTAMP), true));
        this.implementedJavaTypes.put(Instant.class, () -> this.createTypeWithNullability(this.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE), true));
        this.implementedJavaTypes.put(Duration.class, () -> this.createTypeWithNullability(this.createSqlIntervalType(INTERVAL_QUALIFIER_DAY_TIME), true));
        this.implementedJavaTypes.put(Period.class, () -> this.createTypeWithNullability(this.createSqlIntervalType(INTERVAL_QUALIFIER_YEAR_MONTH), true));
        this.charset = SqlUtil.translateCharacterSetName((String)Charset.defaultCharset().name()) != null ? Charset.defaultCharset() : StandardCharsets.UTF_8;
        NewCustomType uuidType = new NewCustomType(UuidType.SPEC, (nullable, precision) -> new UuidType(nullable));
        uuidType.addCoercionRules(SqlTypeName.CHAR_TYPES);
        this.customDataTypes = new CustomDataTypes(Set.of(uuidType));
    }

    public Type getJavaClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType || type instanceof IgniteCustomType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: 
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: 
                case INTEGER: 
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case BIGINT: 
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return ByteString.class;
                }
                case GEOMETRY: {
                    throw new IllegalArgumentException("Type is not supported.");
                }
                case SYMBOL: {
                    return Enum.class;
                }
                case ANY: {
                    if (type instanceof IgniteCustomType) {
                        IgniteCustomType customType = (IgniteCustomType)type;
                        return customType.spec().storageType();
                    }
                }
                case OTHER: {
                    return Object.class;
                }
                case NULL: {
                    return Void.class;
                }
            }
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                return Object[].class;
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    public static NativeType relDataTypeToNative(RelDataType relType) {
        assert (relType instanceof BasicSqlType || relType instanceof IntervalSqlType || relType instanceof IgniteCustomType) : "Not supported:" + String.valueOf(relType);
        switch (relType.getSqlTypeName()) {
            case BOOLEAN: {
                return NativeTypes.BOOLEAN;
            }
            case TINYINT: {
                return NativeTypes.INT8;
            }
            case SMALLINT: {
                return NativeTypes.INT16;
            }
            case INTEGER: {
                return NativeTypes.INT32;
            }
            case BIGINT: {
                return NativeTypes.INT64;
            }
            case DECIMAL: {
                assert (relType.getPrecision() != -1);
                return NativeTypes.decimalOf((int)relType.getPrecision(), (int)relType.getScale());
            }
            case REAL: 
            case FLOAT: {
                return NativeTypes.FLOAT;
            }
            case DOUBLE: {
                return NativeTypes.DOUBLE;
            }
            case DATE: {
                return NativeTypes.DATE;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return NativeTypes.time((int)IgniteTypeFactory.precisionOrDefault(relType));
            }
            case TIMESTAMP: {
                return NativeTypes.datetime((int)IgniteTypeFactory.precisionOrDefault(relType));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return NativeTypes.timestamp((int)IgniteTypeFactory.precisionOrDefault(relType));
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                throw new IllegalArgumentException("Type is not supported yet: " + String.valueOf(relType));
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                throw new IllegalArgumentException("Type is not supported yet:" + String.valueOf(relType));
            }
            case VARCHAR: 
            case CHAR: {
                return relType.getPrecision() == -1 ? NativeTypes.stringOf((int)65536) : NativeTypes.stringOf((int)relType.getPrecision());
            }
            case BINARY: 
            case VARBINARY: {
                return relType.getPrecision() == -1 ? NativeTypes.blobOf((int)65536) : NativeTypes.blobOf((int)relType.getPrecision());
            }
            case ANY: {
                if (!(relType instanceof IgniteCustomType)) break;
                IgniteCustomType customType = (IgniteCustomType)relType;
                return customType.spec().nativeType();
            }
        }
        throw new IllegalArgumentException("Type is not supported: " + String.valueOf(relType));
    }

    private static int precisionOrDefault(RelDataType type) {
        if (type.getPrecision() == -1) {
            return IgniteTypeSystem.INSTANCE.getDefaultPrecision(type.getSqlTypeName());
        }
        return type.getPrecision();
    }

    public Type getResultClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType || type instanceof IgniteCustomType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: {
                    return LocalDate.class;
                }
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: {
                    return LocalTime.class;
                }
                case TIMESTAMP: {
                    return LocalDateTime.class;
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    return Instant.class;
                }
                case INTEGER: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return Period.class;
                }
                case BIGINT: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return Duration.class;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return byte[].class;
                }
                case GEOMETRY: {
                    throw new IllegalArgumentException("Type is not supported.");
                }
                case SYMBOL: {
                    return Enum.class;
                }
                case ANY: {
                    if (type instanceof IgniteCustomType) {
                        IgniteCustomType customType = (IgniteCustomType)type;
                        NativeType nativeType = customType.spec().nativeType();
                        return Commons.nativeTypeToClass(nativeType);
                    }
                }
                case OTHER: {
                    return Object.class;
                }
                case NULL: {
                    return Void.class;
                }
            }
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                return Object[].class;
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    @Nullable
    public RelDataType leastRestrictive(List<RelDataType> types) {
        assert (types != null);
        assert (!types.isEmpty());
        if (types.size() == 1 || this.allEquals(types)) {
            return (RelDataType)CollectionUtils.first(types);
        }
        RelDataType resultType = super.leastRestrictive(types);
        if (resultType == null) {
            return null;
        }
        if (resultType.getSqlTypeName() != SqlTypeName.ANY) {
            if (!TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this, types)) {
                return null;
            }
            return resultType;
        }
        assert (resultType instanceof BasicSqlType) : "leastRestrictive is expected to return a new instance of a type: " + String.valueOf(resultType);
        IgniteCustomType firstCustomType = null;
        boolean hasAnyType = false;
        boolean hasBuiltInType = false;
        boolean hasNullable = false;
        IgniteCustomType firstNullable = null;
        for (RelDataType type : types) {
            SqlTypeName sqlTypeName = type.getSqlTypeName();
            if (sqlTypeName == SqlTypeName.NULL) continue;
            if (type instanceof IgniteCustomType) {
                if (firstCustomType == null) {
                    firstCustomType = (IgniteCustomType)type;
                } else {
                    IgniteCustomType customType = (IgniteCustomType)type;
                    if (!Objects.equals(firstCustomType.getCustomTypeName(), customType.getCustomTypeName())) {
                        return null;
                    }
                }
                if (!type.isNullable() || firstNullable != null) continue;
                hasNullable = type.isNullable();
                firstNullable = (IgniteCustomType)type;
                continue;
            }
            if (sqlTypeName == SqlTypeName.ANY) {
                hasAnyType = true;
                continue;
            }
            hasBuiltInType = true;
        }
        if (hasAnyType && hasBuiltInType && firstCustomType != null) {
            return null;
        }
        if (hasAnyType && hasBuiltInType || hasAnyType && firstCustomType != null) {
            return resultType;
        }
        if (firstCustomType != null && !hasBuiltInType) {
            return hasNullable ? firstNullable : firstCustomType;
        }
        return null;
    }

    public Charset getDefaultCharset() {
        return this.charset;
    }

    public RelDataType toSql(RelDataType type) {
        Class clazz;
        Supplier<RelDataType> javaType;
        if (type instanceof RelDataTypeFactoryImpl.JavaType && (javaType = this.implementedJavaTypes.get(clazz = ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass())) != null) {
            return javaType.get();
        }
        return super.toSql(type);
    }

    public RelDataType createType(Type type) {
        if (this.implementedJavaTypes.containsKey(type)) {
            return this.createJavaType((Class)type);
        }
        if (this.customDataTypes.javaTypes.contains(type)) {
            throw new IllegalArgumentException("Custom data type should not be created via createType call: " + String.valueOf(type));
        }
        return super.createType(type);
    }

    public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
        if (type instanceof IgniteCustomType) {
            return this.canonize((RelDataType)((IgniteCustomType)type).createWithNullability(nullable));
        }
        return super.createTypeWithNullability(type, nullable);
    }

    public RelDataType createJavaType(Class clazz) {
        if (this.customDataTypes.javaTypes.contains(clazz)) {
            throw new IllegalArgumentException("Custom data type should not be created via createJavaType call: " + String.valueOf(clazz));
        }
        return super.createJavaType(clazz);
    }

    public IgniteCustomType createCustomType(String typeName, int precision) {
        IgniteCustomTypeFactory customTypeFactory = this.customDataTypes.typeFactories.get(typeName);
        if (customTypeFactory == null) {
            throw new IllegalArgumentException("Unexpected custom data type: " + typeName);
        }
        IgniteCustomType customType = customTypeFactory.newType(false, precision);
        assert (!customType.isNullable()) : "makeCustomType must not return a nullable type: " + typeName + " " + String.valueOf((Object)customType);
        return (IgniteCustomType)this.canonize((RelDataType)customType);
    }

    public IgniteCustomType createCustomType(String typeName) {
        return this.createCustomType(typeName, -1);
    }

    public Map<String, IgniteCustomTypeSpec> getCustomTypeSpecs() {
        return this.customDataTypes.typeSpecs;
    }

    public IgniteCustomTypeCoercionRules getCustomTypeCoercionRules() {
        return this.customDataTypes.typeCoercionRules;
    }

    private boolean allEquals(List<RelDataType> types) {
        assert (types.size() > 1);
        RelDataType first = (RelDataType)CollectionUtils.first(types);
        for (int i = 1; i < types.size(); ++i) {
            if (Objects.equals(first, types.get(i))) continue;
            return false;
        }
        return true;
    }

    private static final class NewCustomType {
        final IgniteCustomTypeSpec spec;
        final IgniteCustomTypeFactory typeFactory;
        final Set<SqlTypeName> canBeCoercedTo = EnumSet.noneOf(SqlTypeName.class);

        NewCustomType(IgniteCustomTypeSpec spec, IgniteCustomTypeFactory typeFactory) {
            this.spec = spec;
            this.typeFactory = typeFactory;
        }

        void addCoercionRules(Collection<SqlTypeName> types) {
            this.canBeCoercedTo.addAll(types);
        }
    }

    @FunctionalInterface
    static interface IgniteCustomTypeFactory {
        public IgniteCustomType newType(boolean var1, int var2);
    }

    private static final class CustomDataTypes {
        private final Set<Type> javaTypes;
        private final Map<String, IgniteCustomTypeFactory> typeFactories;
        private final Map<String, IgniteCustomTypeSpec> typeSpecs;
        private final IgniteCustomTypeCoercionRules typeCoercionRules;

        CustomDataTypes(Set<NewCustomType> customDataTypes) {
            this.javaTypes = customDataTypes.stream().map(t -> t.spec.storageType()).collect(Collectors.toSet());
            this.typeSpecs = customDataTypes.stream().map(t -> Map.entry(t.spec.typeName(), t.spec)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.typeFactories = customDataTypes.stream().collect(Collectors.toMap(v -> v.spec.typeName(), v -> v.typeFactory));
            IgniteCustomTypeCoercionRules.Builder builder = IgniteCustomTypeCoercionRules.builder();
            for (NewCustomType newType : customDataTypes) {
                builder.addRules(newType.spec.typeName(), newType.canBeCoercedTo);
            }
            this.typeCoercionRules = builder.build(this.typeSpecs);
        }
    }
}

