/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.catalog.CatalogToSchemaDescriptorConverter;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.apache.ignite.internal.schema.mapping.ColumnMapping;

public class SchemaUtils {
    public static SchemaDescriptor prepareSchemaDescriptor(CatalogTableDescriptor tableDescriptor) {
        return CatalogToSchemaDescriptorConverter.convert(tableDescriptor, tableDescriptor.tableVersion());
    }

    public static ColumnMapper columnMapper(SchemaDescriptor oldDesc, SchemaDescriptor newDesc) {
        List<Column> oldCols = oldDesc.columns();
        List<Column> newCols = newDesc.columns();
        ColumnMapper mapper = null;
        for (int i = 0; i < newCols.size(); ++i) {
            Column newCol = newCols.get(i);
            if (i < oldCols.size()) {
                Column oldIdx;
                Column oldCol = oldCols.get(i);
                if (newCol.positionInRow() == oldCol.positionInRow()) {
                    if (newCol.name().equals(oldCol.name())) continue;
                    if (mapper == null) {
                        mapper = ColumnMapping.createMapper(newDesc);
                    }
                    if ((oldIdx = oldDesc.column(newCol.name())) == null) continue;
                    mapper.add(newCol.positionInRow(), oldIdx.positionInRow());
                    continue;
                }
                if (mapper == null) {
                    mapper = ColumnMapping.createMapper(newDesc);
                }
                if (newCol.name().equals(oldCol.name())) {
                    mapper.add(newCol.positionInRow(), oldCol.positionInRow());
                    continue;
                }
                oldIdx = oldDesc.column(newCol.name());
                assert (oldIdx != null) : newCol.name();
                mapper.add(newCol.positionInRow(), oldIdx.positionInRow());
                continue;
            }
            if (mapper == null) {
                mapper = ColumnMapping.createMapper(newDesc);
            }
            mapper.add(newCol);
        }
        return mapper == null ? ColumnMapping.identityMapping() : mapper;
    }

    public static boolean equalSchemas(SchemaDescriptor exp, SchemaDescriptor actual) {
        if (exp.columns().size() != actual.columns().size()) {
            return false;
        }
        for (int i = 0; i < exp.length(); ++i) {
            if (exp.column(i).equals(actual.column(i))) continue;
            return false;
        }
        return true;
    }
}

