/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.DataRegion;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.configuration.schema.PageMemoryCheckpointConfiguration;
import org.apache.ignite.internal.pagememory.configuration.schema.PageMemoryCheckpointView;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.persistence.CheckpointUrgency;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointDirtyPages;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointPagesWriterFactory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointReadWriteLock;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointWorkflow;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.Checkpointer;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.ReentrantReadWriteLockWithTracking;
import org.apache.ignite.internal.pagememory.persistence.compaction.Compactor;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.worker.IgniteWorkerListener;
import org.jetbrains.annotations.Nullable;

public class CheckpointManager {
    private final Checkpointer checkpointer;
    private final CheckpointWorkflow checkpointWorkflow;
    private final CheckpointTimeoutLock checkpointTimeoutLock;
    private final CheckpointPagesWriterFactory checkpointPagesWriterFactory;
    private final FilePageStoreManager filePageStoreManager;
    private final Compactor compactor;

    public CheckpointManager(String igniteInstanceName, @Nullable IgniteWorkerListener workerListener, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, PageMemoryCheckpointConfiguration checkpointConfig, FilePageStoreManager filePageStoreManager, PartitionMetaManager partitionMetaManager, Collection<? extends DataRegion<PersistentPageMemory>> dataRegions, PageIoRegistry ioRegistry, LogSyncer logSyncer, int pageSize) throws IgniteInternalCheckedException {
        this.filePageStoreManager = filePageStoreManager;
        PageMemoryCheckpointView checkpointConfigView = (PageMemoryCheckpointView)checkpointConfig.value();
        long logReadLockThresholdTimeout = checkpointConfigView.logReadLockThresholdTimeout();
        ReentrantReadWriteLockWithTracking reentrantReadWriteLockWithTracking = logReadLockThresholdTimeout > 0L ? new ReentrantReadWriteLockWithTracking(Loggers.forClass(CheckpointReadWriteLock.class), logReadLockThresholdTimeout) : new ReentrantReadWriteLockWithTracking();
        CheckpointReadWriteLock checkpointReadWriteLock = new CheckpointReadWriteLock(reentrantReadWriteLockWithTracking);
        this.checkpointWorkflow = new CheckpointWorkflow(igniteInstanceName, checkpointReadWriteLock, dataRegions, checkpointConfigView.checkpointThreads());
        this.checkpointPagesWriterFactory = new CheckpointPagesWriterFactory((pageMemory, fullPageId, pageBuf) -> this.writePageToDeltaFilePageStore(pageMemory, fullPageId, pageBuf, true), ioRegistry, partitionMetaManager, pageSize);
        this.compactor = new Compactor(Loggers.forClass(Compactor.class), igniteInstanceName, workerListener, checkpointConfig.compactionThreads(), filePageStoreManager, pageSize, failureManager);
        this.checkpointer = new Checkpointer(igniteInstanceName, workerListener, longJvmPauseDetector, failureManager, this.checkpointWorkflow, this.checkpointPagesWriterFactory, filePageStoreManager, this.compactor, pageSize, checkpointConfig, logSyncer);
        this.checkpointTimeoutLock = new CheckpointTimeoutLock(checkpointReadWriteLock, checkpointConfigView.readLockTimeout(), () -> CheckpointManager.checkpointUrgency(dataRegions), this.checkpointer, failureManager);
    }

    public void start() {
        this.checkpointWorkflow.start();
        this.checkpointer.start();
        this.checkpointTimeoutLock.start();
        this.compactor.start();
    }

    public void stop() throws Exception {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[4];
        autoCloseableArray[0] = this.checkpointTimeoutLock::stop;
        autoCloseableArray[1] = this.checkpointer::stop;
        autoCloseableArray[2] = this.checkpointWorkflow::stop;
        autoCloseableArray[3] = this.compactor::stop;
        IgniteUtils.closeAll((AutoCloseable[])autoCloseableArray);
    }

    public CheckpointTimeoutLock checkpointTimeoutLock() {
        return this.checkpointTimeoutLock;
    }

    public void addCheckpointListener(CheckpointListener listener, @Nullable DataRegion<PersistentPageMemory> dataRegion) {
        this.checkpointWorkflow.addCheckpointListener(listener, dataRegion);
    }

    public void removeCheckpointListener(CheckpointListener listener) {
        this.checkpointWorkflow.removeCheckpointListener(listener);
    }

    public CheckpointProgress forceCheckpoint(String reason) {
        return this.checkpointer.scheduleCheckpoint(0L, reason);
    }

    public CheckpointProgress scheduleCheckpoint(long delayMillis, String reason) {
        return this.checkpointer.scheduleCheckpoint(delayMillis, reason);
    }

    @Nullable
    public CheckpointProgress lastCheckpointProgress() {
        return this.checkpointer.lastCheckpointProgress();
    }

    public void markPartitionAsDirty(DataRegion<?> dataRegion, int groupId, int partitionId) {
        this.checkpointer.markPartitionAsDirty(dataRegion, groupId, partitionId);
    }

    static CheckpointUrgency checkpointUrgency(Collection<? extends DataRegion<PersistentPageMemory>> dataRegions) {
        CheckpointUrgency urgency = CheckpointUrgency.NOT_REQUIRED;
        for (DataRegion<PersistentPageMemory> dataRegion : dataRegions) {
            CheckpointUrgency regionCheckpointUrgency = dataRegion.pageMemory().checkpointUrgency();
            if (regionCheckpointUrgency.compareTo(urgency) > 0) {
                urgency = regionCheckpointUrgency;
            }
            if (urgency != CheckpointUrgency.MUST_TRIGGER) continue;
            return CheckpointUrgency.MUST_TRIGGER;
        }
        return urgency;
    }

    public void writePageToDeltaFilePageStore(PersistentPageMemory pageMemory, FullPageId pageId, ByteBuffer pageBuf, boolean calculateCrc) throws IgniteInternalCheckedException {
        FilePageStore filePageStore = this.filePageStoreManager.getStore(new GroupPartitionId(pageId.groupId(), pageId.partitionId()));
        if (filePageStore == null || filePageStore.isMarkedToDestroy()) {
            return;
        }
        CheckpointProgress lastCheckpointProgress = this.lastCheckpointProgress();
        assert (lastCheckpointProgress != null) : "Checkpoint has not happened yet";
        assert (lastCheckpointProgress.inProgress()) : "Checkpoint must be in progress";
        CheckpointDirtyPages pagesToWrite = lastCheckpointProgress.pagesToWrite();
        assert (pagesToWrite != null) : "Dirty pages must be sorted out";
        CompletableFuture<DeltaFilePageStoreIo> deltaFilePageStoreFuture = filePageStore.getOrCreateNewDeltaFile(index -> this.filePageStoreManager.tmpDeltaFilePageStorePath(pageId.groupId(), pageId.partitionId(), index), () -> {
            CheckpointDirtyPages.CheckpointDirtyPagesView partitionView = pagesToWrite.getPartitionView(pageMemory, pageId.groupId(), pageId.partitionId());
            assert (partitionView != null) : String.format("Unable to find view for dirty pages: [patitionId=%s, pageMemory=%s]", GroupPartitionId.convert(pageId), pageMemory);
            return CheckpointManager.pageIndexesForDeltaFilePageStore(partitionView);
        });
        deltaFilePageStoreFuture.join().write(pageId.pageId(), pageBuf, calculateCrc);
    }

    static int[] pageIndexesForDeltaFilePageStore(CheckpointDirtyPages.CheckpointDirtyPagesView partitionDirtyPages) {
        int offset = partitionDirtyPages.get(0).pageIdx() == 0 ? 0 : 1;
        int[] pageIndexes = new int[partitionDirtyPages.size() + offset];
        for (int i = 0; i < partitionDirtyPages.size(); ++i) {
            pageIndexes[i + offset] = partitionDirtyPages.get(i).pageIdx();
        }
        return pageIndexes;
    }

    public void triggerCompaction() {
        this.compactor.triggerCompaction();
    }

    public CompletableFuture<Void> onPartitionDestruction(GroupPartitionId groupPartitionId) {
        return CompletableFuture.allOf(this.checkpointer.prepareToDestroyPartition(groupPartitionId), this.compactor.prepareToDestroyPartition(groupPartitionId));
    }
}

