/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.ReentrantReadWriteLockWithTracking;

public class CheckpointReadWriteLock {
    static final String CHECKPOINT_RUNNER_THREAD_PREFIX = "checkpoint-runner";
    private final ThreadLocal<Integer> checkpointReadLockHoldCount = ThreadLocal.withInitial(() -> 0);
    private final ReentrantReadWriteLockWithTracking checkpointLock;

    public CheckpointReadWriteLock(ReentrantReadWriteLockWithTracking checkpointLock) {
        this.checkpointLock = checkpointLock;
    }

    public void readLock() {
        if (this.isWriteLockHeldByCurrentThread()) {
            return;
        }
        this.checkpointLock.readLock().lock();
        this.checkpointReadLockHoldCount.set(this.checkpointReadLockHoldCount.get() + 1);
    }

    public boolean tryReadLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isWriteLockHeldByCurrentThread()) {
            return true;
        }
        boolean res = this.checkpointLock.readLock().tryLock(timeout, unit);
        if (res) {
            this.checkpointReadLockHoldCount.set(this.checkpointReadLockHoldCount.get() + 1);
        }
        return res;
    }

    public boolean tryReadLock() {
        if (this.isWriteLockHeldByCurrentThread()) {
            return true;
        }
        boolean res = this.checkpointLock.readLock().tryLock();
        if (res) {
            this.checkpointReadLockHoldCount.set(this.checkpointReadLockHoldCount.get() + 1);
        }
        return res;
    }

    public boolean checkpointLockIsHeldByThread() {
        return this.checkpointLock.isWriteLockedByCurrentThread() || this.checkpointReadLockHoldCount.get() > 0 || Thread.currentThread().getName().startsWith(CHECKPOINT_RUNNER_THREAD_PREFIX);
    }

    public void readUnlock() {
        if (this.isWriteLockHeldByCurrentThread()) {
            return;
        }
        this.checkpointLock.readLock().unlock();
        this.checkpointReadLockHoldCount.set(this.checkpointReadLockHoldCount.get() - 1);
    }

    public void writeLock() {
        this.checkpointLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.checkpointLock.writeLock().unlock();
    }

    public boolean isWriteLockHeldByCurrentThread() {
        return this.checkpointLock.isWriteLockedByCurrentThread();
    }

    public int getReadHoldCount() {
        return this.checkpointLock.getReadHoldCount();
    }
}

