/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.CreateTableEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class NewTableEntry
implements UpdateEntry,
Fireable {
    public static final CatalogObjectSerializer<NewTableEntry> SERIALIZER = new NewTableEntrySerializer();
    private final CatalogTableDescriptor descriptor;

    public NewTableEntry(CatalogTableDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogTableDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_TABLE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_CREATE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new CreateTableEventParameters(causalityToken, catalogVersion, this.descriptor);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.descriptor.schemaId());
        this.descriptor.updateToken(causalityToken);
        List<CatalogSchemaDescriptor> schemas = CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), (CatalogTableDescriptor[])ArrayUtils.concat((Object[])schema.tables(), (Object[])new CatalogTableDescriptor[]{this.descriptor}), schema.indexes(), schema.systemViews(), causalityToken), catalog.schemas());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), schemas, CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class NewTableEntrySerializer
    implements CatalogObjectSerializer<NewTableEntry> {
        private NewTableEntrySerializer() {
        }

        @Override
        public NewTableEntry readFrom(IgniteDataInput input) throws IOException {
            CatalogTableDescriptor descriptor = CatalogTableDescriptor.SERIALIZER.readFrom(input);
            return new NewTableEntry(descriptor);
        }

        @Override
        public void writeTo(NewTableEntry entry, IgniteDataOutput output) throws IOException {
            CatalogTableDescriptor.SERIALIZER.writeTo(entry.descriptor(), output);
        }
    }
}

