/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaResponse;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.impl.RemotelyTriggeredResourceRegistry;
import org.apache.ignite.internal.tx.impl.WriteIntentSwitchProcessor;
import org.apache.ignite.internal.tx.message.CleanupReplicatedInfo;
import org.apache.ignite.internal.tx.message.CleanupReplicatedInfoMessage;
import org.apache.ignite.internal.tx.message.TxCleanupMessage;
import org.apache.ignite.internal.tx.message.TxMessageGroup;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicatedInfo;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class TxCleanupRequestHandler {
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final MessagingService messagingService;
    private final LockManager lockManager;
    private final ClockService clockService;
    private final WriteIntentSwitchProcessor writeIntentSwitchProcessor;
    private final RemotelyTriggeredResourceRegistry remotelyTriggeredResourceRegistry;
    private final ConcurrentMap<UUID, CleanupContext> writeIntentsReplicated = new ConcurrentHashMap<UUID, CleanupContext>();

    public TxCleanupRequestHandler(MessagingService messagingService, LockManager lockManager, ClockService clockService, WriteIntentSwitchProcessor writeIntentSwitchProcessor, RemotelyTriggeredResourceRegistry resourcesRegistry) {
        this.messagingService = messagingService;
        this.lockManager = lockManager;
        this.clockService = clockService;
        this.writeIntentSwitchProcessor = writeIntentSwitchProcessor;
        this.remotelyTriggeredResourceRegistry = resourcesRegistry;
    }

    public void start() {
        this.messagingService.addMessageHandler(TxMessageGroup.class, (msg, sender, correlationId) -> {
            if (msg instanceof TxCleanupMessage) {
                this.processTxCleanup((TxCleanupMessage)msg, sender, correlationId);
            }
        });
    }

    public void stop() {
    }

    private void processTxCleanup(TxCleanupMessage txCleanupMessage, ClusterNode sender, @Nullable Long correlationId) {
        assert (correlationId != null);
        HashMap<TablePartitionId, CompletionStage> writeIntentSwitches = new HashMap<TablePartitionId, CompletionStage>();
        List<TablePartitionIdMessage> groups = txCleanupMessage.groups();
        if (groups != null) {
            Set<TablePartitionId> groupSet = TxCleanupRequestHandler.asTablePartitionIdSet(groups);
            this.trackPartitions(txCleanupMessage.txId(), groupSet, sender);
            for (TablePartitionId group : groupSet) {
                CompletionStage future = this.writeIntentSwitchProcessor.switchLocalWriteIntents(group, txCleanupMessage.txId(), txCleanupMessage.commit(), txCleanupMessage.commitTimestamp()).thenAccept(this::processWriteIntentSwitchResponse);
                writeIntentSwitches.put(group, future);
            }
        }
        CompletableFuture.allOf(writeIntentSwitches.values().toArray(new CompletableFuture[0])).whenComplete((unused, ex) -> {
            NetworkMessage msg;
            this.releaseTxLocks(txCleanupMessage.txId());
            this.remotelyTriggeredResourceRegistry.close(txCleanupMessage.txId());
            if (ex == null) {
                msg = this.prepareResponse();
            } else {
                msg = this.prepareErrorResponse(txCleanupMessage.txId(), (Throwable)ex);
                writeIntentSwitches.forEach((groupId, future) -> {
                    if (future.isCompletedExceptionally()) {
                        this.writeIntentSwitchProcessor.switchWriteIntentsWithRetry(txCleanupMessage.commit(), txCleanupMessage.commitTimestamp(), txCleanupMessage.txId(), (TablePartitionId)groupId).thenAccept(this::processWriteIntentSwitchResponse);
                    }
                });
            }
            this.messagingService.respond(sender, msg, correlationId.longValue());
        });
    }

    private void releaseTxLocks(UUID txId) {
        this.lockManager.releaseAll(txId);
    }

    private NetworkMessage prepareResponse() {
        return TX_MESSAGES_FACTORY.txCleanupMessageResponse().timestamp(this.clockService.now()).build();
    }

    private NetworkMessage prepareResponse(CleanupReplicatedInfo result) {
        return TX_MESSAGES_FACTORY.txCleanupMessageResponse().result(TxCleanupRequestHandler.toCleanupReplicatedInfoMessage(result)).timestamp(this.clockService.now()).build();
    }

    private NetworkMessage prepareErrorResponse(UUID txId, Throwable th) {
        return TX_MESSAGES_FACTORY.txCleanupMessageErrorResponse().txId(txId).throwable(th).timestamp(this.clockService.now()).build();
    }

    private void trackPartitions(UUID txId, Set<TablePartitionId> groups, ClusterNode sender) {
        this.writeIntentsReplicated.put(txId, new CleanupContext(sender, groups, groups));
    }

    private void processWriteIntentSwitchResponse(ReplicaResponse response) {
        if (response == null) {
            return;
        }
        Object result = response.result();
        assert (result instanceof WriteIntentSwitchReplicatedInfo) : "Unexpected type of cleanup replication response: [result=" + String.valueOf(result) + "].";
        this.writeIntentSwitchReplicated((WriteIntentSwitchReplicatedInfo)result);
    }

    void writeIntentSwitchReplicated(WriteIntentSwitchReplicatedInfo info) {
        CleanupContext cleanupContext = this.writeIntentsReplicated.computeIfPresent(info.txId(), (uuid, context) -> {
            HashSet<TablePartitionId> partitions = new HashSet<TablePartitionId>(context.partitions);
            partitions.remove(info.partitionId());
            return new CleanupContext(context.sender, partitions, context.initialPartitions);
        });
        if (cleanupContext != null && cleanupContext.partitions.isEmpty()) {
            this.sendCleanupReplicatedResponse(info.txId(), cleanupContext.sender, cleanupContext.initialPartitions);
            this.writeIntentsReplicated.remove(info.txId());
        }
    }

    private void sendCleanupReplicatedResponse(UUID txId, ClusterNode sender, Collection<TablePartitionId> partitions) {
        this.messagingService.send(sender, ChannelType.DEFAULT, this.prepareResponse(new CleanupReplicatedInfo(txId, partitions)));
    }

    private static CleanupReplicatedInfoMessage toCleanupReplicatedInfoMessage(CleanupReplicatedInfo info) {
        Collection<TablePartitionId> partitions = info.partitions();
        ArrayList<TablePartitionIdMessage> partitionMessages = new ArrayList<TablePartitionIdMessage>(partitions.size());
        for (TablePartitionId partition : partitions) {
            partitionMessages.add(ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)partition));
        }
        return TX_MESSAGES_FACTORY.cleanupReplicatedInfoMessage().txId(info.txId()).partitions(partitionMessages).build();
    }

    private static Set<TablePartitionId> asTablePartitionIdSet(List<TablePartitionIdMessage> messages) {
        HashSet<TablePartitionId> set = new HashSet<TablePartitionId>(messages.size());
        for (int i = 0; i < messages.size(); ++i) {
            set.add(messages.get(i).asTablePartitionId());
        }
        return set;
    }

    private static class CleanupContext {
        private final ClusterNode sender;
        private final Set<TablePartitionId> partitions;
        private final Set<TablePartitionId> initialPartitions;

        public CleanupContext(ClusterNode sender, Set<TablePartitionId> partitions, Set<TablePartitionId> initialPartitions) {
            this.sender = sender;
            this.partitions = partitions;
            this.initialPartitions = initialPartitions;
        }
    }
}

