/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.tx.message.TxMetaMessage;
import org.apache.ignite.internal.tx.message.TxMetaMessageImpl;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class TxMetaMessageSerializer
implements MessageSerializer<TxMetaMessage> {
    public static final TxMetaMessageSerializer INSTANCE = new TxMetaMessageSerializer();

    private TxMetaMessageSerializer() {
    }

    public boolean writeMessage(TxMetaMessage msg, MessageWriter writer) throws MessageMappingException {
        TxMetaMessageImpl message = (TxMetaMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeHybridTimestamp("commitTimestamp", message.commitTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeList("enlistedPartitions", message.enlistedPartitions(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                int ordinalShifted = message.txState() == null ? 0 : message.txState().ordinal() + 1;
                boolean written = writer.writeInt("txState", ordinalShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

