/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.ClassDescriptorRegistry;
import org.apache.ignite.internal.network.serialization.Classes;
import org.apache.ignite.internal.network.serialization.FieldDescriptor;
import org.apache.ignite.internal.network.serialization.ReflectionException;
import org.apache.ignite.internal.network.serialization.Serialization;
import org.apache.ignite.internal.network.serialization.SerializationType;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class ClassDescriptorFactory {
    private static final boolean NO_WRITE_OBJECT = false;
    private static final boolean NO_READ_OBJECT = false;
    private static final boolean NO_READ_OBJECT_NO_DATA = false;
    private final ClassDescriptorRegistry registry;

    public ClassDescriptorFactory(ClassDescriptorRegistry registry) {
        this.registry = registry;
    }

    public ClassDescriptor create(Class<?> clazz) {
        ClassDescriptor classDesc = this.create0(clazz);
        this.registry.addDescriptor(clazz, classDesc);
        ArrayDeque<FieldDescriptor> fieldDescriptors = new ArrayDeque<FieldDescriptor>(classDesc.fields());
        while (!fieldDescriptors.isEmpty()) {
            FieldDescriptor fieldDescriptor = (FieldDescriptor)fieldDescriptors.remove();
            int typeDescriptorId = fieldDescriptor.typeDescriptorId();
            if (this.registry.hasDescriptor(typeDescriptorId)) continue;
            Class<?> fieldClass = fieldDescriptor.localClass();
            ClassDescriptor fieldClassDesc = this.create0(fieldClass);
            this.registry.addDescriptor(fieldClass, fieldClassDesc);
            fieldDescriptors.addAll(fieldClassDesc.fields());
        }
        return classDesc;
    }

    private ClassDescriptor create0(Class<?> clazz) {
        assert (!clazz.isPrimitive()) : String.valueOf(clazz) + " is a primitive, there should be a default descriptor";
        int descriptorId = this.registry.getId(clazz);
        if (Classes.isExternalizable(clazz)) {
            return this.externalizable(descriptorId, clazz);
        }
        if (Classes.isSerializable(clazz)) {
            return this.serializable(descriptorId, clazz);
        }
        return this.arbitrary(descriptorId, clazz);
    }

    private ClassDescriptor externalizable(int descriptorId, Class<? extends Externalizable> clazz) {
        ClassDescriptorFactory.checkHasPublicNoArgConstructor(clazz);
        return ClassDescriptor.forLocal(clazz, descriptorId, this.superClassDescriptor(clazz), this.componentTypeDescriptor(clazz), this.fields(clazz), new Serialization(SerializationType.EXTERNALIZABLE, false, false, false, Classes.hasWriteReplace(clazz), ClassDescriptorFactory.hasReadResolve(clazz)));
    }

    @Nullable
    private ClassDescriptor superClassDescriptor(Class<?> clazz) {
        if (Enum.class.isAssignableFrom(clazz)) {
            return null;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || superclass == Object.class) {
            return null;
        }
        return this.getOrCreate(superclass);
    }

    private ClassDescriptor getOrCreate(Class<?> clazz) {
        ClassDescriptor existingDescriptor = this.registry.getDescriptor(clazz);
        if (existingDescriptor != null) {
            return existingDescriptor;
        }
        return this.create(clazz);
    }

    @Nullable
    private ClassDescriptor componentTypeDescriptor(Class<?> clazz) {
        Class<?> componentType = clazz.getComponentType();
        if (componentType == null) {
            return null;
        }
        return this.getOrCreate(componentType);
    }

    private static void checkHasPublicNoArgConstructor(Class<? extends Externalizable> clazz) throws IgniteException {
        boolean hasPublicNoArgConstructor = true;
        try {
            Constructor<? extends Externalizable> ctor = clazz.getConstructor(new Class[0]);
            if (!Modifier.isPublic(ctor.getModifiers())) {
                hasPublicNoArgConstructor = false;
            }
        }
        catch (NoSuchMethodException e) {
            hasPublicNoArgConstructor = false;
        }
        if (!hasPublicNoArgConstructor) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Externalizable class " + clazz.getName() + " has no public no-arg constructor");
        }
    }

    private ClassDescriptor serializable(int descriptorId, Class<? extends Serializable> clazz) {
        return ClassDescriptor.forLocal(clazz, descriptorId, this.superClassDescriptor(clazz), this.componentTypeDescriptor(clazz), this.fields(clazz), new Serialization(SerializationType.SERIALIZABLE, ClassDescriptorFactory.hasWriteObject(clazz), ClassDescriptorFactory.hasReadObject(clazz), ClassDescriptorFactory.hasReadObjectNoData(clazz), Classes.hasWriteReplace(clazz), ClassDescriptorFactory.hasReadResolve(clazz)));
    }

    private static boolean hasReadResolve(Class<? extends Serializable> clazz) {
        return Classes.getReadResolve(clazz) != null;
    }

    private static boolean hasReadObject(Class<? extends Serializable> clazz) {
        return ClassDescriptorFactory.getReadObject(clazz) != null;
    }

    private static boolean hasWriteObject(Class<? extends Serializable> clazz) {
        return ClassDescriptorFactory.getWriteObject(clazz) != null;
    }

    private static boolean hasReadObjectNoData(Class<? extends Serializable> clazz) {
        return ClassDescriptorFactory.getReadObjectNoData(clazz) != null;
    }

    private ClassDescriptor arbitrary(int descriptorId, Class<?> clazz) {
        return ClassDescriptor.forLocal(clazz, descriptorId, this.superClassDescriptor(clazz), this.componentTypeDescriptor(clazz), this.fields(clazz), new Serialization(SerializationType.ARBITRARY));
    }

    private List<FieldDescriptor> fields(Class<?> clazz) {
        return this.maybeSerialPersistentFields(clazz).orElseGet(() -> this.actualFields(clazz));
    }

    private Optional<List<FieldDescriptor>> maybeSerialPersistentFields(Class<?> clazz) {
        if (!Classes.isSerializable(clazz)) {
            return Optional.empty();
        }
        return this.maybeSerialPersistentFieldsField(clazz).filter(this::isPrivateStaticFinal).filter(field -> field.getType() == ObjectStreamField[].class).map(this::getFieldValue).map(ObjectStreamField[].class::cast).filter(this::noDuplicates).map(serialPersistentFields -> Arrays.stream(serialPersistentFields).map(field -> this.fieldDescriptorFromObjectStreamField((ObjectStreamField)field, clazz)).collect(Collectors.toList()));
    }

    private Optional<Field> maybeSerialPersistentFieldsField(Class<?> clazz) {
        try {
            Field field = clazz.getDeclaredField("serialPersistentFields");
            field.setAccessible(true);
            return Optional.of(field);
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    private boolean isPrivateStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPrivate(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    @Nullable
    private Object getFieldValue(Field serialPersistentFieldsField) {
        try {
            return serialPersistentFieldsField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("Cannot get field value", e);
        }
    }

    private boolean noDuplicates(ObjectStreamField[] fields) {
        Set allFieldNames = Arrays.stream(fields).map(ObjectStreamField::getName).collect(Collectors.toSet());
        return allFieldNames.size() == fields.length;
    }

    private FieldDescriptor fieldDescriptorFromObjectStreamField(ObjectStreamField field, Class<?> clazz) {
        return FieldDescriptor.local(field.getName(), field.getType(), this.registry.getId(field.getType()), field.isUnshared(), clazz);
    }

    private List<FieldDescriptor> actualFields(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).sorted(Comparator.comparing(Field::getName)).filter(field -> {
            int modifiers = field.getModifiers();
            return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
        }).map(field -> FieldDescriptor.local(field, this.registry.getId(field.getType()))).collect(Collectors.toList());
    }

    @Nullable
    private static Method getWriteObject(Class<? extends Serializable> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("writeObject", ObjectOutputStream.class);
            if (!Modifier.isPrivate(method.getModifiers())) {
                return null;
            }
            if (method.getReturnType() != Void.TYPE) {
                return null;
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private static Method getReadObject(Class<? extends Serializable> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("readObject", ObjectInputStream.class);
            if (!Modifier.isPrivate(method.getModifiers())) {
                return null;
            }
            if (method.getReturnType() != Void.TYPE) {
                return null;
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private static Method getReadObjectNoData(Class<? extends Serializable> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("readObjectNoData", new Class[0]);
            if (!Modifier.isPrivate(method.getModifiers())) {
                return null;
            }
            if (method.getReturnType() != Void.TYPE) {
                return null;
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

