/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.lease;

import java.io.IOException;
import java.util.UUID;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class LeaseInfoSerializer
extends VersionedSerializer<LeaseInfo> {
    public static final LeaseInfoSerializer INSTANCE = new LeaseInfoSerializer();

    protected void writeExternalData(LeaseInfo leaseInfo, IgniteDataOutput out) throws IOException {
        out.writeLong(leaseInfo.leaseStartTime());
        out.writeUuid(leaseInfo.primaryReplicaNodeId());
        out.writeUTF(leaseInfo.primaryReplicaNodeName());
    }

    protected LeaseInfo readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        long leaseStartTime = in.readLong();
        UUID primaryReplicaNodeId = in.readUuid();
        String primaryReplicaNodeName = in.readUTF();
        return new LeaseInfo(leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
    }
}

