/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.multipart;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.client.multipart.MultipartDataFactory;
import io.micronaut.http.client.multipart.Part;
import java.io.IOException;
import java.nio.charset.Charset;

abstract class AbstractFilePart<D>
extends Part<D> {
    protected final String filename;
    protected final MediaType contentType;

    AbstractFilePart(String name, String filename, @Nullable MediaType contentType) {
        super(name);
        if (filename == null) {
            throw new IllegalArgumentException("Adding file parts with a null filename is not allowed");
        }
        this.filename = filename;
        this.contentType = contentType == null ? MediaType.forExtension((String)NameUtils.extension((String)filename)).orElse(MediaType.APPLICATION_OCTET_STREAM_TYPE) : contentType;
    }

    abstract long getLength();

    @Override
    @NonNull
    <T> T getData(MultipartDataFactory<T> factory) {
        MediaType mediaType = this.contentType;
        String encoding = mediaType.isTextBased() ? null : "binary";
        Charset charset = mediaType.getCharset().orElse(null);
        T fileUpload = factory.createFileUpload(this.name, this.filename, mediaType, encoding, charset, this.getLength());
        try {
            factory.setContent(fileUpload, this.getContent());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return fileUpload;
    }
}

