/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.compaction;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManagerImpl;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.jetbrains.annotations.Nullable;

class CatalogManagerCompactionFacade {
    private final CatalogManagerImpl catalogManager;

    CatalogManagerCompactionFacade(CatalogManagerImpl catalogManager) {
        this.catalogManager = catalogManager;
    }

    Int2IntMap collectTablesWithPartitionsBetween(long minTsInclusive, long maxTsInclusive) {
        Int2IntOpenHashMap tablesWithPartitions = new Int2IntOpenHashMap();
        int curVer = this.catalogManager.activeCatalogVersion(minTsInclusive);
        int lastVer = this.catalogManager.activeCatalogVersion(maxTsInclusive);
        do {
            Catalog catalog = this.catalogManager.catalog(curVer);
            assert (catalog != null) : "ver=" + curVer + ", last=" + lastVer;
            for (CatalogTableDescriptor table : catalog.tables()) {
                CatalogZoneDescriptor zone = catalog.zone(table.zoneId());
                assert (zone != null) : table.zoneId();
                tablesWithPartitions.put(table.id(), zone.partitions());
            }
        } while (++curVer <= lastVer);
        return tablesWithPartitions;
    }

    @Nullable
    Catalog catalogPriorToVersionAtTsNullable(long timestamp) {
        try {
            int catalogVer = this.catalogManager.activeCatalogVersion(timestamp);
            return this.catalogManager.catalog(catalogVer - 1);
        }
        catch (IllegalStateException ignore) {
            return null;
        }
    }

    @Nullable
    Catalog catalogAtTsNullable(long timestamp) {
        try {
            int catalogVer = this.catalogManager.activeCatalogVersion(timestamp);
            return this.catalogManager.catalog(catalogVer);
        }
        catch (IllegalStateException ignore) {
            return null;
        }
    }

    CompletableFuture<Boolean> compactCatalog(int version) {
        return this.catalogManager.compactCatalog(version);
    }
}

