/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.CancellableTaskExecution;
import org.apache.ignite.internal.compute.ClassLoaderExceptionsMapper;
import org.apache.ignite.internal.compute.ComputeComponent;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ComputeJobFailover;
import org.apache.ignite.internal.compute.ComputeUtils;
import org.apache.ignite.internal.compute.ComputeViewProvider;
import org.apache.ignite.internal.compute.DelegatingJobExecution;
import org.apache.ignite.internal.compute.ExecutionManager;
import org.apache.ignite.internal.compute.ExecutionOptions;
import org.apache.ignite.internal.compute.NextWorkerSelector;
import org.apache.ignite.internal.compute.TaskToJobExecutionWrapper;
import org.apache.ignite.internal.compute.configuration.ComputeConfiguration;
import org.apache.ignite.internal.compute.executor.ComputeExecutor;
import org.apache.ignite.internal.compute.executor.JobExecutionInternal;
import org.apache.ignite.internal.compute.loader.JobContext;
import org.apache.ignite.internal.compute.loader.JobContextManager;
import org.apache.ignite.internal.compute.messaging.ComputeMessaging;
import org.apache.ignite.internal.compute.messaging.RemoteJobExecution;
import org.apache.ignite.internal.compute.task.DelegatingTaskExecution;
import org.apache.ignite.internal.compute.task.JobSubmitter;
import org.apache.ignite.internal.compute.task.TaskExecutionInternal;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViewProvider;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.CancelHandleHelper;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ComputeComponentImpl
implements ComputeComponent,
SystemViewProvider {
    private static final IgniteLogger LOG = Loggers.forClass(ComputeComponentImpl.class);
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final InFlightFutures inFlightFutures = new InFlightFutures();
    private final TopologyService topologyService;
    private final LogicalTopologyService logicalTopologyService;
    private final JobContextManager jobContextManager;
    private final ComputeExecutor executor;
    private final ComputeMessaging messaging;
    private final ExecutionManager executionManager;
    private final ExecutorService failoverExecutor;
    private final ComputeViewProvider computeViewProvider = new ComputeViewProvider();

    public ComputeComponentImpl(String nodeName, MessagingService messagingService, TopologyService topologyService, LogicalTopologyService logicalTopologyService, JobContextManager jobContextManager, ComputeExecutor executor, ComputeConfiguration computeConfiguration) {
        this.topologyService = topologyService;
        this.logicalTopologyService = logicalTopologyService;
        this.jobContextManager = jobContextManager;
        this.executor = executor;
        this.executionManager = new ExecutionManager(computeConfiguration, topologyService);
        this.messaging = new ComputeMessaging(this.executionManager, messagingService, topologyService);
        this.failoverExecutor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"compute-job-failover", (IgniteLogger)LOG));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancellableJobExecution<ComputeJobDataHolder> executeLocally(ExecutionOptions options, List<DeploymentUnit> units, String jobClassName, @Nullable ComputeJobDataHolder arg, @Nullable CancellationToken cancellationToken) {
        if (!this.busyLock.enterBusy()) {
            return new DelegatingJobExecution(CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException())));
        }
        try {
            CompletableFuture<JobContext> classLoaderFut = this.jobContextManager.acquireClassLoader(units);
            CompletionStage future = ClassLoaderExceptionsMapper.mapClassLoaderExceptions(classLoaderFut, jobClassName).thenApply(context -> {
                JobExecutionInternal<ComputeJobDataHolder> execution = this.execJob((JobContext)context, options, jobClassName, arg);
                execution.resultAsync().whenComplete((result, e) -> context.close());
                this.inFlightFutures.registerFuture(execution.resultAsync());
                return execution;
            });
            this.inFlightFutures.registerFuture((CompletableFuture)future);
            this.inFlightFutures.registerFuture(classLoaderFut);
            DelegatingJobExecution result = new DelegatingJobExecution((CompletableFuture<JobExecutionInternal<ComputeJobDataHolder>>)future);
            if (cancellationToken != null) {
                CancelHandleHelper.addCancelAction((CancellationToken)cancellationToken, classLoaderFut);
                CancelHandleHelper.addCancelAction((CancellationToken)cancellationToken, (CompletableFuture)future);
                CancelHandleHelper.addCancelAction((CancellationToken)cancellationToken, result::cancelAsync, result.resultAsync());
            }
            result.idAsync().thenAccept(jobId -> this.executionManager.addExecution((UUID)jobId, result));
            DelegatingJobExecution delegatingJobExecution = result;
            return delegatingJobExecution;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I, M, T, R> CancellableTaskExecution<R> executeTask(JobSubmitter<M, T> jobSubmitter, List<DeploymentUnit> units, String taskClassName, I input) {
        if (!this.busyLock.enterBusy()) {
            return new DelegatingTaskExecution(CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException())));
        }
        try {
            CompletionStage taskFuture = ClassLoaderExceptionsMapper.mapClassLoaderExceptions(this.jobContextManager.acquireClassLoader(units), taskClassName).thenApply(context -> {
                TaskExecutionInternal execution = this.execTask((JobContext)context, jobSubmitter, taskClassName, input);
                execution.resultAsync().whenComplete((r, e) -> context.close());
                this.inFlightFutures.registerFuture(execution.resultAsync());
                return execution;
            });
            this.inFlightFutures.registerFuture((CompletableFuture)taskFuture);
            DelegatingTaskExecution result = new DelegatingTaskExecution(taskFuture);
            result.idAsync().thenAccept(jobId -> this.executionManager.addExecution((UUID)jobId, new TaskToJobExecutionWrapper(result, this.topologyService.localMember())));
            DelegatingTaskExecution delegatingTaskExecution = result;
            return delegatingTaskExecution;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancellableJobExecution<ComputeJobDataHolder> executeRemotely(ExecutionOptions options, ClusterNode remoteNode, List<DeploymentUnit> units, String jobClassName, @Nullable ComputeJobDataHolder arg, @Nullable CancellationToken cancellationToken) {
        if (!this.busyLock.enterBusy()) {
            return new DelegatingJobExecution(CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException())));
        }
        try {
            CompletableFuture<UUID> jobIdFuture = this.messaging.remoteExecuteRequestAsync(options, remoteNode, units, jobClassName, arg);
            CompletionStage resultFuture = jobIdFuture.thenCompose(jobId -> this.messaging.remoteJobResultRequestAsync(remoteNode, (UUID)jobId));
            this.inFlightFutures.registerFuture(jobIdFuture);
            this.inFlightFutures.registerFuture((CompletableFuture)resultFuture);
            RemoteJobExecution<ComputeJobDataHolder> result = new RemoteJobExecution<ComputeJobDataHolder>(remoteNode, jobIdFuture, (CompletableFuture<ComputeJobDataHolder>)resultFuture, this.inFlightFutures, this.messaging);
            if (cancellationToken != null) {
                CancelHandleHelper.addCancelAction((CancellationToken)cancellationToken, result::cancelAsync, result.resultAsync());
            }
            jobIdFuture.thenAccept(jobId -> this.executionManager.addExecution((UUID)jobId, (CancellableJobExecution<?>)result));
            RemoteJobExecution<ComputeJobDataHolder> remoteJobExecution = result;
            return remoteJobExecution;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public JobExecution<ComputeJobDataHolder> executeRemotelyWithFailover(ClusterNode remoteNode, NextWorkerSelector nextWorkerSelector, List<DeploymentUnit> units, String jobClassName, ExecutionOptions options, @Nullable ComputeJobDataHolder arg, @Nullable CancellationToken cancellationToken) {
        CancellableJobExecution<ComputeJobDataHolder> result = new ComputeJobFailover(this, this.logicalTopologyService, this.topologyService, remoteNode, nextWorkerSelector, this.failoverExecutor, units, jobClassName, options, arg).failSafeExecute();
        if (cancellationToken != null) {
            CancelHandleHelper.addCancelAction((CancellationToken)cancellationToken, result::cancelAsync, (CompletableFuture)result.resultAsync());
        }
        result.idAsync().thenAccept(jobId -> this.executionManager.addExecution((UUID)jobId, result));
        return result;
    }

    @Override
    public CompletableFuture<Collection<JobState>> statesAsync() {
        return this.messaging.broadcastStatesAsync();
    }

    @Override
    public CompletableFuture<@Nullable JobState> stateAsync(UUID jobId) {
        return this.executionManager.stateAsync(jobId).thenCompose(state -> {
            if (state != null) {
                return CompletableFuture.completedFuture(state);
            }
            return this.messaging.broadcastStateAsync(jobId);
        });
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync(UUID jobId) {
        return this.executionManager.cancelAsync(jobId).thenCompose(result -> {
            if (result != null) {
                return CompletableFuture.completedFuture(result);
            }
            return this.messaging.broadcastCancelAsync(jobId);
        });
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(UUID jobId, int newPriority) {
        return this.executionManager.changePriorityAsync(jobId, newPriority).thenCompose(result -> {
            if (result != null) {
                return CompletableFuture.completedFuture(result);
            }
            return this.messaging.broadcastChangePriorityAsync(jobId, newPriority);
        });
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.executor.start();
        this.messaging.start((options, units, jobClassName, arg) -> this.executeLocally(options, units, jobClassName, arg, null));
        this.executionManager.start();
        this.computeViewProvider.init(this.executionManager);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        this.inFlightFutures.cancelInFlightFutures();
        this.executionManager.stop();
        this.messaging.stop();
        this.executor.stop();
        this.computeViewProvider.stop();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.failoverExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    private JobExecutionInternal<ComputeJobDataHolder> execJob(JobContext context, ExecutionOptions options, String jobClassName, @Nullable ComputeJobDataHolder arg) {
        try {
            return this.executor.executeJob(options, ComputeUtils.jobClass(context.classLoader(), jobClassName), context.classLoader(), arg);
        }
        catch (Throwable e) {
            context.close();
            throw e;
        }
    }

    private <I, M, T, R> TaskExecutionInternal<I, M, T, R> execTask(JobContext context, JobSubmitter<M, T> jobSubmitter, String taskClassName, I input) {
        try {
            return this.executor.executeTask(jobSubmitter, ComputeUtils.taskClass(context.classLoader(), taskClassName), input);
        }
        catch (Throwable e) {
            context.close();
            throw e;
        }
    }

    @TestOnly
    ExecutionManager executionManager() {
        return this.executionManager;
    }

    public List<SystemView<?>> systemViews() {
        return List.of(this.computeViewProvider.get());
    }
}

