/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ExecutionOptions;
import org.apache.ignite.internal.compute.FailSafeJobExecution;

class RemoteExecutionContext {
    private final ExecutionOptions executionOptions;
    private final List<DeploymentUnit> units;
    private final String jobClassName;
    private final ComputeJobDataHolder arg;
    private final AtomicReference<FailSafeJobExecution<ComputeJobDataHolder>> jobExecution;

    RemoteExecutionContext(List<DeploymentUnit> units, String jobClassName, ExecutionOptions executionOptions, ComputeJobDataHolder arg) {
        this.executionOptions = executionOptions;
        this.units = units;
        this.jobClassName = jobClassName;
        this.arg = arg;
        this.jobExecution = new AtomicReference<Object>(null);
    }

    void initJobExecution(FailSafeJobExecution<ComputeJobDataHolder> jobExecution) {
        if (!this.jobExecution.compareAndSet(null, jobExecution)) {
            throw new IllegalStateException("Job execution is already initialized.");
        }
    }

    FailSafeJobExecution<ComputeJobDataHolder> failSafeJobExecution() {
        FailSafeJobExecution<ComputeJobDataHolder> jobExecution = this.jobExecution.get();
        if (jobExecution == null) {
            throw new IllegalStateException("Job execution is not initialized. Call initJobExecution() first.");
        }
        return jobExecution;
    }

    void updateJobExecution(CancellableJobExecution<ComputeJobDataHolder> jobExecution) {
        this.failSafeJobExecution().updateJobExecution(jobExecution);
    }

    ExecutionOptions executionOptions() {
        return this.executionOptions;
    }

    List<DeploymentUnit> units() {
        return this.units;
    }

    String jobClassName() {
        return this.jobClassName;
    }

    ComputeJobDataHolder arg() {
        return this.arg;
    }
}

