/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.CancellableTaskExecution;
import org.apache.ignite.internal.compute.JobTaskStatusMapper;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

class TaskToJobExecutionWrapper<R>
implements CancellableJobExecution<R> {
    private final CancellableTaskExecution<R> taskExecution;
    private final ClusterNode localNode;

    TaskToJobExecutionWrapper(CancellableTaskExecution<R> taskExecution, ClusterNode localNode) {
        this.taskExecution = taskExecution;
        this.localNode = localNode;
    }

    public CompletableFuture<R> resultAsync() {
        return this.taskExecution.resultAsync();
    }

    public CompletableFuture<@Nullable JobState> stateAsync() {
        return this.taskExecution.stateAsync().thenApply(JobTaskStatusMapper::toJobState);
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        return this.taskExecution.cancelAsync();
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.taskExecution.changePriorityAsync(newPriority);
    }

    public ClusterNode node() {
        return this.localNode;
    }
}

