/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiPredicate;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.TopologyEventHandler;
import org.apache.ignite.internal.raft.PeerUnavailableException;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.InvokeTimeoutException;
import org.apache.ignite.raft.jraft.error.RemotingException;
import org.apache.ignite.raft.jraft.option.RpcOptions;
import org.apache.ignite.raft.jraft.rpc.InvokeCallback;
import org.apache.ignite.raft.jraft.rpc.InvokeContext;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RpcClientEx;
import org.apache.ignite.raft.jraft.util.Utils;

public class IgniteRpcClient
implements RpcClientEx {
    private static final IgniteLogger LOG = Loggers.forClass(IgniteRpcClient.class);
    private volatile BiPredicate<Object, String> recordPred;
    private BiPredicate<Object, String> blockPred;
    private LinkedBlockingQueue<Object[]> blockedMsgs = new LinkedBlockingQueue();
    private LinkedBlockingQueue<Object[]> recordedMsgs = new LinkedBlockingQueue();
    private final ClusterService service;

    public IgniteRpcClient(ClusterService service) {
        this.service = service;
    }

    public ClusterService clusterService() {
        return this.service;
    }

    @Override
    public boolean checkConnection(PeerId peerId) {
        return this.service.topologyService().getByConsistentId(peerId.getConsistentId()) != null;
    }

    @Override
    public void registerConnectEventListener(TopologyEventHandler handler) {
        this.service.topologyService().addEventHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Message> invokeAsync(PeerId peerId, Object request, InvokeContext ctx, InvokeCallback callback, long timeoutMs) {
        CompletableFuture<Message> fut = new CompletableFuture<Message>();
        fut.whenComplete((res, err) -> {
            assert (res != null || err != null) : String.valueOf(res) + " " + String.valueOf(err);
            if (err == null && this.recordPred != null && this.recordPred.test(res, this.toString())) {
                this.recordedMsgs.add(new Object[]{res, this.toString(), fut.hashCode(), System.currentTimeMillis(), null});
            }
            if (err instanceof ExecutionException) {
                err = new RemotingException((Throwable)err);
            } else if (err instanceof TimeoutException) {
                err = new InvokeTimeoutException();
            }
            Throwable finalErr = err;
            Utils.runInThread(callback.executor(), () -> callback.complete(res, finalErr));
        });
        if (this.recordPred != null && this.recordPred.test(request, peerId.toString())) {
            this.recordedMsgs.add(new Object[]{request, peerId.toString(), fut.hashCode(), System.currentTimeMillis(), null});
        }
        IgniteRpcClient igniteRpcClient = this;
        synchronized (igniteRpcClient) {
            if (this.blockPred != null && this.blockPred.test(request, peerId.toString())) {
                Object[] msgData = new Object[]{request, peerId.toString(), fut.hashCode(), System.currentTimeMillis(), () -> this.send(peerId, request, fut, timeoutMs)};
                this.blockedMsgs.add(msgData);
                if (timeoutMs > 0L) {
                    fut.orTimeout(timeoutMs, TimeUnit.MILLISECONDS);
                }
                LOG.info("Blocked message to={} id={} msg={}", new Object[]{peerId.toString(), msgData[2], S.toString((Object)request)});
                return fut;
            }
        }
        this.send(peerId, request, fut, timeoutMs);
        return fut;
    }

    public void send(PeerId peerId, Object request, CompletableFuture<Message> fut, long timeout) {
        ClusterNode targetNode = this.service.topologyService().getByConsistentId(peerId.getConsistentId());
        if (targetNode == null) {
            fut.completeExceptionally(new PeerUnavailableException(peerId.getConsistentId()));
            return;
        }
        this.service.messagingService().invoke(targetNode, (NetworkMessage)request, timeout).whenComplete((resp, err) -> {
            if (err != null) {
                fut.completeExceptionally((Throwable)err);
            } else {
                fut.complete((Message)resp);
            }
        });
    }

    @Override
    public boolean init(RpcOptions opts) {
        return true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void blockMessages(BiPredicate<Object, String> predicate) {
        this.blockPred = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopBlock() {
        ArrayList msgs = new ArrayList();
        IgniteRpcClient igniteRpcClient = this;
        synchronized (igniteRpcClient) {
            this.blockedMsgs.drainTo(msgs);
            this.blockPred = null;
        }
        for (Object[] msg : msgs) {
            Runnable r = (Runnable)msg[4];
            LOG.info("Unblocked message to={} id={} msg={}", new Object[]{msg[1], msg[2], S.toString((Object)msg[0])});
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopBlock(int cnt) {
        ArrayList<Object[]> msgs = new ArrayList<Object[]>();
        IgniteRpcClient igniteRpcClient = this;
        synchronized (igniteRpcClient) {
            Object[] tmp;
            while (cnt-- > 0 && (tmp = this.blockedMsgs.poll()) != null) {
                msgs.add(tmp);
            }
            this.blockPred = null;
        }
        for (Object[] msg : msgs) {
            Runnable r = (Runnable)msg[4];
            r.run();
        }
    }

    @Override
    public void recordMessages(BiPredicate<Object, String> predicate) {
        this.recordPred = predicate;
    }

    @Override
    public void stopRecord() {
        this.recordPred = null;
    }

    @Override
    public Queue<Object[]> recordedMessages() {
        return this.recordedMsgs;
    }

    @Override
    public Queue<Object[]> blockedMessages() {
        return this.blockedMsgs;
    }
}

