/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import java.util.Set;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.SystemPropertyView;

public class NonNegativeIntegerNumberSystemPropertyValueValidator
implements Validator<NamedConfigValue, NamedListView<SystemPropertyView>> {
    private final Set<String> propertyNames;

    public NonNegativeIntegerNumberSystemPropertyValueValidator(String ... propertyNames) {
        this.propertyNames = Set.of(propertyNames);
    }

    public void validate(NamedConfigValue annotation, ValidationContext<NamedListView<SystemPropertyView>> ctx) {
        for (String propertyName : this.propertyNames) {
            SystemPropertyView systemPropertyView = (SystemPropertyView)((NamedListView)ctx.getNewValue()).get(propertyName);
            if (systemPropertyView == null || NonNegativeIntegerNumberSystemPropertyValueValidator.isNonNegativeIntegerValue(systemPropertyView.propertyValue())) continue;
            String message = String.format("'%s' system property value must be a non-negative long number '%s'", ctx.currentKey(), propertyName);
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
        }
    }

    private static boolean isNonNegativeIntegerValue(String propertyValue) {
        try {
            return Integer.parseInt(propertyValue) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

