/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.impl;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.command.response.BatchResponse;
import org.apache.ignite.internal.metastorage.impl.MetaStorageServiceContext;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.raft.ReadCommand;
import org.jetbrains.annotations.Nullable;

class CursorSubscription
implements Flow.Subscription {
    private final MetaStorageServiceContext context;
    private final Flow.Subscriber<? super Entry> subscriber;
    private final Function<byte[], ReadCommand> nextBatchCommandSupplier;
    private boolean isDone = false;
    @Nullable
    private BatchResponse cachedResponse;
    private int responseIndex;
    private long demand;

    CursorSubscription(MetaStorageServiceContext context, Function<byte[], ReadCommand> nextBatchCommandSupplier, Flow.Subscriber<? super Entry> subscriber) {
        this.context = context;
        this.nextBatchCommandSupplier = nextBatchCommandSupplier;
        this.subscriber = subscriber;
    }

    @Override
    public void request(long n) {
        if (n <= 0L) {
            this.onError(new IllegalArgumentException("Requested amount must be greater than zero, got: " + n));
            return;
        }
        if (this.isDone) {
            return;
        }
        if (!this.context.busyLock().enterBusy()) {
            this.onError(new NodeStoppingException());
            return;
        }
        try {
            this.demand += n;
            if (this.demand <= 0L) {
                this.onError(new IllegalArgumentException("Long overflow"));
                return;
            }
            if (this.cachedResponse == null) {
                this.requestNextBatch(null);
            }
        }
        finally {
            this.context.busyLock().leaveBusy();
        }
    }

    private void processRequest() {
        if (this.isDone) {
            return;
        }
        if (!this.context.busyLock().enterBusy()) {
            this.onError(new NodeStoppingException());
        }
        try {
            assert (this.cachedResponse != null);
            List<Entry> entries = this.cachedResponse.entries();
            while (this.demand > 0L && !this.isDone) {
                if (this.responseIndex < entries.size()) {
                    this.subscriber.onNext((Entry)entries.get(this.responseIndex));
                    ++this.responseIndex;
                    --this.demand;
                    continue;
                }
                if (this.cachedResponse.hasNextBatch()) {
                    assert (!entries.isEmpty());
                    byte[] lastProcessedKey = entries.get(entries.size() - 1).key();
                    this.requestNextBatch(lastProcessedKey);
                } else {
                    this.isDone = true;
                    this.subscriber.onComplete();
                }
                return;
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
        finally {
            this.context.busyLock().leaveBusy();
        }
    }

    private void requestNextBatch(byte @Nullable [] lastProcessedKey) {
        ReadCommand nextBatchCommand = this.nextBatchCommandSupplier.apply(lastProcessedKey);
        this.context.raftService().run((Command)nextBatchCommand).whenCompleteAsync((resp, e) -> {
            if (e == null) {
                this.cachedResponse = resp;
                this.responseIndex = 0;
                this.processRequest();
            } else {
                this.onError((Throwable)e);
            }
        }, (Executor)this.context.executorService());
    }

    @Override
    public void cancel() {
        this.isDone = true;
    }

    private void onError(Throwable e) {
        this.cancel();
        this.subscriber.onError(e);
    }
}

