/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import java.util.Arrays;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.server.Condition;
import org.apache.ignite.internal.util.ArrayUtils;

public abstract class AbstractCompoundCondition
implements Condition {
    private final Condition leftCondition;
    private final Condition rightCondition;
    private final byte[][] keys;

    public AbstractCompoundCondition(Condition leftCondition, Condition rightCondition) {
        this.leftCondition = leftCondition;
        this.rightCondition = rightCondition;
        this.keys = (byte[][])ArrayUtils.concat((Object[])leftCondition.keys(), (Object[])rightCondition.keys());
    }

    @Override
    public byte[][] keys() {
        return this.keys;
    }

    @Override
    public boolean test(Entry ... entries) {
        return this.combine(this.leftCondition.test(Arrays.copyOf(entries, this.leftCondition.keys().length)), this.rightCondition.test(Arrays.copyOfRange(entries, this.leftCondition.keys().length, this.leftCondition.keys().length + this.rightCondition.keys().length)));
    }

    protected abstract boolean combine(boolean var1, boolean var2);

    public Condition leftCondition() {
        return this.leftCondition;
    }

    public Condition rightCondition() {
        return this.rightCondition;
    }
}

