/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.TxIdMismatchException;
import org.apache.ignite.internal.storage.gc.GcEntry;
import org.apache.ignite.internal.table.distributed.raft.PartitionDataStorage;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionKey;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.OutgoingSnapshot;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.PartitionSnapshots;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.PartitionsSnapshots;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SnapshotAwarePartitionDataStorage
implements PartitionDataStorage {
    private final MvPartitionStorage partitionStorage;
    private final PartitionsSnapshots partitionsSnapshots;
    private final PartitionKey partitionKey;
    private final RaftGroupConfigurationConverter raftGroupConfigurationConverter = new RaftGroupConfigurationConverter();

    public SnapshotAwarePartitionDataStorage(MvPartitionStorage partitionStorage, PartitionsSnapshots partitionsSnapshots, PartitionKey partitionKey) {
        this.partitionStorage = partitionStorage;
        this.partitionsSnapshots = partitionsSnapshots;
        this.partitionKey = partitionKey;
    }

    @Override
    public int tableId() {
        return this.partitionKey.tableId();
    }

    @Override
    public int partitionId() {
        return this.partitionKey.partitionId();
    }

    @Override
    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        return (V)this.partitionStorage.runConsistently(closure);
    }

    @Override
    public void acquirePartitionSnapshotsReadLock() {
        PartitionSnapshots partitionSnapshots = this.getPartitionSnapshots();
        partitionSnapshots.acquireReadLock();
    }

    @Override
    public void releasePartitionSnapshotsReadLock() {
        PartitionSnapshots partitionSnapshots = this.getPartitionSnapshots();
        partitionSnapshots.releaseReadLock();
    }

    private PartitionSnapshots getPartitionSnapshots() {
        return this.partitionsSnapshots.partitionSnapshots(this.partitionKey);
    }

    @Override
    public CompletableFuture<Void> flush(boolean trigger) {
        return this.partitionStorage.flush(trigger);
    }

    @Override
    public long lastAppliedIndex() {
        return this.partitionStorage.lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.partitionStorage.lastAppliedTerm();
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.partitionStorage.lastApplied(lastAppliedIndex, lastAppliedTerm);
    }

    @Override
    public void committedGroupConfiguration(RaftGroupConfiguration config) {
        this.partitionStorage.committedGroupConfiguration(this.raftGroupConfigurationConverter.toBytes(config));
    }

    @Override
    @Nullable
    public BinaryRow addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableId, int commitPartitionId) throws TxIdMismatchException, StorageException {
        this.handleSnapshotInterference(rowId);
        return this.partitionStorage.addWrite(rowId, row, txId, commitTableId, commitPartitionId);
    }

    @Override
    public void addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTs) throws TxIdMismatchException, StorageException {
        this.handleSnapshotInterference(rowId);
        this.partitionStorage.addWriteCommitted(rowId, row, commitTs);
    }

    @Override
    @Nullable
    public BinaryRow abortWrite(RowId rowId) throws StorageException {
        this.handleSnapshotInterference(rowId);
        return this.partitionStorage.abortWrite(rowId);
    }

    @Override
    public void commitWrite(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        this.handleSnapshotInterference(rowId);
        this.partitionStorage.commitWrite(rowId, timestamp);
    }

    @Override
    public Cursor<ReadResult> scanVersions(RowId rowId) throws StorageException {
        return this.partitionStorage.scanVersions(rowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSnapshotInterference(RowId rowId) {
        PartitionSnapshots partitionSnapshots = this.getPartitionSnapshots();
        for (OutgoingSnapshot snapshot : partitionSnapshots.ongoingSnapshots()) {
            snapshot.acquireMvLock();
            try {
                if (snapshot.alreadyPassed(rowId) || !snapshot.addRowIdToSkip(rowId)) continue;
                snapshot.enqueueForSending(rowId);
            }
            finally {
                snapshot.releaseMvLock();
            }
        }
    }

    @Override
    public void close() {
        this.cleanupSnapshots();
    }

    private void cleanupSnapshots() {
        PartitionSnapshots partitionSnapshots = this.getPartitionSnapshots();
        partitionSnapshots.acquireReadLock();
        try {
            partitionSnapshots.ongoingSnapshots().forEach(snapshot -> this.partitionsSnapshots.finishOutgoingSnapshot(snapshot.id()));
            this.partitionsSnapshots.removeSnapshots(this.partitionKey);
        }
        finally {
            partitionSnapshots.releaseReadLock();
        }
    }

    @Override
    @TestOnly
    public MvPartitionStorage getStorage() {
        return this.partitionStorage;
    }

    @Override
    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        return this.partitionStorage.scan(timestamp);
    }

    @Override
    @Nullable
    public GcEntry peek(HybridTimestamp lowWatermark) {
        return this.partitionStorage.peek(lowWatermark);
    }

    @Override
    @Nullable
    public BinaryRow vacuum(GcEntry entry) {
        return this.partitionStorage.vacuum(entry);
    }

    @Override
    public void updateLease(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        this.partitionStorage.updateLease(leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
    }

    @Override
    public long leaseStartTime() {
        return this.partitionStorage.leaseStartTime();
    }

    @Override
    public UUID primaryReplicaNodeId() {
        return this.partitionStorage.primaryReplicaNodeId();
    }

    @Override
    public String primaryReplicaNodeName() {
        return this.partitionStorage.primaryReplicaNodeName();
    }
}

