/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replicator;

import java.util.UUID;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteReplicaRequest;
import org.apache.ignite.internal.tx.TransactionIds;
import org.jetbrains.annotations.Nullable;

class ReplicatorUtils {
    ReplicatorUtils() {
    }

    @Nullable
    static CatalogIndexDescriptor latestIndexDescriptorInBuildingStatus(CatalogService catalogService, int tableId) {
        int latestCatalogVersion = catalogService.latestCatalogVersion();
        int earliestCatalogVersion = catalogService.earliestCatalogVersion();
        for (int catalogVersion = latestCatalogVersion; catalogVersion >= earliestCatalogVersion; --catalogVersion) {
            for (CatalogIndexDescriptor indexDescriptor : catalogService.indexes(catalogVersion, tableId)) {
                if (indexDescriptor.status() != CatalogIndexStatus.BUILDING) continue;
                return indexDescriptor;
            }
        }
        return null;
    }

    static HybridTimestamp beginRwTxTs(ReadWriteReplicaRequest request) {
        return TransactionIds.beginTimestamp((UUID)request.transactionId());
    }

    static int rwTxActiveCatalogVersion(CatalogService catalogService, ReadWriteReplicaRequest request) {
        HybridTimestamp beginRwTxTs = ReplicatorUtils.beginRwTxTs(request);
        return catalogService.activeCatalogVersion(beginRwTxTs.longValue());
    }
}

