/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.configuration;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.configuration.validation.Range;

@Config
public class ReplicationConfigurationSchema {
    public static final long DEFAULT_IDLE_SAFE_TIME_PROP_DURATION = TimeUnit.SECONDS.toMillis(1L);
    @Value(hasDefault=true)
    @Range(min=0L)
    public long idleSafeTimePropagationDuration = DEFAULT_IDLE_SAFE_TIME_PROP_DURATION;
    @Value(hasDefault=true)
    @Range(min=1000L)
    public long rpcTimeout = TimeUnit.SECONDS.toMillis(60L);
    @Value(hasDefault=true)
    @Range(min=5000L)
    public long leaseAgreementAcceptanceTimeLimit = 120000L;
    @Value(hasDefault=true)
    @Range(min=2000L, max=120000L)
    public long leaseExpirationInterval = 5000L;
    @Value(hasDefault=true)
    @Range(max=10000L)
    public int replicaOperationRetryInterval = 10;
}

