/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationDynamicDefaultsPatcher;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.internal.cluster.management.InternalInitException;
import org.apache.ignite.internal.cluster.management.network.messages.CancelInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.CmgInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.internal.cluster.management.network.messages.InitCompleteMessage;
import org.apache.ignite.internal.cluster.management.network.messages.InitErrorMessage;
import org.apache.ignite.internal.configuration.validation.ConfigurationValidator;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class ClusterInitializer {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterInitializer.class);
    private static final int INIT_MESSAGE_SEND_TIMEOUT_MILLIS = 10000;
    private final ClusterService clusterService;
    private final ConfigurationDynamicDefaultsPatcher configurationDynamicDefaultsPatcher;
    private final ConfigurationValidator clusterConfigurationValidator;
    private final CmgMessagesFactory msgFactory = new CmgMessagesFactory();

    public ClusterInitializer(ClusterService clusterService, ConfigurationDynamicDefaultsPatcher configurationDynamicDefaultsPatcher, ConfigurationValidator clusterConfigurationValidator) {
        this.clusterService = clusterService;
        this.configurationDynamicDefaultsPatcher = configurationDynamicDefaultsPatcher;
        this.clusterConfigurationValidator = clusterConfigurationValidator;
    }

    public CompletableFuture<Void> initCluster(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName) {
        return this.initCluster(metaStorageNodeNames, cmgNodeNames, clusterName, null);
    }

    public CompletableFuture<Void> initCluster(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName, @Nullable String clusterConfiguration) {
        if (metaStorageNodeNames.isEmpty()) {
            throw new IllegalArgumentException("Meta Storage node names list must not be empty");
        }
        if (metaStorageNodeNames.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("Meta Storage node names must not contain blank strings: " + String.valueOf(metaStorageNodeNames));
        }
        if (!cmgNodeNames.isEmpty() && cmgNodeNames.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("CMG node names must not contain blank strings: " + String.valueOf(cmgNodeNames));
        }
        if (clusterName.isBlank()) {
            throw new IllegalArgumentException("Cluster name must not be empty");
        }
        try {
            Set<String> msNodeNameSet = metaStorageNodeNames.stream().map(String::trim).collect(Collectors.toUnmodifiableSet());
            Set<String> cmgNodeNameSet = cmgNodeNames.isEmpty() ? msNodeNameSet : cmgNodeNames.stream().map(String::trim).collect(Collectors.toUnmodifiableSet());
            List<ClusterNode> msNodes = ClusterInitializer.resolveNodes(this.clusterService, msNodeNameSet);
            LOG.info("Resolved MetaStorage nodes[nodes={}]", new Object[]{msNodes});
            List<ClusterNode> cmgNodes = ClusterInitializer.resolveNodes(this.clusterService, cmgNodeNameSet);
            LOG.info("Resolved CMG nodes[nodes={}]", new Object[]{cmgNodes});
            String initialClusterConfiguration = this.patchClusterConfigurationWithDynamicDefaults(clusterConfiguration);
            this.validateConfiguration(initialClusterConfiguration);
            CmgInitMessage initMessage = this.msgFactory.cmgInitMessage().metaStorageNodes(msNodeNameSet).cmgNodes(cmgNodeNameSet).clusterName(clusterName).clusterId(UUID.randomUUID()).initialClusterConfiguration(initialClusterConfiguration).build();
            return ((CompletableFuture)this.invokeMessage(cmgNodes, initMessage).handle((v, e) -> {
                if (e == null) {
                    LOG.info("Cluster initialized [clusterName={}, cmgNodes={}, msNodes={}]", new Object[]{initMessage.clusterName(), initMessage.cmgNodes(), initMessage.metaStorageNodes()});
                    return CompletableFutures.nullCompletedFuture();
                }
                if (e instanceof CompletionException) {
                    e = e.getCause();
                }
                LOG.info("Initialization failed [reason={}]", e, new Object[]{e.getMessage()});
                if (e instanceof InternalInitException && !((InternalInitException)((Object)((Object)e))).shouldCancelInit()) {
                    return CompletableFuture.failedFuture(e);
                }
                LOG.debug("Critical error encountered, rolling back the init procedure", new Object[0]);
                return this.cancelInit((Collection<ClusterNode>)cmgNodes, (Throwable)e);
            })).thenCompose(Function.identity());
        }
        catch (Exception e2) {
            return CompletableFuture.failedFuture(e2);
        }
    }

    private CompletableFuture<Void> cancelInit(Collection<ClusterNode> nodes, Throwable e) {
        CancelInitMessage cancelMessage = this.msgFactory.cancelInitMessage().reason(e.getMessage()).build();
        return ((CompletableFuture)this.sendMessage(nodes, cancelMessage).exceptionally(nestedEx -> {
            LOG.debug("Error when canceling init", nestedEx);
            e.addSuppressed((Throwable)nestedEx);
            return null;
        })).thenCompose(v -> CompletableFuture.failedFuture(e));
    }

    private CompletableFuture<Void> invokeMessage(Collection<ClusterNode> nodes, NetworkMessage message) {
        return ClusterInitializer.allOf(nodes, node -> this.clusterService.messagingService().invoke(node, message, 10000L).thenAccept(response -> {
            if (response instanceof InitErrorMessage) {
                InitErrorMessage errorResponse = (InitErrorMessage)response;
                throw new InternalInitException(String.format("Got error response from node \"%s\": %s", node.name(), errorResponse.cause()), errorResponse.shouldCancel());
            }
            if (!(response instanceof InitCompleteMessage)) {
                throw new InternalInitException(String.format("Unexpected response from node \"%s\": %s", node.name(), response.getClass()), true);
            }
        }));
    }

    private CompletableFuture<Void> sendMessage(Collection<ClusterNode> nodes, NetworkMessage message) {
        return ClusterInitializer.allOf(nodes, node -> this.clusterService.messagingService().send(node, message));
    }

    private static CompletableFuture<Void> allOf(Collection<ClusterNode> nodes, Function<ClusterNode, CompletableFuture<?>> futureProducer) {
        CompletableFuture[] futures = (CompletableFuture[])nodes.stream().map(futureProducer).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private static List<ClusterNode> resolveNodes(ClusterService clusterService, Collection<String> consistentIds) {
        return consistentIds.stream().map(consistentId -> {
            ClusterNode node = clusterService.topologyService().getByConsistentId(consistentId);
            if (node == null) {
                throw new IllegalArgumentException(String.format("Node \"%s\" is not present in the physical topology", consistentId));
            }
            return node;
        }).collect(Collectors.toList());
    }

    private String patchClusterConfigurationWithDynamicDefaults(@Nullable String hocon) {
        return this.configurationDynamicDefaultsPatcher.patchWithDynamicDefaults(hocon == null ? "" : hocon);
    }

    private void validateConfiguration(String hocon) {
        List issues;
        if (hocon != null && !(issues = this.clusterConfigurationValidator.validateHocon(hocon)).isEmpty()) {
            throw new ConfigurationValidationException(issues);
        }
    }
}

