/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CreateZoneEventParameters;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.configuration.SystemDistributedConfiguration;
import org.apache.ignite.internal.configuration.utils.SystemDistributedConfigurationPropertyHolder;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.distributionzones.rebalance.PartitionMover;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.distributionzones.rebalance.ZoneRebalanceRaftGroupEventsListener;
import org.apache.ignite.internal.distributionzones.rebalance.ZoneRebalanceUtil;
import org.apache.ignite.internal.event.AbstractEventProducer;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.WatchEvent;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.partition.replicator.LocalPartitionReplicaEvent;
import org.apache.ignite.internal.partition.replicator.LocalPartitionReplicaEventParameters;
import org.apache.ignite.internal.partition.replicator.ZonePartitionRaftListener;
import org.apache.ignite.internal.partition.replicator.ZonePartitionReplicaListener;
import org.apache.ignite.internal.partition.replicator.snapshot.FailFastSnapshotStorageFactory;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.PartitionDistributionUtils;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.raft.ExecutorInclinedRaftCommandRunner;
import org.apache.ignite.internal.raft.Peer;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.RaftGroupEventsListener;
import org.apache.ignite.internal.raft.service.LeaderWithTerm;
import org.apache.ignite.internal.raft.service.RaftCommandRunner;
import org.apache.ignite.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite.internal.replicator.Replica;
import org.apache.ignite.internal.replicator.ReplicaManager;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.listener.ReplicaListener;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class PartitionReplicaLifecycleManager
extends AbstractEventProducer<LocalPartitionReplicaEvent, LocalPartitionReplicaEventParameters>
implements IgniteComponent {
    public static final String FEATURE_FLAG_NAME = "IGNITE_ZONE_BASED_REPLICATION";
    public static final boolean ENABLED = IgniteSystemProperties.getBoolean((String)"IGNITE_ZONE_BASED_REPLICATION", (boolean)false);
    private final CatalogManager catalogMgr;
    private final ReplicaManager replicaMgr;
    private final DistributionZoneManager distributionZoneMgr;
    private final MetaStorageManager metaStorageMgr;
    private final TopologyService topologyService;
    private final LowWatermark lowWatermark;
    private final WatchListener pendingAssignmentsRebalanceListener;
    private final WatchListener stableAssignmentsRebalanceListener;
    private final WatchListener assignmentsSwitchRebalanceListener;
    private static final IgniteLogger LOG = Loggers.forClass(PartitionReplicaLifecycleManager.class);
    private final Set<ZonePartitionId> replicationGroupIds = ConcurrentHashMap.newKeySet();
    private final Map<Integer, StampedLock> zonePartitionsLocks = new ConcurrentHashMap<Integer, StampedLock>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final ExecutorService ioExecutor;
    private final ScheduledExecutorService rebalanceScheduler;
    private final Executor partitionOperationsExecutor;
    private final ClockService clockService;
    private final PlacementDriver placementDriver;
    private final SchemaSyncService schemaSyncService;
    private final Predicate<Assignment> isLocalNodeAssignment = assignment -> assignment.consistentId().equals(this.localNode().name());
    private final SystemDistributedConfigurationPropertyHolder<Integer> rebalanceRetryDelayConfiguration;

    public PartitionReplicaLifecycleManager(CatalogManager catalogMgr, ReplicaManager replicaMgr, DistributionZoneManager distributionZoneMgr, MetaStorageManager metaStorageMgr, TopologyService topologyService, LowWatermark lowWatermark, ExecutorService ioExecutor, ScheduledExecutorService rebalanceScheduler, Executor partitionOperationsExecutor, ClockService clockService, PlacementDriver placementDriver, SchemaSyncService schemaSyncService, SystemDistributedConfiguration systemDistributedConfiguration) {
        this.catalogMgr = catalogMgr;
        this.replicaMgr = replicaMgr;
        this.distributionZoneMgr = distributionZoneMgr;
        this.metaStorageMgr = metaStorageMgr;
        this.topologyService = topologyService;
        this.lowWatermark = lowWatermark;
        this.ioExecutor = ioExecutor;
        this.rebalanceScheduler = rebalanceScheduler;
        this.partitionOperationsExecutor = partitionOperationsExecutor;
        this.clockService = clockService;
        this.schemaSyncService = schemaSyncService;
        this.placementDriver = placementDriver;
        this.rebalanceRetryDelayConfiguration = new SystemDistributedConfigurationPropertyHolder(systemDistributedConfiguration, (v, r) -> {}, "rebalanceRetryDelay", (Object)200, Integer::parseInt);
        this.pendingAssignmentsRebalanceListener = this.createPendingAssignmentsRebalanceListener();
        this.stableAssignmentsRebalanceListener = this.createStableAssignmentsRebalanceListener();
        this.assignmentsSwitchRebalanceListener = this.createAssignmentsSwitchRebalanceListener();
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        if (!ENABLED) {
            return CompletableFutures.nullCompletedFuture();
        }
        CompletableFuture recoveryFinishFuture = this.metaStorageMgr.recoveryFinishedFuture();
        assert (recoveryFinishFuture.isDone());
        long recoveryRevision = ((Revisions)recoveryFinishFuture.join()).revision();
        this.cleanUpResourcesForDroppedZonesOnRecovery();
        CompletionStage processZonesAndAssignmentsOnStart = this.processZonesOnStart(recoveryRevision, this.lowWatermark.getLowWatermark()).thenCompose(ignored -> this.processAssignmentsOnRecovery(recoveryRevision));
        this.metaStorageMgr.registerPrefixWatch(new ByteArray(ZoneRebalanceUtil.PENDING_ASSIGNMENTS_PREFIX_BYTES), this.pendingAssignmentsRebalanceListener);
        this.metaStorageMgr.registerPrefixWatch(new ByteArray(ZoneRebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES), this.stableAssignmentsRebalanceListener);
        this.metaStorageMgr.registerPrefixWatch(new ByteArray(ZoneRebalanceUtil.ASSIGNMENTS_SWITCH_REDUCE_PREFIX_BYTES), this.assignmentsSwitchRebalanceListener);
        this.catalogMgr.listen((Event)CatalogEvent.ZONE_CREATE, parameters -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.onCreateZone((CreateZoneEventParameters)parameters).thenApply(ignored -> false)));
        this.rebalanceRetryDelayConfiguration.init();
        return processZonesAndAssignmentsOnStart;
    }

    private CompletableFuture<Void> processZonesOnStart(long recoveryRevision, @Nullable HybridTimestamp lwm) {
        int earliestCatalogVersion = this.catalogMgr.activeCatalogVersion(HybridTimestamp.hybridTimestampToLong((HybridTimestamp)lwm));
        int latestCatalogVersion = this.catalogMgr.latestCatalogVersion();
        IntOpenHashSet startedZones = new IntOpenHashSet();
        ArrayList startZoneFutures = new ArrayList();
        for (int ver = latestCatalogVersion; ver >= earliestCatalogVersion; --ver) {
            int ver0 = ver;
            this.catalogMgr.zones(ver).stream().filter(zone -> startedZones.add(zone.id())).forEach(zoneDescriptor -> startZoneFutures.add(this.calculateZoneAssignmentsAndCreateReplicationNodes(recoveryRevision, ver0, (CatalogZoneDescriptor)zoneDescriptor)));
        }
        return CompletableFuture.allOf((CompletableFuture[])startZoneFutures.toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                LOG.error("Error starting zones", throwable);
            } else {
                LOG.debug("Zones started successfully [earliestCatalogVersion={}, latestCatalogVersion={}, startedZoneIds={}]", new Object[]{earliestCatalogVersion, latestCatalogVersion, startedZones});
            }
        });
    }

    private CompletableFuture<Void> processAssignmentsOnRecovery(long recoveryRevision) {
        ByteArray stableAssignmentsPrefix = new ByteArray(ZoneRebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES);
        ByteArray pendingAssignmentsPrefix = new ByteArray(ZoneRebalanceUtil.PENDING_ASSIGNMENTS_PREFIX_BYTES);
        CompletableFuture<Void> stableFuture = this.handleAssignmentsOnRecovery(stableAssignmentsPrefix, recoveryRevision, (entry, rev) -> this.handleChangeStableAssignmentEvent((Entry)entry, (long)rev, true), "stable");
        CompletableFuture<Void> pendingFuture = this.handleAssignmentsOnRecovery(pendingAssignmentsPrefix, recoveryRevision, (entry, rev) -> this.handleChangePendingAssignmentEvent((Entry)entry, (long)rev, true), "pending");
        return CompletableFuture.allOf(stableFuture, pendingFuture);
    }

    private CompletableFuture<Void> handleAssignmentsOnRecovery(ByteArray prefix, long revision, BiFunction<Entry, Long, CompletableFuture<Void>> assignmentsEventHandler, String assignmentsType) {
        try (Cursor cursor = this.metaStorageMgr.prefixLocally(prefix, revision);){
            CompletableFuture[] futures = (CompletableFuture[])cursor.stream().map(entry -> {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Non handled {} assignments for key '{}' discovered, performing recovery", new Object[]{assignmentsType, new String(entry.key(), StandardCharsets.UTF_8)});
                }
                return (CompletableFuture)assignmentsEventHandler.apply((Entry)entry, revision);
            }).toArray(CompletableFuture[]::new);
            CompletionStage completionStage = CompletableFuture.allOf(futures).whenComplete((res, e) -> {
                if (e != null) {
                    LOG.error("Error when performing assignments recovery", e);
                }
            });
            return completionStage;
        }
    }

    private void cleanUpResourcesForDroppedZonesOnRecovery() {
    }

    private CompletableFuture<Void> onCreateZone(CreateZoneEventParameters createZoneEventParameters) {
        return this.calculateZoneAssignmentsAndCreateReplicationNodes(createZoneEventParameters.causalityToken(), createZoneEventParameters.catalogVersion(), createZoneEventParameters.zoneDescriptor());
    }

    private CompletableFuture<Void> calculateZoneAssignmentsAndCreateReplicationNodes(long causalityToken, int catalogVersion, CatalogZoneDescriptor zoneDescriptor) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            CompletableFuture<List<Assignments>> assignmentsFuture = this.getOrCreateAssignments(zoneDescriptor, causalityToken, catalogVersion);
            CompletableFuture<List<Assignments>> assignmentsFutureAfterInvoke = this.writeZoneAssignmentsToMetastore(zoneDescriptor.id(), assignmentsFuture);
            return this.createZoneReplicationNodes(assignmentsFutureAfterInvoke, zoneDescriptor.id());
        });
    }

    private CompletableFuture<Void> createZoneReplicationNodes(CompletableFuture<List<Assignments>> assignmentsFuture, int zoneId) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> assignmentsFuture.thenCompose(assignments -> {
            assert (assignments != null) : IgniteStringFormatter.format((String)"Zone has empty assignments [id={}].", (Object[])new Object[]{zoneId});
            ArrayList<CompletableFuture<Void>> partitionsStartFutures = new ArrayList<CompletableFuture<Void>>();
            for (int partId = 0; partId < assignments.size(); ++partId) {
                Assignments zoneAssignment = (Assignments)assignments.get(partId);
                Assignment localMemberAssignment = this.localMemberAssignment(zoneAssignment);
                partitionsStartFutures.add(this.createZonePartitionReplicationNode(zoneId, partId, localMemberAssignment, zoneAssignment));
            }
            return CompletableFuture.allOf(partitionsStartFutures.toArray(new CompletableFuture[0]));
        }));
    }

    private CompletableFuture<Void> createZonePartitionReplicationNode(int zoneId, int partId, @Nullable Assignment localMemberAssignment, Assignments stableAssignments) {
        if (localMemberAssignment == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        Assignments forcedAssignments = stableAssignments.force() ? stableAssignments : null;
        PeersAndLearners stablePeersAndLearners = PeersAndLearners.fromAssignments((Collection)stableAssignments.nodes());
        ZonePartitionId replicaGrpId = new ZonePartitionId(zoneId, partId);
        ZonePartitionRaftListener raftGroupListener = new ZonePartitionRaftListener();
        ZoneRebalanceRaftGroupEventsListener raftGroupEventsListener = new ZoneRebalanceRaftGroupEventsListener(this.metaStorageMgr, replicaGrpId, this.busyLock, this.createPartitionMover(replicaGrpId), this.rebalanceScheduler, this::calculateZoneAssignments, this.rebalanceRetryDelayConfiguration);
        Supplier<CompletableFuture> startReplicaSupplier = () -> {
            try {
                return ((CompletableFuture)this.replicaMgr.startReplica((ReplicationGroupId)replicaGrpId, raftClient -> new ZonePartitionReplicaListener((RaftCommandRunner)new ExecutorInclinedRaftCommandRunner((RaftCommandRunner)raftClient, this.partitionOperationsExecutor)), (SnapshotStorageFactory)new FailFastSnapshotStorageFactory(), stablePeersAndLearners, raftGroupListener, (RaftGroupEventsListener)raftGroupEventsListener, this.busyLock).thenCompose(replica -> this.executeUnderZoneWriteLock(zoneId, () -> {
                    this.replicationGroupIds.add(replicaGrpId);
                    LocalPartitionReplicaEventParameters eventParams = new LocalPartitionReplicaEventParameters(new ZonePartitionId(replicaGrpId.zoneId(), replicaGrpId.partitionId()));
                    return this.fireEvent(LocalPartitionReplicaEvent.AFTER_REPLICA_STARTED, eventParams);
                }))).thenApply(unused -> false);
            }
            catch (NodeStoppingException e) {
                return CompletableFuture.failedFuture(e);
            }
        };
        return this.replicaMgr.weakStartReplica((ReplicationGroupId)replicaGrpId, startReplicaSupplier, forcedAssignments).handle((res, ex) -> {
            if (ex != null) {
                LOG.warn("Unable to update raft groups on the node [zoneId={}, partitionId={}]", ex, new Object[]{zoneId, partId});
            }
            return null;
        });
    }

    private CompletableFuture<Set<Assignment>> calculateZoneAssignments(ZonePartitionId zonePartitionId, Long assignmentsTimestamp) {
        return this.waitForMetadataCompleteness(assignmentsTimestamp).thenCompose(unused -> {
            int catalogVersion = this.catalogMgr.activeCatalogVersion(assignmentsTimestamp.longValue());
            CatalogZoneDescriptor zoneDescriptor = this.catalogMgr.zone(zonePartitionId.zoneId(), catalogVersion);
            int zoneId = zonePartitionId.zoneId();
            return this.distributionZoneMgr.dataNodes(zoneDescriptor.updateToken(), catalogVersion, zoneId).thenApply(dataNodes -> PartitionDistributionUtils.calculateAssignmentForPartition((Collection)dataNodes, (int)zonePartitionId.partitionId(), (int)zoneDescriptor.partitions(), (int)zoneDescriptor.replicas()));
        });
    }

    private PartitionMover createPartitionMover(ZonePartitionId replicaGrpId) {
        return new PartitionMover(this.busyLock, () -> {
            CompletableFuture replicaFut = this.replicaMgr.replica((ReplicationGroupId)replicaGrpId);
            if (replicaFut == null) {
                return CompletableFuture.failedFuture((Throwable)new IgniteInternalException("No such replica for partition " + replicaGrpId.partitionId() + " in zone " + replicaGrpId.zoneId()));
            }
            return replicaFut.thenApply(Replica::raftClient);
        });
    }

    private ClusterNode localNode() {
        return this.topologyService.localMember();
    }

    public void beforeNodeStop() {
        this.busyLock.block();
        this.metaStorageMgr.unregisterWatch(this.pendingAssignmentsRebalanceListener);
        this.metaStorageMgr.unregisterWatch(this.stableAssignmentsRebalanceListener);
        this.metaStorageMgr.unregisterWatch(this.assignmentsSwitchRebalanceListener);
        this.cleanUpPartitionsResources(this.replicationGroupIds);
    }

    private CompletableFuture<List<Assignments>> writeZoneAssignmentsToMetastore(int zoneId, CompletableFuture<List<Assignments>> assignmentsFuture) {
        return assignmentsFuture.thenCompose(newAssignments -> {
            assert (!newAssignments.isEmpty());
            ArrayList<Operation> partitionAssignments = new ArrayList<Operation>(newAssignments.size());
            for (int i = 0; i < newAssignments.size(); ++i) {
                ByteArray stableAssignmentsKey = ZoneRebalanceUtil.stablePartAssignmentsKey((ZonePartitionId)new ZonePartitionId(zoneId, i));
                byte[] anAssignment = ((Assignments)newAssignments.get(i)).toBytes();
                Operation op = Operations.put((ByteArray)stableAssignmentsKey, (byte[])anAssignment);
                partitionAssignments.add(op);
            }
            SimpleCondition condition = Conditions.notExists((ByteArray)new ByteArray(ByteUtils.toByteArray((ByteBuffer)((Operation)partitionAssignments.get(0)).key())));
            return ((CompletableFuture)((CompletableFuture)this.metaStorageMgr.invoke((Condition)condition, partitionAssignments, Collections.emptyList()).handle((invokeResult, e) -> {
                if (e != null) {
                    LOG.error("Couldn't write assignments [assignmentsList={}] to metastore during invoke.", e, new Object[]{Assignments.assignmentListToString((List)newAssignments)});
                    throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)e);
                }
                return invokeResult;
            })).thenCompose(invokeResult -> {
                if (invokeResult.booleanValue()) {
                    LOG.info("Assignments calculated from data nodes are successfully written to meta storage [zoneId={}, assignments={}].", new Object[]{zoneId, Assignments.assignmentListToString((List)newAssignments)});
                    return CompletableFuture.completedFuture(newAssignments);
                }
                Set partKeys = IntStream.range(0, newAssignments.size()).mapToObj(p -> ZoneRebalanceUtil.stablePartAssignmentsKey((ZonePartitionId)new ZonePartitionId(zoneId, p))).collect(Collectors.toSet());
                CompletableFuture resFuture = this.metaStorageMgr.getAll(partKeys);
                return resFuture.thenApply(metaStorageAssignments -> {
                    ArrayList<Assignments> realAssignments = new ArrayList<Assignments>();
                    for (int p = 0; p < newAssignments.size(); ++p) {
                        ZonePartitionId partId = new ZonePartitionId(zoneId, p);
                        Entry assignmentsEntry = (Entry)metaStorageAssignments.get(ZoneRebalanceUtil.stablePartAssignmentsKey((ZonePartitionId)partId));
                        assert (assignmentsEntry != null && !assignmentsEntry.empty() && !assignmentsEntry.tombstone()) : "Unexpected assignments for partition [" + String.valueOf(partId) + ", entry=" + String.valueOf(assignmentsEntry) + "].";
                        Assignments real = Assignments.fromBytes((byte[])assignmentsEntry.value());
                        realAssignments.add(real);
                    }
                    LOG.info("Assignments picked up from meta storage [zoneId={}, assignments={}].", new Object[]{zoneId, Assignments.assignmentListToString(realAssignments)});
                    return realAssignments;
                });
            })).handle((realAssignments, e) -> {
                if (e != null) {
                    LOG.error("Couldn't get assignments from metastore for zone [zoneId={}].", e, new Object[]{zoneId});
                    throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)e);
                }
                return realAssignments;
            });
        });
    }

    private CompletableFuture<List<Assignments>> getOrCreateAssignments(CatalogZoneDescriptor zoneDescriptor, long causalityToken, int catalogVersion) {
        CompletionStage<List<Object>> assignmentsFuture;
        if (ZoneRebalanceUtil.zonePartitionAssignmentsGetLocally((MetaStorageManager)this.metaStorageMgr, (int)zoneDescriptor.id(), (int)0, (long)causalityToken) != null) {
            assignmentsFuture = CompletableFuture.completedFuture(ZoneRebalanceUtil.zoneAssignmentsGetLocally((MetaStorageManager)this.metaStorageMgr, (int)zoneDescriptor.id(), (int)zoneDescriptor.partitions(), (long)causalityToken));
        } else {
            Catalog catalog = this.catalogMgr.catalog(catalogVersion);
            long assignmentsTimestamp = catalog.time();
            assignmentsFuture = this.distributionZoneMgr.dataNodes(causalityToken, catalogVersion, zoneDescriptor.id()).thenApply(dataNodes -> PartitionDistributionUtils.calculateAssignments((Collection)dataNodes, (int)zoneDescriptor.partitions(), (int)zoneDescriptor.replicas()).stream().map(assignments -> Assignments.of((Set)assignments, (long)assignmentsTimestamp)).collect(Collectors.toList()));
            ((CompletableFuture)assignmentsFuture).thenAccept(assignmentsList -> LOG.info("Assignments calculated from data nodes [zone={}, zoneId={}, assignments={}, revision={}]", new Object[]{zoneDescriptor.name(), zoneDescriptor.id(), Assignments.assignmentListToString((List)assignmentsList), causalityToken}));
        }
        return assignmentsFuture;
    }

    public boolean hasLocalPartition(ZonePartitionId zonePartitionId) {
        assert (this.zonePartitionsLocks.get(zonePartitionId.zoneId()).tryWriteLock() == 0L);
        return this.replicationGroupIds.contains(zonePartitionId);
    }

    private WatchListener createPendingAssignmentsRebalanceListener() {
        return evt -> {
            if (!this.busyLock.enterBusy()) {
                return CompletableFuture.failedFuture(new NodeStoppingException());
            }
            try {
                Entry newEntry = evt.entryEvent().newEntry();
                CompletableFuture<Void> completableFuture = this.handleChangePendingAssignmentEvent(newEntry, evt.revision(), false);
                return completableFuture;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
    }

    private WatchListener createStableAssignmentsRebalanceListener() {
        return evt -> {
            if (!this.busyLock.enterBusy()) {
                return CompletableFuture.failedFuture(new NodeStoppingException());
            }
            try {
                CompletableFuture<Void> completableFuture = this.handleChangeStableAssignmentEvent(evt);
                return completableFuture;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
    }

    private WatchListener createAssignmentsSwitchRebalanceListener() {
        return evt -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            byte[] key = evt.entryEvent().newEntry().key();
            ZonePartitionId replicaGrpId = ZoneRebalanceUtil.extractZonePartitionId((byte[])key, (byte[])ZoneRebalanceUtil.ASSIGNMENTS_SWITCH_REDUCE_PREFIX_BYTES);
            Assignments assignments = Assignments.fromBytes((byte[])evt.entryEvent().newEntry().value());
            long assignmentsTimestamp = assignments.timestamp();
            return this.waitForMetadataCompleteness(assignmentsTimestamp).thenCompose(unused -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
                int catalogVersion = this.catalogMgr.activeCatalogVersion(assignmentsTimestamp);
                CatalogZoneDescriptor zoneDescriptor = this.catalogMgr.zone(replicaGrpId.zoneId(), catalogVersion);
                long causalityToken = zoneDescriptor.updateToken();
                return this.distributionZoneMgr.dataNodes(causalityToken, catalogVersion, replicaGrpId.zoneId()).thenCompose(dataNodes -> ZoneRebalanceRaftGroupEventsListener.handleReduceChanged((MetaStorageManager)this.metaStorageMgr, (Collection)dataNodes, (int)zoneDescriptor.partitions(), (int)zoneDescriptor.replicas(), (ZonePartitionId)replicaGrpId, (WatchEvent)evt, (long)assignmentsTimestamp));
            }));
        });
    }

    protected CompletableFuture<Void> handleChangeStableAssignmentEvent(WatchEvent evt) {
        if (evt.entryEvents().stream().allMatch(e -> e.oldEntry().value() == null)) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (!evt.single()) {
            assert (evt.entryEvents().stream().allMatch(entryEvent -> entryEvent.newEntry().tombstone())) : evt;
            return CompletableFutures.nullCompletedFuture();
        }
        assert (evt.single()) : evt;
        if (evt.entryEvent().oldEntry() == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        Entry stableAssignmentsWatchEvent = evt.entryEvent().newEntry();
        long revision = evt.revision();
        assert (stableAssignmentsWatchEvent.revision() == revision) : stableAssignmentsWatchEvent;
        if (stableAssignmentsWatchEvent.value() == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.handleChangeStableAssignmentEvent(stableAssignmentsWatchEvent, evt.revision(), false);
    }

    protected CompletableFuture<Void> handleChangeStableAssignmentEvent(Entry stableAssignmentsWatchEvent, long revision, boolean isRecovery) {
        ZonePartitionId zonePartitionId = ZoneRebalanceUtil.extractZonePartitionId((byte[])stableAssignmentsWatchEvent.key(), (byte[])ZoneRebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES);
        Set stableAssignments = stableAssignmentsWatchEvent.value() == null ? Collections.emptySet() : Assignments.fromBytes((byte[])stableAssignmentsWatchEvent.value()).nodes();
        return CompletableFuture.supplyAsync(() -> {
            Entry pendingAssignmentsEntry = this.metaStorageMgr.getLocally(ZoneRebalanceUtil.pendingPartAssignmentsKey((ZonePartitionId)zonePartitionId), revision);
            byte[] pendingAssignmentsFromMetaStorage = pendingAssignmentsEntry.value();
            Assignments pendingAssignments = pendingAssignmentsFromMetaStorage == null ? Assignments.EMPTY : Assignments.fromBytes((byte[])pendingAssignmentsFromMetaStorage);
            return this.stopAndDestroyPartitionAndUpdateClients(zonePartitionId, stableAssignments, pendingAssignments, isRecovery);
        }, this.ioExecutor).thenCompose(Function.identity());
    }

    private CompletableFuture<Void> updatePartitionClients(ZonePartitionId zonePartitionId, Set<Assignment> stableAssignments) {
        return this.isLocalNodeIsPrimary((ReplicationGroupId)zonePartitionId).thenCompose(isLeaseholder -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            boolean isLocalInStable = this.isLocalNodeInAssignments(stableAssignments);
            if (!isLocalInStable && !isLeaseholder.booleanValue()) {
                return CompletableFutures.nullCompletedFuture();
            }
            assert (this.replicaMgr.isReplicaStarted((ReplicationGroupId)zonePartitionId)) : "The local node is outside of the replication group [groupId=" + String.valueOf(zonePartitionId) + ", stable=" + String.valueOf(stableAssignments) + ", isLeaseholder=" + isLeaseholder + "].";
            return this.replicaMgr.replica((ReplicationGroupId)zonePartitionId).thenAccept(replica -> replica.updatePeersAndLearners(PeersAndLearners.fromAssignments((Collection)stableAssignments)));
        }));
    }

    private CompletableFuture<Void> stopAndDestroyPartitionAndUpdateClients(ZonePartitionId zonePartitionId, Set<Assignment> stableAssignments, Assignments pendingAssignments, boolean isRecovery) {
        CompletableFuture<Void> clientUpdateFuture = isRecovery ? CompletableFutures.nullCompletedFuture() : this.updatePartitionClients(zonePartitionId, stableAssignments);
        boolean shouldStopLocalServices = (pendingAssignments.force() ? pendingAssignments.nodes().stream() : Stream.concat(stableAssignments.stream(), pendingAssignments.nodes().stream())).noneMatch(assignment -> assignment.consistentId().equals(this.localNode().name()));
        if (shouldStopLocalServices) {
            return ((CompletableFuture)clientUpdateFuture.thenCompose(v -> this.stopAndDestroyPartition(zonePartitionId))).thenAccept(v -> {});
        }
        return clientUpdateFuture;
    }

    private CompletableFuture<?> stopAndDestroyPartition(ZonePartitionId zonePartitionId) {
        return this.weakStopPartition(zonePartitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> handleChangePendingAssignmentEvent(Entry pendingAssignmentsEntry, long revision, boolean isRecovery) {
        if (pendingAssignmentsEntry.value() == null || pendingAssignmentsEntry.empty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        ZonePartitionId zonePartitionId = ZoneRebalanceUtil.extractZonePartitionId((byte[])pendingAssignmentsEntry.key(), (byte[])ZoneRebalanceUtil.PENDING_ASSIGNMENTS_PREFIX_BYTES);
        Assignments stableAssignments = this.stableAssignments(zonePartitionId, revision);
        Assignments pendingAssignments = Assignments.fromBytes((byte[])pendingAssignmentsEntry.value());
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            if (LOG.isInfoEnabled()) {
                String stringKey = new String(pendingAssignmentsEntry.key(), StandardCharsets.UTF_8);
                LOG.info("Received update on pending assignments. Check if new replication node should be started [key={}, partition={}, zoneId={}, localMemberAddress={}, pendingAssignments={}, revision={}]", new Object[]{stringKey, zonePartitionId.partitionId(), zonePartitionId.zoneId(), this.localNode().address(), pendingAssignments, revision});
            }
            CompletionStage completionStage = this.handleChangePendingAssignmentEvent(zonePartitionId, stableAssignments, pendingAssignments, revision).thenCompose(v -> {
                boolean isLocalNodeInStableOrPending = this.isNodeInReducedStableOrPendingAssignments(zonePartitionId, stableAssignments, pendingAssignments, revision);
                if (!isLocalNodeInStableOrPending) {
                    return CompletableFutures.nullCompletedFuture();
                }
                return this.changePeersOnRebalance(this.replicaMgr, zonePartitionId, pendingAssignments.nodes(), revision);
            });
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<Void> handleChangePendingAssignmentEvent(ZonePartitionId replicaGrpId, @Nullable Assignments stableAssignments, Assignments pendingAssignments, long revision) {
        boolean shouldStartLocalGroupNode;
        boolean pendingAssignmentsAreForced = pendingAssignments.force();
        Set pendingAssignmentsNodes = pendingAssignments.nodes();
        Assignment localMemberAssignment = this.localMemberAssignment(pendingAssignments);
        boolean bl = shouldStartLocalGroupNode = localMemberAssignment != null && (stableAssignments == null || !stableAssignments.nodes().contains(localMemberAssignment));
        Assignments computedStableAssignments = stableAssignments == null || stableAssignments.nodes().isEmpty() ? Assignments.forced((Set)pendingAssignmentsNodes, (long)pendingAssignments.timestamp()) : (pendingAssignmentsAreForced ? pendingAssignments : stableAssignments);
        int partitionId = replicaGrpId.partitionId();
        int zoneId = replicaGrpId.zoneId();
        CompletableFuture<Void> localServicesStartFuture = shouldStartLocalGroupNode ? this.createZonePartitionReplicationNode(zoneId, partitionId, localMemberAssignment, computedStableAssignments) : (pendingAssignmentsAreForced && localMemberAssignment != null ? CompletableFuture.runAsync(() -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.replicaMgr.resetPeers((ReplicationGroupId)replicaGrpId, PeersAndLearners.fromAssignments((Collection)computedStableAssignments.nodes()))), this.ioExecutor) : CompletableFutures.nullCompletedFuture());
        return ((CompletableFuture)localServicesStartFuture.thenComposeAsync(v -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.isLocalNodeIsPrimary((ReplicationGroupId)replicaGrpId)), (Executor)this.ioExecutor)).thenAcceptAsync(isLeaseholder -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            boolean isLocalNodeInStableOrPending = this.isNodeInReducedStableOrPendingAssignments(replicaGrpId, stableAssignments, pendingAssignments, revision);
            if (!isLocalNodeInStableOrPending && !isLeaseholder.booleanValue()) {
                return;
            }
            assert (isLocalNodeInStableOrPending || isLeaseholder.booleanValue()) : "The local node is outside of the replication group [inStableOrPending=" + isLocalNodeInStableOrPending + ", isLeaseholder=" + isLeaseholder + "].";
            Set newAssignments = pendingAssignmentsAreForced || stableAssignments == null ? pendingAssignmentsNodes : RebalanceUtil.union((Set)pendingAssignmentsNodes, (Set)stableAssignments.nodes());
            this.replicaMgr.replica((ReplicationGroupId)replicaGrpId).thenAccept(replica -> replica.updatePeersAndLearners(PeersAndLearners.fromAssignments((Collection)newAssignments)));
        }), (Executor)this.ioExecutor);
    }

    private CompletableFuture<Void> changePeersOnRebalance(ReplicaManager replicaMgr, ZonePartitionId replicaGrpId, Set<Assignment> pendingAssignments, long revision) {
        return ((CompletableFuture)replicaMgr.replica((ReplicationGroupId)replicaGrpId).thenApply(Replica::raftClient)).thenCompose(raftClient -> ((CompletableFuture)raftClient.refreshAndGetLeaderWithTerm().exceptionally(throwable -> {
            if ((throwable = ExceptionUtils.unwrapCause((Throwable)throwable)) instanceof TimeoutException) {
                LOG.info("Node couldn't get the leader within timeout so the changing peers is skipped [grp={}].", new Object[]{replicaGrpId});
                return LeaderWithTerm.NO_LEADER;
            }
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Failed to get a leader for the RAFT replication group [get=" + String.valueOf(replicaGrpId) + "].", throwable);
        })).thenCompose(leaderWithTerm -> {
            if (leaderWithTerm.isEmpty() || !this.isLocalPeer(leaderWithTerm.leader())) {
                return CompletableFutures.nullCompletedFuture();
            }
            LOG.info("Current node={} is the leader of partition raft group={}. Initiate rebalance process for partition={}, zoneId={}", new Object[]{leaderWithTerm.leader(), replicaGrpId, replicaGrpId.partitionId(), replicaGrpId.zoneId()});
            return this.metaStorageMgr.get(ZoneRebalanceUtil.pendingPartAssignmentsKey((ZonePartitionId)replicaGrpId)).thenCompose(latestPendingAssignmentsEntry -> {
                if (revision < latestPendingAssignmentsEntry.revision()) {
                    return CompletableFutures.nullCompletedFuture();
                }
                PeersAndLearners newConfiguration = PeersAndLearners.fromAssignments((Collection)pendingAssignments);
                CompletionStage voidCompletableFuture = raftClient.changePeersAndLearnersAsync(newConfiguration, leaderWithTerm.term()).exceptionally(e -> null);
                return voidCompletableFuture;
            });
        }));
    }

    private boolean isLocalPeer(Peer peer) {
        return peer.consistentId().equals(this.localNode().name());
    }

    private boolean isLocalNodeInAssignments(Collection<Assignment> assignments) {
        return assignments.stream().anyMatch(this.isLocalNodeAssignment);
    }

    private CompletableFuture<Void> waitForMetadataCompleteness(long ts) {
        return this.schemaSyncService.waitForMetadataCompleteness(HybridTimestamp.hybridTimestamp((long)ts));
    }

    private CompletableFuture<Boolean> isLocalNodeIsPrimary(ReplicationGroupId replicationGroupId) {
        HybridTimestamp currentSafeTime = this.metaStorageMgr.clusterTime().currentSafeTime();
        if (HybridTimestamp.MIN_VALUE.equals((Object)currentSafeTime)) {
            return CompletableFutures.falseCompletedFuture();
        }
        long skewMs = this.clockService.maxClockSkewMillis();
        try {
            HybridTimestamp previousMetastoreSafeTime = currentSafeTime.subtractPhysicalTime(skewMs);
            return this.placementDriver.getPrimaryReplica(replicationGroupId, previousMetastoreSafeTime).thenApply(replicaMeta -> replicaMeta != null && replicaMeta.getLeaseholderId() != null && replicaMeta.getLeaseholderId().equals(this.localNode().id()));
        }
        catch (IllegalArgumentException e) {
            long currentSafeTimeMs = currentSafeTime.longValue();
            throw new AssertionError("Got a negative time [currentSafeTime=" + String.valueOf(currentSafeTime) + ", currentSafeTimeMs=" + currentSafeTimeMs + ", skewMs=" + skewMs + ", internal=" + (currentSafeTimeMs + (-skewMs << 16)) + "]", e);
        }
    }

    private boolean isNodeInReducedStableOrPendingAssignments(ZonePartitionId replicaGrpId, @Nullable Assignments stableAssignments, Assignments pendingAssignments, long revision) {
        Set reducedStableAssignments;
        Entry reduceEntry = this.metaStorageMgr.getLocally(ZoneRebalanceUtil.switchReduceKey((ZonePartitionId)replicaGrpId), revision);
        Assignments reduceAssignments = reduceEntry != null ? Assignments.fromBytes((byte[])reduceEntry.value()) : null;
        Set set = reducedStableAssignments = reduceAssignments != null ? RebalanceUtil.subtract((Set)stableAssignments.nodes(), (Set)reduceAssignments.nodes()) : stableAssignments.nodes();
        if (!this.isLocalNodeInAssignments(RebalanceUtil.union((Set)reducedStableAssignments, (Set)pendingAssignments.nodes()))) {
            return false;
        }
        assert (this.replicaMgr.isReplicaStarted((ReplicationGroupId)replicaGrpId)) : "The local node is outside of the replication group [, stable=" + String.valueOf(stableAssignments) + ", pending=" + String.valueOf(pendingAssignments) + ", reduce=" + String.valueOf(reduceAssignments) + ", localName=" + this.localNode().name() + "].";
        return true;
    }

    @Nullable
    private Assignment localMemberAssignment(Assignments assignments) {
        Assignment localMemberAssignment = Assignment.forPeer((String)this.localNode().name());
        return assignments.nodes().contains(localMemberAssignment) ? localMemberAssignment : null;
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!ENABLED) {
            return CompletableFutures.nullCompletedFuture();
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Nullable
    private Assignments stableAssignments(ZonePartitionId zonePartitionId, long revision) {
        Entry entry = this.metaStorageMgr.getLocally(ZoneRebalanceUtil.stablePartAssignmentsKey((ZonePartitionId)zonePartitionId), revision);
        return Assignments.fromBytes((byte[])entry.value());
    }

    private CompletableFuture<Void> weakStopPartition(ZonePartitionId zonePartitionId) {
        return this.replicaMgr.weakStopReplica((ReplicationGroupId)zonePartitionId, ReplicaManager.WeakReplicaStopReason.EXCLUDED_FROM_ASSIGNMENTS, () -> this.stopPartition(zonePartitionId).thenAccept(v -> {}));
    }

    private CompletableFuture<?> stopPartition(ZonePartitionId zonePartitionId) {
        return this.executeUnderZoneWriteLock(zonePartitionId.zoneId(), () -> {
            try {
                return this.replicaMgr.stopReplica((ReplicationGroupId)zonePartitionId).thenCompose(replicaWasStopped -> {
                    if (replicaWasStopped.booleanValue()) {
                        this.replicationGroupIds.remove(zonePartitionId);
                        return this.fireEvent(LocalPartitionReplicaEvent.AFTER_REPLICA_STOPPED, new LocalPartitionReplicaEventParameters(zonePartitionId));
                    }
                    return CompletableFutures.nullCompletedFuture();
                });
            }
            catch (NodeStoppingException e) {
                return CompletableFutures.nullCompletedFuture();
            }
        });
    }

    private void cleanUpPartitionsResources(Set<ZonePartitionId> partitionIds) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            Stream.Builder<ManuallyCloseable> stopping = Stream.builder();
            stopping.add(() -> {
                CompletableFuture[] stopReplicaFutures = new CompletableFuture[partitionIds.size()];
                int i = 0;
                for (ZonePartitionId partitionId : partitionIds) {
                    stopReplicaFutures[i++] = this.stopPartition(partitionId);
                }
                CompletableFuture.allOf(stopReplicaFutures).get(10L, TimeUnit.SECONDS);
            });
            try {
                IgniteUtils.closeAllManually(stopping.build());
            }
            catch (Throwable t) {
                LOG.error("Unable to stop partition.", t);
            }
        }, this.ioExecutor);
        try {
            future.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Unable to clean zones resources", (Throwable)e);
        }
    }

    public long lockZoneForRead(int zoneId) {
        return this.zonePartitionsLocks.computeIfAbsent(zoneId, id -> new StampedLock()).readLock();
    }

    public void unlockZoneForRead(int zoneId, long stamp) {
        this.zonePartitionsLocks.get(zoneId).unlockRead(stamp);
    }

    public void loadTableListenerToZoneReplica(ZonePartitionId zonePartitionId, TablePartitionId tablePartitionId, Function<RaftCommandRunner, ReplicaListener> createListener) {
        CompletableFuture replicaFut = this.replicaMgr.replica((ReplicationGroupId)zonePartitionId);
        assert (replicaFut != null && replicaFut.isDone());
        ((ZonePartitionReplicaListener)((Replica)replicaFut.join()).listener()).addTableReplicaListener(tablePartitionId, createListener);
    }

    private CompletableFuture<Void> executeUnderZoneWriteLock(int zoneId, Supplier<CompletableFuture<Void>> action) {
        StampedLock lock = this.zonePartitionsLocks.computeIfAbsent(zoneId, id -> new StampedLock());
        long stamp = lock.writeLock();
        try {
            return action.get().whenComplete((v, e) -> lock.unlockWrite(stamp));
        }
        catch (Throwable e2) {
            lock.unlockWrite(stamp);
            return CompletableFuture.failedFuture(e2);
        }
    }
}

