/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.raft.ResponseEntryBuilder;
import org.apache.ignite.internal.partition.replicator.network.raft.ResponseEntrySerializer;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponse;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ResponseEntryImpl
implements SnapshotMvDataResponse.ResponseEntry,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 13;
    @IgniteToStringInclude
    private final int commitPartitionId;
    @IgniteToStringInclude
    private final Integer commitTableId;
    @IgniteToStringInclude
    private final UUID rowId;
    @IgniteToStringInclude
    private final List<BinaryRowMessage> rowVersions;
    @IgniteToStringInclude
    private final long[] timestamps;
    @IgniteToStringInclude
    private final UUID txId;

    private ResponseEntryImpl(int commitPartitionId, Integer commitTableId, UUID rowId, List<BinaryRowMessage> rowVersions, long[] timestamps, UUID txId) {
        this.commitPartitionId = commitPartitionId;
        this.commitTableId = commitTableId;
        this.rowId = rowId;
        this.rowVersions = rowVersions;
        this.timestamps = timestamps;
        this.txId = txId;
    }

    @Override
    public int commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    public Integer commitTableId() {
        return this.commitTableId;
    }

    @Override
    public UUID rowId() {
        return this.rowId;
    }

    @Override
    public List<BinaryRowMessage> rowVersions() {
        return this.rowVersions;
    }

    @Override
    public long[] timestamps() {
        return this.timestamps;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return ResponseEntrySerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ResponseEntryImpl.class, (Object)this);
    }

    public short messageType() {
        return 13;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResponseEntryImpl otherMessage = (ResponseEntryImpl)other;
        return Objects.equals(this.commitTableId, otherMessage.commitTableId) && Objects.equals(this.rowId, otherMessage.rowId) && Objects.equals(this.rowVersions, otherMessage.rowVersions) && Objects.equals(this.txId, otherMessage.txId) && Arrays.equals(this.timestamps, otherMessage.timestamps) && this.commitPartitionId == otherMessage.commitPartitionId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commitPartitionId, this.commitTableId, this.rowId, this.rowVersions, this.txId);
        result = 31 * result + Arrays.hashCode(this.timestamps);
        return result;
    }

    public ResponseEntryImpl clone() {
        try {
            return (ResponseEntryImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ResponseEntryBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rowVersions != null) {
            for (BinaryRowMessage obj : this.rowVersions) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rowVersions != null) {
            for (BinaryRowMessage obj : this.rowVersions) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements ResponseEntryBuilder {
        private int commitPartitionId;
        private Integer commitTableId;
        private UUID rowId;
        private List<BinaryRowMessage> rowVersions;
        private long[] timestamps;
        private UUID txId;

        private Builder() {
        }

        @Override
        public ResponseEntryBuilder commitPartitionId(int commitPartitionId) {
            this.commitPartitionId = commitPartitionId;
            return this;
        }

        @Override
        public ResponseEntryBuilder commitTableId(Integer commitTableId) {
            this.commitTableId = commitTableId;
            return this;
        }

        @Override
        public ResponseEntryBuilder rowId(UUID rowId) {
            Objects.requireNonNull(rowId, "rowId is not marked @Nullable");
            this.rowId = rowId;
            return this;
        }

        @Override
        public ResponseEntryBuilder rowVersions(List<BinaryRowMessage> rowVersions) {
            Objects.requireNonNull(rowVersions, "rowVersions is not marked @Nullable");
            this.rowVersions = rowVersions;
            return this;
        }

        @Override
        public ResponseEntryBuilder timestamps(long[] timestamps) {
            Objects.requireNonNull(timestamps, "timestamps is not marked @Nullable");
            this.timestamps = timestamps;
            return this;
        }

        @Override
        public ResponseEntryBuilder txId(UUID txId) {
            this.txId = txId;
            return this;
        }

        @Override
        public int commitPartitionId() {
            return this.commitPartitionId;
        }

        @Override
        public Integer commitTableId() {
            return this.commitTableId;
        }

        @Override
        public UUID rowId() {
            return this.rowId;
        }

        @Override
        public List<BinaryRowMessage> rowVersions() {
            return this.rowVersions;
        }

        @Override
        public long[] timestamps() {
            return this.timestamps;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public SnapshotMvDataResponse.ResponseEntry build() {
            return new ResponseEntryImpl(this.commitPartitionId, this.commitTableId, Objects.requireNonNull(this.rowId, "rowId is not marked @Nullable"), Objects.requireNonNull(this.rowVersions, "rowVersions is not marked @Nullable"), Objects.requireNonNull(this.timestamps, "timestamps is not marked @Nullable"), this.txId);
        }
    }
}

