/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.replication.ScanCloseReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ScanCloseReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.ScanCloseReplicaRequestSerializer;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ScanCloseReplicaRequestImpl
implements ScanCloseReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final long scanId;
    @IgniteToStringInclude
    private final UUID transactionId;

    private ScanCloseReplicaRequestImpl(ReplicationGroupIdMessage groupId, long scanId, UUID transactionId) {
        this.groupId = groupId;
        this.scanId = scanId;
        this.transactionId = transactionId;
    }

    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public long scanId() {
        return this.scanId;
    }

    @Override
    public UUID transactionId() {
        return this.transactionId;
    }

    public MessageSerializer serializer() {
        return ScanCloseReplicaRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ScanCloseReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ScanCloseReplicaRequestImpl otherMessage = (ScanCloseReplicaRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.transactionId, otherMessage.transactionId) && this.scanId == otherMessage.scanId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.scanId, this.groupId, this.transactionId);
        return result;
    }

    public ScanCloseReplicaRequestImpl clone() {
        try {
            return (ScanCloseReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ScanCloseReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ScanCloseReplicaRequestBuilder {
        private ReplicationGroupIdMessage groupId;
        private long scanId;
        private UUID transactionId;

        private Builder() {
        }

        @Override
        public ScanCloseReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ScanCloseReplicaRequestBuilder scanId(long scanId) {
            this.scanId = scanId;
            return this;
        }

        @Override
        public ScanCloseReplicaRequestBuilder transactionId(UUID transactionId) {
            Objects.requireNonNull(transactionId, "transactionId is not marked @Nullable");
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public long scanId() {
            return this.scanId;
        }

        @Override
        public UUID transactionId() {
            return this.transactionId;
        }

        @Override
        public ScanCloseReplicaRequest build() {
            return new ScanCloseReplicaRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), this.scanId, Objects.requireNonNull(this.transactionId, "transactionId is not marked @Nullable"));
        }
    }
}

