/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedDoubleUpDownCounter;
import io.opentelemetry.api.incubator.metrics.ExtendedDoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.InstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.SdkMeter;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkDoubleUpDownCounter
extends AbstractInstrument
implements ExtendedDoubleUpDownCounter {
    private final SdkMeter sdkMeter;
    private final WriteableMetricStorage storage;

    private SdkDoubleUpDownCounter(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    public void add(double increment, Attributes attributes, Context context) {
        this.storage.recordDouble(increment, attributes, context);
    }

    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    public boolean isEnabled() {
        return this.sdkMeter.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkDoubleUpDownCounterBuilder
    implements ExtendedDoubleUpDownCounterBuilder {
        private final InstrumentBuilder builder;

        SdkDoubleUpDownCounterBuilder(SdkMeter sdkMeter, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.DOUBLE, sdkMeter).setDescription(description).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        public DoubleUpDownCounterBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        public DoubleUpDownCounterBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        public DoubleUpDownCounter build() {
            return (DoubleUpDownCounter)this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkDoubleUpDownCounter(x$0, x$1, x$2));
        }

        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback);
        }

        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER);
        }

        public ExtendedDoubleUpDownCounterBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

