/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import java.util.BitSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLException;
import org.apache.ignite.client.handler.ClientContext;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.client.handler.ClientPrimaryReplicaTracker;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.ClusterInfo;
import org.apache.ignite.client.handler.JdbcQueryCursorHandlerImpl;
import org.apache.ignite.client.handler.JdbcQueryEventHandlerImpl;
import org.apache.ignite.client.handler.NotificationSender;
import org.apache.ignite.client.handler.configuration.ClientConnectorView;
import org.apache.ignite.client.handler.requests.cluster.ClientClusterGetNodesRequest;
import org.apache.ignite.client.handler.requests.compute.ClientComputeCancelRequest;
import org.apache.ignite.client.handler.requests.compute.ClientComputeChangePriorityRequest;
import org.apache.ignite.client.handler.requests.compute.ClientComputeExecuteColocatedRequest;
import org.apache.ignite.client.handler.requests.compute.ClientComputeExecuteMapReduceRequest;
import org.apache.ignite.client.handler.requests.compute.ClientComputeExecutePartitionedRequest;
import org.apache.ignite.client.handler.requests.compute.ClientComputeExecuteRequest;
import org.apache.ignite.client.handler.requests.compute.ClientComputeGetStateRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcCancelRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcCloseRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcColumnMetadataRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcConnectRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcExecuteBatchRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcExecuteRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcFetchRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcFinishTxRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcHasMoreRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcPreparedStmntBatchRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcPrimaryKeyMetadataRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcSchemasMetadataRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcTableMetadataRequest;
import org.apache.ignite.client.handler.requests.jdbc.JdbcMetadataCatalog;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCursorCloseRequest;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCursorNextPageRequest;
import org.apache.ignite.client.handler.requests.sql.ClientSqlExecuteBatchRequest;
import org.apache.ignite.client.handler.requests.sql.ClientSqlExecuteRequest;
import org.apache.ignite.client.handler.requests.sql.ClientSqlExecuteScriptRequest;
import org.apache.ignite.client.handler.requests.sql.ClientSqlQueryMetadataRequest;
import org.apache.ignite.client.handler.requests.table.ClientSchemasGetRequest;
import org.apache.ignite.client.handler.requests.table.ClientStreamerBatchSendRequest;
import org.apache.ignite.client.handler.requests.table.ClientStreamerWithReceiverBatchSendRequest;
import org.apache.ignite.client.handler.requests.table.ClientTableGetRequest;
import org.apache.ignite.client.handler.requests.table.ClientTablePartitionPrimaryReplicasGetRequest;
import org.apache.ignite.client.handler.requests.table.ClientTablesGetRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleContainsAllKeysRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleContainsKeyRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleDeleteAllExactRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleDeleteAllRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleDeleteExactRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleDeleteRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleGetAllRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleGetAndDeleteRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleGetAndReplaceRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleGetAndUpsertRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleGetRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleInsertAllRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleInsertRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleReplaceExactRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleReplaceRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleUpsertAllRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleUpsertRequest;
import org.apache.ignite.client.handler.requests.table.partition.ClientTablePartitionPrimaryReplicasNodesGetRequest;
import org.apache.ignite.client.handler.requests.tx.ClientTransactionBeginRequest;
import org.apache.ignite.client.handler.requests.tx.ClientTransactionCommitRequest;
import org.apache.ignite.client.handler.requests.tx.ClientTransactionRollbackRequest;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.client.proto.ClientMessageCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.HandshakeExtension;
import org.apache.ignite.internal.client.proto.HandshakeUtils;
import org.apache.ignite.internal.client.proto.ProtocolVersion;
import org.apache.ignite.internal.client.proto.ResponseFlags;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.jdbc.proto.JdbcQueryCursorHandler;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.properties.IgniteProductVersion;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.schema.SchemaVersionMismatchException;
import org.apache.ignite.internal.security.authentication.AnonymousRequest;
import org.apache.ignite.internal.security.authentication.AuthenticationManager;
import org.apache.ignite.internal.security.authentication.AuthenticationRequest;
import org.apache.ignite.internal.security.authentication.UserDetails;
import org.apache.ignite.internal.security.authentication.UsernamePasswordRequest;
import org.apache.ignite.internal.security.authentication.event.AuthenticationEvent;
import org.apache.ignite.internal.security.authentication.event.AuthenticationEventParameters;
import org.apache.ignite.internal.security.authentication.event.AuthenticationProviderEventParameters;
import org.apache.ignite.internal.security.authentication.event.UserEventParameters;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersionsImpl;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.TraceableException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.security.AuthenticationType;
import org.apache.ignite.security.exception.UnsupportedAuthenticationTypeException;
import org.apache.ignite.sql.SqlBatchException;
import org.apache.ignite.table.IgniteTables;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClientInboundMessageHandler
extends ChannelInboundHandlerAdapter
implements EventListener<AuthenticationEventParameters> {
    private static final IgniteLogger LOG = Loggers.forClass(ClientInboundMessageHandler.class);
    private static final byte STATE_BEFORE_HANDSHAKE = 0;
    private static final byte STATE_HANDSHAKE_REQUESTED = 1;
    private static final byte STATE_HANDSHAKE_RESPONSE_SENT = 2;
    private final IgniteTablesInternal igniteTables;
    private final TxManager txManager;
    private final JdbcQueryEventHandlerImpl jdbcQueryEventHandler;
    private final ClientResourceRegistry resources = new ClientResourceRegistry();
    private final ClientConnectorView configuration;
    private final IgniteComputeInternal compute;
    private final ClusterService clusterService;
    private final QueryProcessor queryProcessor;
    private final JdbcQueryCursorHandler jdbcQueryCursorHandler;
    private final Supplier<ClusterInfo> clusterInfoSupplier;
    private final ClientHandlerMetricSource metrics;
    private final ClockService clockService;
    private ClientContext clientContext;
    private byte state = 0;
    private volatile ChannelHandlerContext channelHandlerContext;
    private final AtomicLong primaryReplicaMaxStartTime;
    private final ClientPrimaryReplicaTracker primaryReplicaTracker;
    private final AuthenticationManager authenticationManager;
    private final SchemaVersions schemaVersions;
    private final long connectionId;
    private final Executor partitionOperationsExecutor;
    private final BitSet features;
    private final Map<HandshakeExtension, Object> extensions;

    public ClientInboundMessageHandler(IgniteTablesInternal igniteTables, TxManager txManager, QueryProcessor processor, ClientConnectorView configuration, IgniteComputeInternal compute, ClusterService clusterService, Supplier<ClusterInfo> clusterInfoSupplier, ClientHandlerMetricSource metrics, AuthenticationManager authenticationManager, ClockService clockService, SchemaSyncService schemaSyncService, CatalogService catalogService, long connectionId, ClientPrimaryReplicaTracker primaryReplicaTracker, Executor partitionOperationsExecutor, BitSet features, Map<HandshakeExtension, Object> extensions) {
        assert (igniteTables != null);
        assert (txManager != null);
        assert (processor != null);
        assert (configuration != null);
        assert (compute != null);
        assert (clusterService != null);
        assert (clusterInfoSupplier != null);
        assert (metrics != null);
        assert (authenticationManager != null);
        assert (clockService != null);
        assert (schemaSyncService != null);
        assert (catalogService != null);
        assert (primaryReplicaTracker != null);
        assert (partitionOperationsExecutor != null);
        assert (features != null);
        assert (extensions != null);
        this.igniteTables = igniteTables;
        this.txManager = txManager;
        this.configuration = configuration;
        this.compute = compute;
        this.clusterService = clusterService;
        this.queryProcessor = processor;
        this.clusterInfoSupplier = clusterInfoSupplier;
        this.metrics = metrics;
        this.authenticationManager = authenticationManager;
        this.clockService = clockService;
        this.primaryReplicaTracker = primaryReplicaTracker;
        this.partitionOperationsExecutor = partitionOperationsExecutor;
        this.jdbcQueryCursorHandler = new JdbcQueryCursorHandlerImpl(this.resources);
        this.jdbcQueryEventHandler = new JdbcQueryEventHandlerImpl(processor, new JdbcMetadataCatalog(clockService, schemaSyncService, catalogService), this.resources, txManager);
        this.schemaVersions = new SchemaVersionsImpl(schemaSyncService, catalogService, clockService);
        this.connectionId = connectionId;
        this.primaryReplicaMaxStartTime = new AtomicLong(HybridTimestamp.MIN_VALUE.longValue());
        this.features = features;
        this.extensions = extensions;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        ClientInboundMessageHandler.authenticationEventsToSubscribe().forEach(event -> this.authenticationManager.listen((Event)event, (EventListener)this));
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        ClientInboundMessageHandler.authenticationEventsToSubscribe().forEach(event -> this.authenticationManager.removeListener((Event)event, (EventListener)this));
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.channelHandlerContext = ctx;
        super.channelRegistered(ctx);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection registered [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf byteBuf = (ByteBuf)msg;
        ClientMessageUnpacker unpacker = new ClientMessageUnpacker(byteBuf);
        this.metrics.bytesReceivedAdd(byteBuf.readableBytes() + 4);
        switch (this.state) {
            case 0: {
                this.state = 1;
                this.metrics.bytesReceivedAdd(ClientMessageCommon.MAGIC_BYTES.length);
                ClientMessagePacker packer = ClientInboundMessageHandler.getPacker(ctx.alloc());
                this.handshake(ctx, unpacker, packer);
                break;
            }
            case 1: {
                throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unexpected message received before handshake completion");
            }
            case 2: {
                assert (this.clientContext != null) : "Client context != null";
                this.processOperation(ctx, unpacker);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state: " + this.state);
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.resources.close();
        super.channelInactive(ctx);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection closed [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshake(ChannelHandlerContext ctx, ClientMessageUnpacker unpacker, ClientMessagePacker packer) {
        try {
            this.writeMagic(ctx);
            ProtocolVersion clientVer = ProtocolVersion.unpack((ClientMessageUnpacker)unpacker);
            if (!clientVer.equals((Object)ProtocolVersion.LATEST_VER)) {
                throw new IgniteException(ErrorGroups.Client.PROTOCOL_COMPATIBILITY_ERR, "Unsupported version: " + clientVer.major() + "." + clientVer.minor() + "." + clientVer.patch());
            }
            int clientCode = unpacker.unpackInt();
            BitSet features = HandshakeUtils.unpackFeatures((ClientMessageUnpacker)unpacker);
            Map extensions = HandshakeUtils.unpackExtensions((ClientMessageUnpacker)unpacker);
            this.authenticationManager.authenticateAsync(ClientInboundMessageHandler.createAuthenticationRequest(extensions)).handleAsync((user, err) -> {
                if (err != null) {
                    this.handshakeError(ctx, packer, (Throwable)err);
                } else {
                    this.clientContext = new ClientContext(clientVer, clientCode, features, (UserDetails)user);
                    this.sendHandshakeResponse(ctx, packer);
                }
                return null;
            }, (Executor)ctx.executor());
        }
        catch (Throwable t) {
            this.handshakeError(ctx, packer, t);
        }
        finally {
            unpacker.close();
        }
    }

    private void handshakeError(ChannelHandlerContext ctx, ClientMessagePacker packer, Throwable t) {
        LOG.warn("Handshake failed [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]: " + t.getMessage(), t);
        packer.close();
        ClientMessagePacker errPacker = ClientInboundMessageHandler.getPacker(ctx.alloc());
        try {
            ProtocolVersion.LATEST_VER.pack(errPacker);
            this.writeErrorCore(t, errPacker);
            this.write(errPacker, ctx);
        }
        catch (Throwable t2) {
            LOG.warn("Handshake failed [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]: " + t2.getMessage(), t2);
            errPacker.close();
            this.exceptionCaught(ctx, t2);
        }
        this.metrics.sessionsRejectedIncrement();
    }

    private void sendHandshakeResponse(ChannelHandlerContext ctx, ClientMessagePacker packer) {
        ProtocolVersion.LATEST_VER.pack(packer);
        packer.packNil();
        packer.packLong(this.configuration.idleTimeout());
        ClusterNode localMember = this.clusterService.topologyService().localMember();
        packer.packUuid(localMember.id());
        packer.packString(localMember.name());
        ClusterInfo clusterInfo = this.clusterInfoSupplier.get();
        packer.packInt(clusterInfo.idHistory().size());
        for (UUID clusterId : clusterInfo.idHistory()) {
            packer.packUuid(clusterId);
        }
        packer.packString(clusterInfo.name());
        packer.packLong(this.observableTimestamp(null));
        packer.packByte(IgniteProductVersion.CURRENT_VERSION.major());
        packer.packByte(IgniteProductVersion.CURRENT_VERSION.minor());
        packer.packByte(IgniteProductVersion.CURRENT_VERSION.maintenance());
        packer.packByteNullable(IgniteProductVersion.CURRENT_VERSION.patch());
        packer.packStringNullable(IgniteProductVersion.CURRENT_VERSION.preRelease());
        HandshakeUtils.packFeatures((ClientMessagePacker)packer, (BitSet)this.features);
        HandshakeUtils.packExtensions((ClientMessagePacker)packer, this.extensions);
        this.write(packer, ctx);
        this.state = (byte)2;
        this.metrics.sessionsAcceptedIncrement();
        this.metrics.sessionsActiveIncrement();
        ctx.channel().closeFuture().addListener(f -> this.metrics.sessionsActiveDecrement());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handshake [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]: " + String.valueOf(this.clientContext), new Object[0]);
        }
    }

    private static AuthenticationRequest<?, ?> createAuthenticationRequest(Map<HandshakeExtension, Object> extensions) {
        Object authnType = extensions.get(HandshakeExtension.AUTHENTICATION_TYPE);
        if (authnType == null) {
            return new AnonymousRequest();
        }
        if (authnType instanceof String && AuthenticationType.BASIC.name().equalsIgnoreCase((String)authnType)) {
            return new UsernamePasswordRequest((String)extensions.get(HandshakeExtension.AUTHENTICATION_IDENTITY), (String)extensions.get(HandshakeExtension.AUTHENTICATION_SECRET));
        }
        throw new UnsupportedAuthenticationTypeException("Unsupported authentication type: " + String.valueOf(authnType));
    }

    private void writeMagic(ChannelHandlerContext ctx) {
        ctx.write((Object)Unpooled.wrappedBuffer((byte[])ClientMessageCommon.MAGIC_BYTES));
        this.metrics.bytesSentAdd(ClientMessageCommon.MAGIC_BYTES.length);
    }

    private void write(ClientMessagePacker packer, ChannelHandlerContext ctx) {
        ByteBuf buf = packer.getBuffer();
        int bytes = buf.readableBytes();
        try {
            ctx.writeAndFlush((Object)buf);
        }
        catch (Throwable t) {
            buf.release();
            throw t;
        }
        this.metrics.bytesSentAdd(bytes);
    }

    private void writeResponseHeader(ClientMessagePacker packer, long requestId, ChannelHandlerContext ctx, boolean isNotification, boolean isError) {
        packer.packLong(requestId);
        this.writeFlags(packer, ctx, isNotification, isError);
        packer.packLong(this.observableTimestamp(null));
    }

    private void writeError(long requestId, int opCode, Throwable err, ChannelHandlerContext ctx, boolean isNotification) {
        if (isNotification) {
            LOG.warn("Error processing client notification [connectionId=" + this.connectionId + ", id=" + requestId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]:" + err.getMessage(), err);
        } else {
            LOG.warn("Error processing client request [connectionId=" + this.connectionId + ", id=" + requestId + ", op=" + opCode + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]:" + err.getMessage(), err);
        }
        ClientMessagePacker packer = ClientInboundMessageHandler.getPacker(ctx.alloc());
        try {
            assert (err != null);
            this.writeResponseHeader(packer, requestId, ctx, isNotification, true);
            this.writeErrorCore(err, packer);
            this.write(packer, ctx);
        }
        catch (Throwable t) {
            packer.close();
            this.exceptionCaught(ctx, t);
        }
    }

    private void writeErrorCore(Throwable err, ClientMessagePacker packer) {
        SqlBatchException sqlBatchException;
        SchemaVersionMismatchException schemaVersionMismatchException = ClientInboundMessageHandler.findException(err, SchemaVersionMismatchException.class);
        if ((err = (Throwable)IgniteUtils.firstNotNull((Object[])new Throwable[]{schemaVersionMismatchException, sqlBatchException = ClientInboundMessageHandler.findException(err, SqlBatchException.class), ExceptionUtils.unwrapCause((Throwable)err)})) instanceof TraceableException) {
            TraceableException iex = (TraceableException)err;
            packer.packUuid(iex.traceId());
            packer.packInt(iex.code());
        } else {
            packer.packUuid(UUID.randomUUID());
            packer.packInt(ErrorGroups.Common.INTERNAL_ERR);
        }
        assert (err != null);
        Throwable pubErr = IgniteExceptionMapperUtil.mapToPublicException((Throwable)err);
        packer.packString(pubErr.getClass().getName());
        packer.packString(pubErr.getMessage());
        if (this.configuration.sendServerExceptionStackTraceToClient()) {
            packer.packString(ExceptionUtils.getFullStackTrace((Throwable)pubErr));
        } else {
            packer.packString("To see the full stack trace set clientConnector.sendServerExceptionStackTraceToClient:true");
        }
        if (schemaVersionMismatchException != null) {
            packer.packInt(1);
            packer.packString("expected-schema-ver");
            packer.packInt(schemaVersionMismatchException.expectedVersion());
        } else if (sqlBatchException != null) {
            packer.packInt(1);
            packer.packString("sql-update-counters");
            packer.packLongArray(sqlBatchException.updateCounters());
        } else {
            packer.packNil();
        }
    }

    private static ClientMessagePacker getPacker(ByteBufAllocator alloc) {
        return new ClientMessagePacker(alloc.buffer());
    }

    private void processOperation(ChannelHandlerContext ctx, ClientMessageUnpacker in) {
        long requestId = -1L;
        int opCode = -1;
        ClientMessagePacker out = null;
        this.metrics.requestsActiveIncrement();
        try {
            opCode = in.unpackInt();
            requestId = in.unpackLong();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Client request started [id=" + requestId + ", op=" + opCode + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
            }
            if (ClientInboundMessageHandler.isPartitionOperation(opCode)) {
                long requestId0 = requestId;
                int opCode0 = opCode;
                this.partitionOperationsExecutor.execute(() -> {
                    ClientMessagePacker outPacker = ClientInboundMessageHandler.getPacker(ctx.alloc());
                    try {
                        this.processOperationInternal(ctx, in, outPacker, requestId0, opCode0);
                    }
                    catch (Throwable t) {
                        in.close();
                        outPacker.close();
                        this.writeError(requestId0, opCode0, t, ctx, false);
                        this.metrics.requestsFailedIncrement();
                    }
                });
            } else {
                out = ClientInboundMessageHandler.getPacker(ctx.alloc());
                this.processOperationInternal(ctx, in, out, requestId, opCode);
            }
        }
        catch (Throwable t) {
            in.close();
            if (out != null) {
                out.close();
            }
            this.writeError(requestId, opCode, t, ctx, false);
            this.metrics.requestsFailedIncrement();
        }
    }

    @Nullable
    private CompletableFuture processOperation(ClientMessageUnpacker in, ClientMessagePacker out, int opCode, long requestId) throws IgniteInternalCheckedException {
        switch (opCode) {
            case 1: {
                return null;
            }
            case 3: {
                return ClientTablesGetRequest.process(out, (IgniteTables)this.igniteTables).thenRun(() -> out.meta((Object)this.clockService.current()));
            }
            case 5: {
                return ClientSchemasGetRequest.process(in, out, (IgniteTables)this.igniteTables, this.schemaVersions);
            }
            case 4: {
                return ClientTableGetRequest.process(in, out, (IgniteTables)this.igniteTables);
            }
            case 10: {
                return ClientTupleUpsertRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 12: {
                return ClientTupleGetRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 13: {
                return ClientTupleUpsertAllRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 15: {
                return ClientTupleGetAllRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 16: {
                return ClientTupleGetAndUpsertRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 18: {
                return ClientTupleInsertRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 20: {
                return ClientTupleInsertAllRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 22: {
                return ClientTupleReplaceRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 24: {
                return ClientTupleReplaceExactRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 26: {
                return ClientTupleGetAndReplaceRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 28: {
                return ClientTupleDeleteRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 29: {
                return ClientTupleDeleteAllRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 30: {
                return ClientTupleDeleteExactRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 31: {
                return ClientTupleDeleteAllExactRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 32: {
                return ClientTupleGetAndDeleteRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 33: {
                return ClientTupleContainsKeyRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 67: {
                return ClientTupleContainsAllKeysRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources, this.txManager);
            }
            case 54: {
                return ClientJdbcConnectRequest.execute(in, out, this.jdbcQueryEventHandler);
            }
            case 34: {
                return ClientJdbcExecuteRequest.execute(in, out, this.jdbcQueryEventHandler);
            }
            case 68: {
                return ClientJdbcCancelRequest.execute(in, out, this.jdbcQueryEventHandler);
            }
            case 36: {
                return ClientJdbcExecuteBatchRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 46: {
                return ClientJdbcPreparedStmntBatchRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 35: {
                return ClientJdbcFetchRequest.process(in, out, this.jdbcQueryCursorHandler);
            }
            case 58: {
                return ClientJdbcHasMoreRequest.process(in, out, this.jdbcQueryCursorHandler);
            }
            case 37: {
                return ClientJdbcCloseRequest.process(in, out, this.jdbcQueryCursorHandler);
            }
            case 38: {
                return ClientJdbcTableMetadataRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 39: {
                return ClientJdbcColumnMetadataRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 40: {
                return ClientJdbcSchemasMetadataRequest.process(in, out, this.jdbcQueryEventHandler).thenRun(() -> out.meta((Object)this.clockService.current()));
            }
            case 41: {
                return ClientJdbcPrimaryKeyMetadataRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 43: {
                return ClientTransactionBeginRequest.process(in, out, this.txManager, this.resources, this.metrics);
            }
            case 44: {
                return ClientTransactionCommitRequest.process(in, out, this.resources, this.metrics, this.clockService);
            }
            case 45: {
                return ClientTransactionRollbackRequest.process(in, this.resources, this.metrics);
            }
            case 47: {
                return ClientComputeExecuteRequest.process(in, out, this.compute, this.clusterService, this.notificationSender(requestId));
            }
            case 49: {
                return ClientComputeExecuteColocatedRequest.process(in, out, this.compute, (IgniteTables)this.igniteTables, this.clusterService, this.notificationSender(requestId));
            }
            case 69: {
                return ClientComputeExecutePartitionedRequest.process(in, out, this.compute, (IgniteTables)this.igniteTables, this.clusterService, this.notificationSender(requestId));
            }
            case 64: {
                return ClientComputeExecuteMapReduceRequest.process(in, out, this.compute, this.notificationSender(requestId));
            }
            case 59: {
                return ClientComputeGetStateRequest.process(in, out, this.compute);
            }
            case 60: {
                return ClientComputeCancelRequest.process(in, out, this.compute);
            }
            case 61: {
                return ClientComputeChangePriorityRequest.process(in, out, this.compute);
            }
            case 48: {
                return ClientClusterGetNodesRequest.process(out, this.clusterService);
            }
            case 50: {
                return ClientSqlExecuteRequest.process(in, out, this.queryProcessor, this.resources, this.metrics);
            }
            case 51: {
                return ClientSqlCursorNextPageRequest.process(in, out, this.resources);
            }
            case 52: {
                return ClientSqlCursorCloseRequest.process(in, out, this.resources);
            }
            case 53: {
                return ClientTablePartitionPrimaryReplicasGetRequest.process(in, out, this.primaryReplicaTracker);
            }
            case 55: {
                return ClientJdbcFinishTxRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 56: {
                return ClientSqlExecuteScriptRequest.process(in, this.queryProcessor).thenRun(() -> {
                    if (out.meta() == null) {
                        out.meta((Object)this.clockService.current());
                    }
                });
            }
            case 57: {
                return ClientSqlQueryMetadataRequest.process(in, out, this.queryProcessor, this.resources);
            }
            case 63: {
                return ClientSqlExecuteBatchRequest.process(in, out, this.queryProcessor, this.resources);
            }
            case 62: {
                return ClientStreamerBatchSendRequest.process(in, out, (IgniteTables)this.igniteTables);
            }
            case 65: {
                return ClientTablePartitionPrimaryReplicasNodesGetRequest.process(in, out, (IgniteTables)this.igniteTables);
            }
            case 66: {
                return ClientStreamerWithReceiverBatchSendRequest.process(in, out, (IgniteTables)this.igniteTables);
            }
        }
        throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unexpected operation code: " + opCode);
    }

    private static boolean isPartitionOperation(int opCode) {
        return opCode == 3 || opCode == 10 || opCode == 12 || opCode == 16 || opCode == 18 || opCode == 22 || opCode == 24 || opCode == 26 || opCode == 28 || opCode == 30 || opCode == 32 || opCode == 33 || opCode == 62;
    }

    private void processOperationInternal(ChannelHandlerContext ctx, ClientMessageUnpacker in, ClientMessagePacker out, long requestId, int opCode) {
        CompletableFuture fut;
        out.packLong(requestId);
        this.writeFlags(out, ctx, false, false);
        int observableTimestampIdx = out.reserveLong();
        try {
            fut = this.processOperation(in, out, opCode, requestId);
        }
        catch (IgniteInternalCheckedException e) {
            fut = CompletableFuture.failedFuture(e);
        }
        if (fut == null) {
            in.close();
            out.setLong(observableTimestampIdx, this.observableTimestamp(out));
            this.write(out, ctx);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Client request processed synchronously [id=" + requestId + ", op=" + opCode + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
            }
            this.metrics.requestsProcessedIncrement();
            this.metrics.requestsActiveDecrement();
        } else {
            long reqId = requestId;
            int op = opCode;
            fut.whenComplete((res, err) -> {
                in.close();
                this.metrics.requestsActiveDecrement();
                if (err != null) {
                    out.close();
                    this.writeError(reqId, op, (Throwable)err, ctx, false);
                    this.metrics.requestsFailedIncrement();
                } else {
                    out.setLong(observableTimestampIdx, this.observableTimestamp(out));
                    this.write(out, ctx);
                    this.metrics.requestsProcessedIncrement();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Client request processed [id=" + reqId + ", op=" + op + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
                    }
                }
            });
        }
    }

    private void writeFlags(ClientMessagePacker out, ChannelHandlerContext ctx, boolean isNotification, boolean isError) {
        boolean primaryReplicasUpdated;
        long lastSentMaxStartTime = this.primaryReplicaMaxStartTime.get();
        long currentMaxStartTime = this.primaryReplicaTracker.maxStartTime();
        boolean bl = primaryReplicasUpdated = currentMaxStartTime > lastSentMaxStartTime && this.primaryReplicaMaxStartTime.compareAndSet(lastSentMaxStartTime, currentMaxStartTime);
        if (primaryReplicasUpdated && LOG.isInfoEnabled()) {
            LOG.info("Partition primary replica changed, notifying client [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
        }
        int flags = ResponseFlags.getFlags((boolean)primaryReplicasUpdated, (boolean)isNotification, (boolean)isError);
        out.packInt(flags);
        if (primaryReplicasUpdated) {
            out.packLong(currentMaxStartTime);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        IgniteException err;
        if (cause instanceof SSLException || cause.getCause() instanceof SSLException) {
            this.metrics.sessionsRejectedTlsIncrement();
        }
        if (cause instanceof DecoderException && cause.getCause() instanceof IgniteException && (err = (IgniteException)cause.getCause()).code() == ErrorGroups.Client.HANDSHAKE_HEADER_ERR) {
            this.metrics.sessionsRejectedIncrement();
        }
        LOG.warn("Exception in client connector pipeline [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]: " + cause.getMessage(), cause);
        ctx.close();
    }

    @Nullable
    private static <T> T findException(Throwable e, Class<T> cls) {
        while (e != null) {
            if (cls.isInstance(e)) {
                return (T)e;
            }
            e = e.getCause();
        }
        return null;
    }

    private long observableTimestamp(@Nullable ClientMessagePacker out) {
        if (out == null) {
            return this.clockService.currentLong();
        }
        if (out.meta() == null) {
            return HybridTimestamp.MIN_VALUE.longValue();
        }
        assert (out.meta() instanceof HybridTimestamp) : "Meta must contain a timestamp [metaCls=" + out.meta().getClass().getName() + "]";
        return ((HybridTimestamp)out.meta()).longValue();
    }

    private void sendNotification(long requestId, @Nullable Consumer<ClientMessagePacker> writer, @Nullable Throwable err) {
        if (err != null) {
            this.writeError(requestId, -1, err, this.channelHandlerContext, true);
            return;
        }
        ClientMessagePacker packer = ClientInboundMessageHandler.getPacker(this.channelHandlerContext.alloc());
        try {
            this.writeResponseHeader(packer, requestId, this.channelHandlerContext, true, false);
            if (writer != null) {
                writer.accept(packer);
            }
            this.write(packer, this.channelHandlerContext);
        }
        catch (Throwable t) {
            packer.close();
            this.exceptionCaught(this.channelHandlerContext, t);
        }
    }

    private NotificationSender notificationSender(long requestId) {
        return (writer, err) -> this.sendNotification(requestId, writer, err);
    }

    public CompletableFuture<Boolean> notify(AuthenticationEventParameters parameters) {
        ChannelHandlerContext channelCtx = this.channelHandlerContext;
        if (channelCtx == null) {
            return CompletableFutures.falseCompletedFuture();
        }
        channelCtx.executor().submit(() -> {
            if (this.shouldCloseConnection(parameters)) {
                LOG.warn("Closing connection due to authentication event [connectionId=" + this.connectionId + ", remoteAddress=" + String.valueOf(this.channelHandlerContext.channel().remoteAddress()) + ", event=" + String.valueOf(parameters.type()) + "]", new Object[0]);
                this.closeConnection();
            }
        });
        return CompletableFutures.falseCompletedFuture();
    }

    private boolean shouldCloseConnection(AuthenticationEventParameters parameters) {
        switch (parameters.type()) {
            case AUTHENTICATION_ENABLED: {
                return true;
            }
            case AUTHENTICATION_PROVIDER_REMOVED: 
            case AUTHENTICATION_PROVIDER_UPDATED: {
                return this.currentUserAffected((AuthenticationProviderEventParameters)parameters);
            }
            case USER_REMOVED: 
            case USER_UPDATED: {
                return this.currentUserAffected((UserEventParameters)parameters);
            }
        }
        return false;
    }

    private boolean currentUserAffected(AuthenticationProviderEventParameters parameters) {
        return this.clientContext != null && this.clientContext.userDetails().providerName().equals(parameters.name());
    }

    private boolean currentUserAffected(UserEventParameters parameters) {
        return this.clientContext != null && this.clientContext.userDetails().providerName().equals(parameters.providerName()) && this.clientContext.userDetails().username().equals(parameters.username());
    }

    private void closeConnection() {
        ChannelHandlerContext ctx = this.channelHandlerContext;
        if (ctx != null) {
            ctx.close();
        }
    }

    private static Set<AuthenticationEvent> authenticationEventsToSubscribe() {
        return Set.of(AuthenticationEvent.AUTHENTICATION_ENABLED, AuthenticationEvent.AUTHENTICATION_PROVIDER_UPDATED, AuthenticationEvent.AUTHENTICATION_PROVIDER_REMOVED, AuthenticationEvent.USER_UPDATED, AuthenticationEvent.USER_REMOVED);
    }

    @TestOnly
    public ClientResourceRegistry resources() {
        return this.resources;
    }
}

