/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.requests.table.ClientHandlerTuple;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleContainer;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.client.proto.ClientMessageCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaAware;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.InternalTxOptions;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypeSpec;
import org.apache.ignite.internal.type.TemporalNativeType;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class ClientTableCommon {
    static void writeSchema(ClientMessagePacker packer, int schemaVer, SchemaDescriptor schema) {
        packer.packInt(schemaVer);
        if (schema == null) {
            packer.packNil();
            return;
        }
        int colCnt = schema.columns().size();
        packer.packInt(colCnt);
        for (int colIdx = 0; colIdx < colCnt; ++colIdx) {
            Column col = schema.column(colIdx);
            packer.packInt(7);
            packer.packString(col.name());
            packer.packInt(ClientTableCommon.getColumnType(col.type().spec()).id());
            packer.packInt(col.positionInKey());
            packer.packBoolean(col.nullable());
            packer.packInt(col.positionInColocation());
            packer.packInt(ClientTableCommon.getDecimalScale(col.type()));
            packer.packInt(ClientTableCommon.getPrecision(col.type()));
        }
    }

    public static void writeTupleOrNil(ClientMessagePacker packer, Tuple tuple, TuplePart part, SchemaRegistry schemaRegistry) {
        if (tuple == null) {
            packer.packInt(schemaRegistry.lastKnownSchemaVersion());
            packer.packNil();
            return;
        }
        ClientTableCommon.writeTuple(packer, tuple, false, part);
    }

    private static void writeTuple(ClientMessagePacker packer, Tuple tuple, boolean skipHeader, TuplePart part) {
        int elementCount;
        assert (tuple != null);
        assert (tuple instanceof SchemaAware) : "Tuple must be a SchemaAware: " + String.valueOf(tuple.getClass());
        assert (part != TuplePart.VAL) : "TuplePart.VAL is not supported";
        SchemaDescriptor schema = ((SchemaAware)tuple).schema();
        assert (schema != null) : "Schema must not be null: " + String.valueOf(tuple.getClass());
        if (!skipHeader) {
            packer.packInt(schema.version());
        }
        assert (tuple instanceof BinaryTupleContainer) : "Tuple must be a BinaryTupleContainer: " + String.valueOf(tuple.getClass());
        BinaryTupleReader binaryTuple = ((BinaryTupleContainer)tuple).binaryTuple();
        int n = elementCount = part == TuplePart.KEY ? schema.keyColumns().size() : schema.length();
        if (binaryTuple != null) {
            assert (elementCount == binaryTuple.elementCount()) : "Tuple element count mismatch: " + elementCount + " != " + binaryTuple.elementCount() + " (" + String.valueOf(tuple.getClass()) + ")";
            packer.packBinaryTuple((BinaryTupleParser)binaryTuple);
        } else {
            BinaryTupleBuilder builder = new BinaryTupleBuilder(elementCount);
            for (int i = 0; i < elementCount; ++i) {
                Column col = schema.column(i);
                Object v = tuple.valueOrDefault(col.name(), ClientMessageCommon.NO_VALUE);
                ClientBinaryTupleUtils.appendValue((BinaryTupleBuilder)builder, (ColumnType)ClientTableCommon.getColumnType(col.type().spec()), (String)col.name(), (int)ClientTableCommon.getDecimalScale(col.type()), (Object)v);
            }
            packer.packBinaryTuple(builder);
        }
    }

    public static void writeTuples(ClientMessagePacker packer, Collection<Tuple> tuples, SchemaRegistry schemaRegistry) {
        ClientTableCommon.writeTuples(packer, tuples, TuplePart.KEY_AND_VAL, schemaRegistry);
    }

    public static void writeTuples(ClientMessagePacker packer, Collection<Tuple> tuples, TuplePart part, SchemaRegistry schemaRegistry) {
        if (tuples == null || tuples.isEmpty()) {
            packer.packInt(schemaRegistry.lastKnownSchemaVersion());
            packer.packInt(0);
            return;
        }
        Integer schemaVer = null;
        for (Tuple tuple : tuples) {
            assert (tuple != null);
            int tupleSchemaVer = ((SchemaAware)tuple).schema().version();
            if (schemaVer == null) {
                schemaVer = tupleSchemaVer;
                packer.packInt(tupleSchemaVer);
                packer.packInt(tuples.size());
            } else assert (schemaVer.equals(tupleSchemaVer)) : "All tuples must have the same schema version";
            ClientTableCommon.writeTuple(packer, tuple, true, part);
        }
    }

    public static void writeTuplesNullable(ClientMessagePacker packer, Collection<Tuple> tuples, TuplePart part, SchemaRegistry schemaRegistry) {
        if (tuples == null || tuples.isEmpty()) {
            packer.packInt(schemaRegistry.lastKnownSchemaVersion());
            packer.packInt(0);
            return;
        }
        Integer schemaVer = null;
        for (Tuple tuple : tuples) {
            if (tuple == null) continue;
            schemaVer = ((SchemaAware)tuple).schema().version();
            break;
        }
        packer.packInt(schemaVer == null ? schemaRegistry.lastKnownSchemaVersion() : schemaVer.intValue());
        packer.packInt(tuples.size());
        for (Tuple tuple : tuples) {
            if (tuple == null) {
                packer.packBoolean(false);
                continue;
            }
            assert (schemaVer.equals(((SchemaAware)tuple).schema().version())) : "All tuples must have the same schema version";
            packer.packBoolean(true);
            ClientTableCommon.writeTuple(packer, tuple, true, part);
        }
    }

    public static CompletableFuture<Tuple> readTuple(ClientMessageUnpacker unpacker, TableViewInternal table, boolean keyOnly) {
        return ClientTableCommon.readSchema(unpacker, table).thenApply(schema -> ClientTableCommon.readTuple(unpacker, keyOnly, schema));
    }

    public static Tuple readTuple(ClientMessageUnpacker unpacker, boolean keyOnly, SchemaDescriptor schema) {
        int cnt = keyOnly ? schema.keyColumns().size() : schema.length();
        BitSet noValueSet = unpacker.unpackBitSet();
        BinaryTupleReader binaryTupleReader = new BinaryTupleReader(cnt, unpacker.readBinary());
        return new ClientHandlerTuple(schema, noValueSet, binaryTupleReader, keyOnly);
    }

    public static CompletableFuture<List<Tuple>> readTuples(ClientMessageUnpacker unpacker, TableViewInternal table, boolean keyOnly) {
        return ClientTableCommon.readSchema(unpacker, table).thenApply(schema -> {
            int rowCnt = unpacker.unpackInt();
            ArrayList<Tuple> res = new ArrayList<Tuple>(rowCnt);
            for (int i = 0; i < rowCnt; ++i) {
                res.add(ClientTableCommon.readTuple(unpacker, keyOnly, schema));
            }
            return res;
        });
    }

    public static CompletableFuture<SchemaDescriptor> readSchema(ClientMessageUnpacker unpacker, TableViewInternal table) {
        int schemaId = unpacker.unpackInt();
        return table.schemaView().schemaAsync(schemaId);
    }

    public static CompletableFuture<TableViewInternal> readTableAsync(ClientMessageUnpacker unpacker, IgniteTables tables) {
        int tableId = unpacker.unpackInt();
        try {
            IgniteTablesInternal tablesInternal = (IgniteTablesInternal)tables;
            TableViewInternal cachedTable = tablesInternal.cachedTable(tableId);
            if (cachedTable != null) {
                return CompletableFuture.completedFuture(cachedTable);
            }
            return tablesInternal.tableAsync(tableId).thenApply(t -> {
                if (t == null) {
                    throw ClientTableCommon.tableIdNotFoundException(tableId);
                }
                return t;
            });
        }
        catch (NodeStoppingException e) {
            throw new IgniteException(e.traceId(), e.code(), e.getMessage(), (Throwable)e);
        }
    }

    public static TableNotFoundException tableIdNotFoundException(Integer tableId) {
        return new TableNotFoundException(UUID.randomUUID(), ErrorGroups.Client.TABLE_ID_NOT_FOUND_ERR, "Table does not exist: " + tableId, null);
    }

    @Nullable
    public static InternalTransaction readTx(ClientMessageUnpacker in, ClientMessagePacker out, ClientResourceRegistry resources) {
        if (in.tryUnpackNil()) {
            return null;
        }
        try {
            InternalTransaction tx = resources.get(in.unpackLong()).get(InternalTransaction.class);
            if (tx != null && tx.isReadOnly()) {
                out.meta((Object)tx.readTimestamp());
            }
            return tx;
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteException(e.traceId(), e.code(), e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    public static InternalTransaction readOrStartImplicitTx(ClientMessageUnpacker in, ClientMessagePacker out, ClientResourceRegistry resources, TxManager txManager, boolean readOnly) {
        InternalTransaction tx = ClientTableCommon.readTx(in, out, resources);
        if (tx == null) {
            tx = ClientTableCommon.startImplicitTx(out, txManager, null, readOnly);
        }
        return tx;
    }

    public static InternalTransaction startExplicitTx(ClientMessagePacker out, TxManager txManager, @Nullable HybridTimestamp currentTs, boolean readOnly, InternalTxOptions options) {
        return txManager.beginExplicit(HybridTimestampTracker.clientTracker((HybridTimestamp)currentTs, ts -> {}), readOnly, options);
    }

    public static InternalTransaction startImplicitTx(ClientMessagePacker out, TxManager txManager, @Nullable HybridTimestamp currentTs, boolean readOnly) {
        return txManager.beginImplicit(HybridTimestampTracker.clientTracker((HybridTimestamp)currentTs, arg_0 -> ((ClientMessagePacker)out).meta(arg_0)), readOnly);
    }

    public static ColumnType getColumnType(NativeTypeSpec spec) {
        ColumnType columnType = spec.asColumnTypeOrNull();
        if (columnType == null) {
            throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unsupported native type: " + String.valueOf(spec));
        }
        return columnType;
    }

    public static int getDecimalScale(NativeType type) {
        return type instanceof DecimalNativeType ? ((DecimalNativeType)type).scale() : 0;
    }

    public static int getPrecision(NativeType type) {
        if (type instanceof TemporalNativeType) {
            return ((TemporalNativeType)type).precision();
        }
        if (type instanceof DecimalNativeType) {
            return ((DecimalNativeType)type).precision();
        }
        return 0;
    }
}

