/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientPrimaryReplicaTracker;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.jetbrains.annotations.Nullable;

public class ClientTablePartitionPrimaryReplicasGetRequest {
    @Nullable
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, ClientPrimaryReplicaTracker tracker) throws NodeStoppingException {
        int tableId = in.unpackInt();
        long timestamp = in.unpackLong();
        return tracker.primaryReplicasAsync(tableId, timestamp).thenAccept(primaryReplicas -> {
            assert (primaryReplicas != null) : "Primary replicas == null";
            List<String> nodeNames = primaryReplicas.nodeNames();
            if (nodeNames == null) {
                out.packInt(primaryReplicas.partitions());
                out.packBoolean(false);
            } else {
                out.packInt(nodeNames.size());
                out.packBoolean(true);
                out.packLong(primaryReplicas.timestamp());
                for (String nodeName : nodeNames) {
                    out.packString(nodeName);
                }
            }
        });
    }
}

