/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.tx;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.InternalTxOptions;
import org.apache.ignite.internal.tx.TxManager;
import org.jetbrains.annotations.Nullable;

public class ClientTransactionBeginRequest {
    @Nullable
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, TxManager txManager, ClientResourceRegistry resources, ClientHandlerMetricSource metrics) throws IgniteInternalCheckedException {
        boolean readOnly = in.unpackBoolean();
        long timeoutMillis = in.unpackLong();
        HybridTimestamp observableTs = null;
        if (readOnly) {
            observableTs = HybridTimestamp.nullableHybridTimestamp((long)in.unpackLong());
        }
        InternalTxOptions txOptions = InternalTxOptions.builder().timeoutMillis(timeoutMillis).build();
        InternalTransaction tx = ClientTableCommon.startExplicitTx(out, txManager, observableTs, readOnly, txOptions);
        if (readOnly) {
            out.meta((Object)tx.readTimestamp());
        }
        try {
            long resourceId = resources.put(new ClientResource(tx, () -> ((InternalTransaction)tx).rollbackAsync()));
            out.packLong(resourceId);
            metrics.transactionsActiveIncrement();
            return null;
        }
        catch (IgniteInternalCheckedException e) {
            tx.rollback();
            throw e;
        }
    }
}

