package org.apache.baremaps.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Begin and end times of the temporal extent.
 **/
@ApiModel(description = "Begin and end times of the temporal extent.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-14T17:37:24.176539752Z[Etc/UTC]")public class ExtentTemporal   {
  
  private @Valid List<List<Date>> interval = new ArrayList<List<Date>>();

public enum TrsEnum {

    HTTP_WWW_OPENGIS_NET_DEF_UOM_ISO_8601_0_GREGORIAN(String.valueOf("http://www.opengis.net/def/uom/ISO-8601/0/Gregorian"));


    private String value;

    TrsEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static TrsEnum fromValue(String value) {
        for (TrsEnum b : TrsEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid TrsEnum trs = TrsEnum.HTTP_WWW_OPENGIS_NET_DEF_UOM_ISO_8601_0_GREGORIAN;

  /**
   **/
  public ExtentTemporal interval(List<List<Date>> interval) {
    this.interval = interval;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("interval")
 @Size(min=1)  public List<List<Date>> getInterval() {
    return interval;
  }

  public void setInterval(List<List<Date>> interval) {
    this.interval = interval;
  }/**
   * Temporal reference system of the coordinates in the temporal extent (property &#x60;temporal&#x60;). Only the Gregorian calendar is supported by API-Collections. Extensions may support additional temporal reference systems.
   **/
  public ExtentTemporal trs(TrsEnum trs) {
    this.trs = trs;
    return this;
  }

  

  
  @ApiModelProperty(value = "Temporal reference system of the coordinates in the temporal extent (property `temporal`). Only the Gregorian calendar is supported by API-Collections. Extensions may support additional temporal reference systems.")
  @JsonProperty("trs")
  public TrsEnum getTrs() {
    return trs;
  }

  public void setTrs(TrsEnum trs) {
    this.trs = trs;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtentTemporal extentTemporal = (ExtentTemporal) o;
    return Objects.equals(this.interval, extentTemporal.interval) &&
        Objects.equals(this.trs, extentTemporal.trs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(interval, trs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExtentTemporal {\n");
    
    sb.append("    interval: ").append(toIndentedString(interval)).append("\n");
    sb.append("    trs: ").append(toIndentedString(trs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

