/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.Optional;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.Snapshot;
import org.apache.bifromq.basekv.raft.proto.Voting;

class MetricMonitoredStateStore
implements IRaftStateStore {
    private final IRaftStateStore delegate;
    private final MetricManager metricManager;

    public MetricMonitoredStateStore(IRaftStateStore delegate, Tags tags) {
        this.delegate = delegate;
        this.metricManager = new MetricManager(tags);
    }

    @Override
    public String local() {
        return this.delegate.local();
    }

    @Override
    public long currentTerm() {
        return this.metricManager.currentTermTimer.record(this.delegate::currentTerm);
    }

    @Override
    public void saveTerm(long term) {
        this.metricManager.saveTermTimer.record(() -> this.delegate.saveTerm(term));
    }

    @Override
    public Optional<Voting> currentVoting() {
        return (Optional)this.metricManager.currentVotingTimer.record(this.delegate::currentVoting);
    }

    @Override
    public void saveVoting(Voting voting) {
        this.metricManager.saveVotingTimer.record(() -> this.delegate.saveVoting(voting));
    }

    @Override
    public ClusterConfig latestClusterConfig() {
        return (ClusterConfig)this.metricManager.latestClusterConfigTimer.record(this.delegate::latestClusterConfig);
    }

    @Override
    public void applySnapshot(Snapshot snapshot) {
        this.metricManager.applySnapshotTimer.record(() -> this.delegate.applySnapshot(snapshot));
    }

    @Override
    public Snapshot latestSnapshot() {
        return (Snapshot)this.metricManager.latestSnapshotTimer.record(this.delegate::latestSnapshot);
    }

    @Override
    public long firstIndex() {
        return this.metricManager.firstIndexTimer.record(this.delegate::firstIndex);
    }

    @Override
    public long lastIndex() {
        return this.metricManager.lastIndexTimer.record(this.delegate::lastIndex);
    }

    @Override
    public Optional<LogEntry> entryAt(long index) {
        return (Optional)this.metricManager.entryAtTimer.record(() -> this.delegate.entryAt(index));
    }

    @Override
    public ILogEntryIterator entries(long lo, long hi, long maxSize) {
        return (ILogEntryIterator)this.metricManager.entriesTimer.record(() -> this.delegate.entries(lo, hi, maxSize));
    }

    @Override
    public void append(List<LogEntry> entries, boolean flush) {
        this.metricManager.appendTimer.record(() -> this.delegate.append(entries, flush));
    }

    @Override
    public void addStableListener(IRaftStateStore.StableListener listener) {
        this.delegate.addStableListener(listener);
    }

    @Override
    public void stop() {
        this.delegate.stop();
        this.metricManager.close();
    }

    private static class MetricManager {
        final Timer currentTermTimer;
        final Timer saveTermTimer;
        final Timer currentVotingTimer;
        final Timer saveVotingTimer;
        final Timer latestClusterConfigTimer;
        final Timer applySnapshotTimer;
        final Timer latestSnapshotTimer;
        final Timer firstIndexTimer;
        final Timer lastIndexTimer;
        final Timer entryAtTimer;
        final Timer entriesTimer;
        final Timer appendTimer;

        MetricManager(Tags tags) {
            this.currentTermTimer = Metrics.timer((String)"raft.store.currentterm", (Iterable)tags);
            this.saveTermTimer = Metrics.timer((String)"raft.store.saveterm", (Iterable)tags);
            this.currentVotingTimer = Metrics.timer((String)"raft.store.currentvoting", (Iterable)tags);
            this.saveVotingTimer = Metrics.timer((String)"raft.store.savevoting", (Iterable)tags);
            this.latestClusterConfigTimer = Metrics.timer((String)"raft.store.latestclusterconfig", (Iterable)tags);
            this.applySnapshotTimer = Metrics.timer((String)"raft.store.applysnapshot", (Iterable)tags);
            this.latestSnapshotTimer = Metrics.timer((String)"raft.store.snapshot", (Iterable)tags);
            this.firstIndexTimer = Metrics.timer((String)"raft.store.firstindex", (Iterable)tags);
            this.lastIndexTimer = Metrics.timer((String)"raft.store.lastindex", (Iterable)tags);
            this.entryAtTimer = Metrics.timer((String)"raft.store.entryat", (Iterable)tags);
            this.entriesTimer = Metrics.timer((String)"raft.store.entries", (Iterable)tags);
            this.appendTimer = Metrics.timer((String)"raft.store.append", (Iterable)tags);
        }

        void close() {
            Metrics.globalRegistry.removeByPreFilterId(this.currentTermTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.saveTermTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.currentVotingTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.saveVotingTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.latestClusterConfigTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.applySnapshotTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.latestSnapshotTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.firstIndexTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.lastIndexTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.entryAtTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.entriesTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.appendTimer.getId());
        }
    }
}

