/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.wal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Struct;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.basekv.localengine.IKVEngine;
import org.apache.bifromq.basekv.localengine.IKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.IWALableKVSpace;
import org.apache.bifromq.basekv.localengine.KVEngineFactory;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.raft.proto.Snapshot;
import org.apache.bifromq.basekv.store.exception.KVRangeStoreException;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALStore;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALStoreEngine;
import org.apache.bifromq.basekv.store.wal.KVRangeWALKeys;
import org.apache.bifromq.basekv.store.wal.KVRangeWALStore;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

public class KVRangeWALStorageEngine
implements IKVRangeWALStoreEngine {
    private final Logger log;
    private final String clusterId;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final Map<KVRangeId, KVRangeWALStore> instances = Maps.newConcurrentMap();
    private final IKVEngine<? extends IWALableKVSpace> kvEngine;

    public KVRangeWALStorageEngine(String clusterId, String overrideIdentity, String engineType, Struct conf) {
        this.clusterId = clusterId;
        this.kvEngine = KVEngineFactory.createWALable((String)overrideIdentity, (String)engineType, (Struct)conf);
        this.log = MDCLogger.getLogger(KVRangeWALStorageEngine.class, (String[])new String[]{"clusterId", clusterId, "storeId", this.kvEngine.id()});
    }

    @Override
    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            try {
                this.log.debug("Stopping WALStoreEngine");
                this.instances.values().forEach(KVRangeWALStore::stop);
                this.kvEngine.stop();
                this.state.set(State.STOPPED);
            }
            catch (Throwable e) {
                this.log.warn("Failed to stop WALStoreEngine", e);
            }
            finally {
                this.state.set(State.TERMINATED);
            }
        }
    }

    @Override
    public void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            try {
                this.kvEngine.start(new String[]{"clusterId", this.clusterId, "storeId", this.id(), "type", "wal"});
                this.loadExisting();
                this.state.set(State.STARTED);
            }
            catch (Throwable e) {
                this.state.set(State.TERMINATED);
                throw new KVRangeStoreException("Failed to start WALStoreEngine", e);
            }
        }
    }

    @Override
    public Set<KVRangeId> allKVRangeIds() {
        this.checkState();
        return Sets.newHashSet(this.instances.keySet());
    }

    @Override
    public String id() {
        return this.kvEngine.id();
    }

    @Override
    public IKVRangeWALStore create(KVRangeId kvRangeId, Snapshot initSnapshot) {
        this.checkState();
        this.instances.computeIfAbsent(kvRangeId, id -> {
            IWALableKVSpace kvSpace = (IWALableKVSpace)this.kvEngine.createIfMissing(KVRangeIdUtil.toString((KVRangeId)id));
            ((IKVSpaceWriter)kvSpace.toWriter().put(KVRangeWALKeys.KEY_LATEST_SNAPSHOT_BYTES, initSnapshot.toByteString())).done();
            kvSpace.flush().join();
            return new KVRangeWALStore(this.clusterId, this.kvEngine.id(), kvRangeId, kvSpace, store -> this.instances.remove(kvRangeId, store));
        });
        return this.instances.get(kvRangeId);
    }

    @Override
    public boolean has(KVRangeId kvRangeId) {
        this.checkState();
        return this.instances.containsKey(kvRangeId);
    }

    @Override
    public IKVRangeWALStore get(KVRangeId kvRangeId) {
        this.checkState();
        return this.instances.get(kvRangeId);
    }

    private void checkState() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0, (Object)"Not started");
    }

    private void loadExisting() {
        this.kvEngine.spaces().forEach((id, kvSpace) -> {
            KVRangeId kvRangeId = KVRangeIdUtil.fromString((String)id);
            this.instances.put(kvRangeId, new KVRangeWALStore(this.clusterId, this.kvEngine.id(), kvRangeId, (IWALableKVSpace)kvSpace, store -> this.instances.remove(kvRangeId, store)));
            this.log.debug("WALStore loaded: kvRangeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)kvRangeId));
        });
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        TERMINATED;

    }
}

