/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import io.netty.channel.Channel;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;

public final class SendBufferCapacityHinter {
    private static final IntConsumer DUMMY = i -> {};
    private final Channel channel;
    private final IntSupplier unconfirmedSizer;
    private final float triggerRatio;
    private IntConsumer hintConsumer = DUMMY;
    private int lastHint = -1;
    private int lastHintRemaining = -1;
    private int lastMsgSize;

    public SendBufferCapacityHinter(Channel channel, IntSupplier unconfirmedSizer, float triggerRatio) {
        assert (triggerRatio > 0.0f);
        this.channel = channel;
        this.unconfirmedSizer = unconfirmedSizer;
        this.triggerRatio = Math.max(triggerRatio, 0.8f);
    }

    public void reset() {
        this.lastHint = -1;
        this.lastHintRemaining = -1;
        this.lastMsgSize = 0;
        this.sendHint(100);
    }

    public void hint(IntConsumer hintConsumer) {
        this.hintConsumer = hintConsumer;
        this.sendHint(100);
    }

    public boolean hasCapacity() {
        return this.lastHint == -1 || this.lastHintRemaining > 0;
    }

    public void onWritabilityChanged() {
        if (this.channel.isWritable() && this.lastMsgSize > 0) {
            this.sendHint(Math.max(1, this.estimateCapacity(this.lastMsgSize)));
        }
    }

    public void onOneMessageBuffered(int msgSize) {
        if (this.lastHint == -1) {
            this.sendHint(Math.max(1, this.estimateCapacity(msgSize)));
        } else if (!this.channel.isWritable()) {
            if (this.lastHint > 0) {
                this.sendHint(0);
            }
        } else {
            this.lastHintRemaining = Math.max(0, this.lastHintRemaining - 1);
            if (this.remainingRatio() <= this.triggerRatio) {
                this.sendHint(Math.max(1, this.estimateCapacity(msgSize)));
            }
        }
        this.lastMsgSize = msgSize;
    }

    public void onConfirm() {
        int estCap;
        if (this.remainingRatio() <= this.triggerRatio && this.lastMsgSize > 0 && (estCap = this.estimateCapacity(this.lastMsgSize)) > 0) {
            this.sendHint(estCap);
        }
    }

    private void sendHint(int estCap) {
        this.lastHint = estCap;
        this.lastHintRemaining = estCap;
        this.hintConsumer.accept(estCap);
    }

    private float remainingRatio() {
        return (float)this.lastHintRemaining / (float)this.lastHint;
    }

    private int estimateCapacity(int estMsgSize) {
        int estBufferSize = (int)this.channel.bytesBeforeUnwritable() / estMsgSize;
        return Math.max(estBufferSize - this.unconfirmedSizer.getAsInt(), 0);
    }
}

