/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.util.CharSequenceMap;
import org.apache.iceberg.util.CharSequenceSet;
import org.roaringbitmap.longlong.PeekableLongIterator;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public class SortingPositionOnlyDeleteWriter<T>
implements FileWriter<PositionDelete<T>, DeleteWriteResult> {
    private final Supplier<FileWriter<PositionDelete<T>, DeleteWriteResult>> writers;
    private final DeleteGranularity granularity;
    private final CharSequenceMap<Roaring64Bitmap> positionsByPath;
    private DeleteWriteResult result = null;

    public SortingPositionOnlyDeleteWriter(FileWriter<PositionDelete<T>, DeleteWriteResult> writer) {
        this(() -> writer, DeleteGranularity.PARTITION);
    }

    public SortingPositionOnlyDeleteWriter(Supplier<FileWriter<PositionDelete<T>, DeleteWriteResult>> writers, DeleteGranularity granularity) {
        this.writers = writers;
        this.granularity = granularity;
        this.positionsByPath = CharSequenceMap.create();
    }

    @Override
    public void write(PositionDelete<T> positionDelete) {
        CharSequence path = positionDelete.path();
        long position = positionDelete.pos();
        Roaring64Bitmap positions = (Roaring64Bitmap)this.positionsByPath.computeIfAbsent(path, Roaring64Bitmap::new);
        positions.add(new long[]{position});
    }

    @Override
    public long length() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement length");
    }

    @Override
    public DeleteWriteResult result() {
        return this.result;
    }

    @Override
    public void close() throws IOException {
        if (this.result == null) {
            switch (this.granularity) {
                case FILE: {
                    this.result = this.writeFileDeletes();
                    return;
                }
                case PARTITION: {
                    this.result = this.writePartitionDeletes();
                    return;
                }
            }
            throw new UnsupportedOperationException("Unsupported delete granularity: " + (Object)((Object)this.granularity));
        }
    }

    private DeleteWriteResult writePartitionDeletes() throws IOException {
        return this.writeDeletes(this.positionsByPath.keySet());
    }

    private DeleteWriteResult writeFileDeletes() throws IOException {
        ArrayList deleteFiles = Lists.newArrayList();
        CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
        for (CharSequence path : this.positionsByPath.keySet()) {
            DeleteWriteResult writeResult = this.writeDeletes((Collection<CharSequence>)ImmutableList.of((Object)path));
            deleteFiles.addAll(writeResult.deleteFiles());
            referencedDataFiles.addAll((Collection)writeResult.referencedDataFiles());
        }
        return new DeleteWriteResult(deleteFiles, referencedDataFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeleteWriteResult writeDeletes(Collection<CharSequence> paths) throws IOException {
        try (FileWriter<PositionDelete<PositionDelete<Object>>, DeleteWriteResult> writer = this.writers.get();){
            PositionDelete positionDelete = PositionDelete.create();
            for (CharSequence path : this.sort(paths)) {
                PeekableLongIterator positions = ((Roaring64Bitmap)this.positionsByPath.get((Object)path)).getLongIterator();
                while (positions.hasNext()) {
                    long position = positions.next();
                    writer.write(positionDelete.set(path, position, null));
                }
            }
        }
        return writer.result();
    }

    private Collection<CharSequence> sort(Collection<CharSequence> paths) {
        if (paths.size() <= 1) {
            return paths;
        }
        ArrayList sortedPaths = Lists.newArrayList(paths);
        sortedPaths.sort(Comparators.charSequences());
        return sortedPaths;
    }
}

