/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.util.Map;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.FutureGrantManager;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerManager;
import org.apache.gravitino.catalog.CatalogDispatcher;
import org.apache.gravitino.connector.BaseCatalog;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.CatalogInUseException;
import org.apache.gravitino.exceptions.CatalogNotInUseException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class CatalogHookDispatcher
implements CatalogDispatcher {
    private final CatalogDispatcher dispatcher;

    public CatalogHookDispatcher(CatalogDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public NameIdentifier[] listCatalogs(Namespace namespace) throws NoSuchMetalakeException {
        return this.dispatcher.listCatalogs(namespace);
    }

    @Override
    public Catalog[] listCatalogsInfo(Namespace namespace) throws NoSuchMetalakeException {
        return this.dispatcher.listCatalogsInfo(namespace);
    }

    @Override
    public Catalog loadCatalog(NameIdentifier ident) throws NoSuchCatalogException {
        return this.dispatcher.loadCatalog(ident);
    }

    @Override
    public Catalog createCatalog(NameIdentifier ident, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws NoSuchMetalakeException, CatalogAlreadyExistsException {
        FutureGrantManager futureGrantManager;
        AuthorizationUtils.checkCurrentUser(ident.namespace().level(0), PrincipalUtils.getCurrentUserName());
        Catalog catalog = this.dispatcher.createCatalog(ident, type, provider, comment, properties);
        OwnerManager ownerManager = GravitinoEnv.getInstance().ownerManager();
        if (ownerManager != null) {
            ownerManager.setOwner(ident.namespace().level(0), NameIdentifierUtil.toMetadataObject(ident, Entity.EntityType.CATALOG), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        if ((futureGrantManager = GravitinoEnv.getInstance().futureGrantManager()) != null && catalog instanceof BaseCatalog) {
            futureGrantManager.grantNewlyCreatedCatalog(ident.namespace().level(0), (BaseCatalog)catalog);
        }
        return catalog;
    }

    @Override
    public Catalog alterCatalog(NameIdentifier ident, CatalogChange ... changes) throws NoSuchCatalogException, IllegalArgumentException {
        Catalog alteredCatalog = this.dispatcher.alterCatalog(ident, changes);
        CatalogChange.RenameCatalog lastRenameChange = null;
        for (CatalogChange change : changes) {
            if (!(change instanceof CatalogChange.RenameCatalog)) continue;
            lastRenameChange = (CatalogChange.RenameCatalog)change;
        }
        if (lastRenameChange != null) {
            AuthorizationUtils.authorizationPluginRenamePrivileges(ident, Entity.EntityType.CATALOG, lastRenameChange.getNewName());
        }
        return alteredCatalog;
    }

    @Override
    public boolean dropCatalog(NameIdentifier ident) {
        return this.dropCatalog(ident, false);
    }

    @Override
    public boolean dropCatalog(NameIdentifier ident, boolean force) throws NonEmptyEntityException, CatalogInUseException {
        AuthorizationUtils.authorizationPluginRemovePrivileges(ident, Entity.EntityType.CATALOG);
        return this.dispatcher.dropCatalog(ident, force);
    }

    @Override
    public void testConnection(NameIdentifier ident, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws Exception {
        this.dispatcher.testConnection(ident, type, provider, comment, properties);
    }

    @Override
    public void enableCatalog(NameIdentifier ident) throws NoSuchCatalogException, CatalogNotInUseException {
        this.dispatcher.enableCatalog(ident);
    }

    @Override
    public void disableCatalog(NameIdentifier ident) throws NoSuchCatalogException {
        this.dispatcher.disableCatalog(ident);
    }

    @Override
    public boolean catalogExists(NameIdentifier ident) {
        return this.dispatcher.catalogExists(ident);
    }
}

