/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.io.Closeable;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;

interface KeyManagementClient
extends Serializable,
Closeable {
    public ByteBuffer wrapKey(ByteBuffer var1, String var2);

    default public boolean supportsKeyGeneration() {
        return false;
    }

    default public KeyGenerationResult generateKey(String wrappingKeyId) {
        throw new UnsupportedOperationException("Key generation is not supported in this KmsClient");
    }

    public ByteBuffer unwrapKey(ByteBuffer var1, String var2);

    public void initialize(Map<String, String> var1);

    @Override
    default public void close() {
    }

    public static class KeyGenerationResult {
        private final ByteBuffer key;
        private final ByteBuffer wrappedKey;

        KeyGenerationResult(ByteBuffer key, ByteBuffer wrappedKey) {
            this.key = key;
            this.wrappedKey = wrappedKey;
        }

        public ByteBuffer key() {
            return this.key;
        }

        public ByteBuffer wrappedKey() {
            return this.wrappedKey;
        }
    }
}

