/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class FileSnapshot {
    public static final long UNKNOWN_SIZE = -1L;
    public static final FileSnapshot NO_FILE = new FileSnapshot(Instant.now(), null, -1L, null);
    private static final Duration WORST_CASE_TIMESTAMP_RESOLUTION = Duration.ofMillis(2000L);
    private final FileTime lastModified;
    private final long size;
    private final Object fileKey;
    private final Instant snapTime;

    protected FileSnapshot(Instant snapTime, FileTime lastModified, long size, Object fileKey) {
        this.snapTime = Objects.requireNonNull(snapTime);
        this.lastModified = lastModified;
        this.size = size;
        this.fileKey = fileKey;
    }

    protected FileTime getLastModified() {
        return this.lastModified;
    }

    protected long getSize() {
        return this.size;
    }

    protected Object getFileKey() {
        return this.fileKey;
    }

    protected Instant getTime() {
        return this.snapTime;
    }

    public static FileSnapshot save(Path file, LinkOption ... options) throws IOException {
        BasicFileAttributes attributes = null;
        Instant now = Instant.now();
        try {
            attributes = Files.readAttributes(file, BasicFileAttributes.class, options);
        }
        catch (NoSuchFileException e) {
            return NO_FILE;
        }
        if (attributes == null) {
            return NO_FILE;
        }
        return new FileSnapshot(now, attributes.lastModifiedTime(), attributes.size(), attributes.fileKey());
    }

    public FileSnapshot reload(Path file, LinkOption ... options) throws IOException {
        FileSnapshot newSnapshot = FileSnapshot.save(file, options);
        if (newSnapshot.mayBeRacilyClean()) {
            return newSnapshot;
        }
        return this.same(newSnapshot) && !this.mayBeRacilyClean() ? this : newSnapshot;
    }

    protected boolean mayBeRacilyClean() {
        FileTime fTime = this.getLastModified();
        return fTime != null && Duration.between(fTime.toInstant(), this.getTime()).compareTo(WORST_CASE_TIMESTAMP_RESOLUTION) <= 0;
    }

    public boolean same(FileSnapshot other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return Objects.equals(this.getFileKey(), other.getFileKey()) && Objects.equals(this.getLastModified(), other.getLastModified()) && this.getSize() == other.getSize();
    }
}

