/*
 * Decompiled with CFR 0.152.
 */
package rl;

import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import rl.AbsoluteUri;
import rl.Authority;
import rl.Authority$;
import rl.FailedUri;
import rl.PathOps$class;
import rl.QueryString$;
import rl.RelativeUri;
import rl.Scheme;
import rl.Uri;
import rl.UriFragment$;
import rl.UriPath;
import rl.UriPath$;
import rl.UrlCodingUtils$;
import rl.UrlCodingUtils$class;
import rl.package;
import rl.package$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class Uri$ {
    public static final Uri$ MODULE$;
    private final Regex UriParts;
    private volatile boolean bitmap$init$0;

    static {
        new Uri$();
    }

    public Regex UriParts() {
        if (this.bitmap$init$0) {
            return this.UriParts;
        }
        throw new UninitializedFieldError("Uninitialized field: Uri.scala: 107");
    }

    public Uri apply(String uriString) {
        Uri uri;
        try {
            uri = this.apply(URI.create(uriString), this.apply$default$2());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            uri = new FailedUri(illegalArgumentException, uriString);
        }
        catch (URISyntaxException uRISyntaxException) {
            uri = new FailedUri(uRISyntaxException, uriString);
        }
        return uri;
    }

    public Uri apply(URI u, Option<String> originalUri) {
        Product product;
        try {
            None$ none$;
            String string = u.getRawPath();
            package$ package$2 = package$.MODULE$;
            Option<String> option = new package.UriStringExtensions(string).blankOption();
            if (!option.isEmpty()) {
                Object object = option.get();
                String string2 = (String)object;
                UrlCodingUtils$ urlCodingUtils$ = UrlCodingUtils$.MODULE$;
                Some some = new Some((Object)UrlCodingUtils$class.ensureUrlEncoding(urlCodingUtils$, string2));
                none$ = some;
            } else {
                none$ = None$.MODULE$;
            }
            None$ none$2 = none$;
            UriPath$ uriPath$ = UriPath$.MODULE$;
            UriPath pth = PathOps$class.parsePath(uriPath$, (Option)none$2);
            if (u.isAbsolute()) {
                None$ none$3;
                Scheme scheme = new Scheme(u.getScheme());
                String string3 = u.getRawAuthority();
                package$ package$3 = package$.MODULE$;
                Option<String> option2 = new package.UriStringExtensions(string3).blankOption();
                if (!option2.isEmpty()) {
                    Object object = option2.get();
                    String string4 = (String)object;
                    Some some = new Some((Object)Authority$.MODULE$.apply(IDN.toASCII(string4)));
                    none$3 = some;
                } else {
                    none$3 = None$.MODULE$;
                }
                product = new AbsoluteUri(scheme, (Option<Authority>)none$3, pth, QueryString$.MODULE$.apply(u.getRawQuery()), UriFragment$.MODULE$.apply(u.getRawFragment()), (String)(!originalUri.isEmpty() ? originalUri.get() : u.toString()));
            } else {
                None$ none$4;
                String string5 = u.getRawAuthority();
                package$ package$4 = package$.MODULE$;
                Option<String> option3 = new package.UriStringExtensions(string5).blankOption();
                if (!option3.isEmpty()) {
                    Object object = option3.get();
                    String string6 = (String)object;
                    Some some = new Some((Object)Authority$.MODULE$.apply(IDN.toASCII(string6)));
                    none$4 = some;
                } else {
                    none$4 = None$.MODULE$;
                }
                product = new RelativeUri((Option<Authority>)none$4, pth, QueryString$.MODULE$.apply(u.getRawQuery()), UriFragment$.MODULE$.apply(u.getRawFragment()), (String)(!originalUri.isEmpty() ? originalUri.get() : u.toString()));
            }
        }
        catch (Throwable throwable) {
            product = new FailedUri(throwable, (String)(!originalUri.isEmpty() ? originalUri.get() : u.toString()));
        }
        catch (NullPointerException nullPointerException) {
            product = new FailedUri(nullPointerException, (String)(!originalUri.isEmpty() ? originalUri.get() : u.toString()));
        }
        return product;
    }

    public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    private Uri$() {
        MODULE$ = this;
        Predef$ predef$ = Predef$.MODULE$;
        this.UriParts = new StringOps("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?").r();
        this.bitmap$init$0 = true;
    }
}

