/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.util;

import java.util.Locale;
import java.util.regex.Pattern;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;
import joptsimple.internal.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexMatcher
implements ValueConverter<String> {
    private final Pattern pattern;

    public RegexMatcher(String pattern2, int flags) {
        this.pattern = Pattern.compile(pattern2, flags);
    }

    public static ValueConverter<String> regex(String pattern2) {
        return new RegexMatcher(pattern2, 0);
    }

    @Override
    public String convert(String value2) {
        if (!this.pattern.matcher(value2).matches()) {
            this.raiseValueConversionFailure(value2);
        }
        return value2;
    }

    @Override
    public Class<String> valueType() {
        return String.class;
    }

    @Override
    public String valuePattern() {
        return this.pattern.pattern();
    }

    private void raiseValueConversionFailure(String value2) {
        String message = Messages.message(Locale.getDefault(), "joptsimple.ExceptionMessages", RegexMatcher.class, "message", value2, this.pattern.pattern());
        throw new ValueConversionException(message);
    }
}

