/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ReadWriteForEncodingUtils {
    private static final String TOO_LONG_BYTE_FORMAT = "tsfile-common BytesUtils: encountered value (%d) that requires more than 4 bytes";

    private ReadWriteForEncodingUtils() {
    }

    public static int getIntMaxBitWidth(List<Integer> list) {
        int max = 1;
        for (int num : list) {
            int bitWidth = 32 - Integer.numberOfLeadingZeros(num);
            max = Math.max(bitWidth, max);
        }
        return max;
    }

    public static int getLongMaxBitWidth(List<Long> list) {
        int max = 1;
        for (long num : list) {
            int bitWidth = 64 - Long.numberOfLeadingZeros(num);
            max = Math.max(bitWidth, max);
        }
        return max;
    }

    public static byte[] getUnsignedVarInt(int value) {
        int preValue = value;
        int length = 0;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            ++length;
            value >>>= 7;
        }
        byte[] res = new byte[++length];
        value = preValue;
        int i = 0;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            res[i] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
            ++i;
        }
        res[i] = (byte)(value & 0x7F);
        return res;
    }

    public static int readUnsignedVarInt(InputStream in) throws IOException {
        int value = 0;
        int i = 0;
        int b = in.read();
        while (b != -1 && (b & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            i += 7;
            b = in.read();
        }
        return value | b << i;
    }

    public static int readVarInt(InputStream in) throws IOException {
        int value = ReadWriteForEncodingUtils.readUnsignedVarInt(in);
        int x = value >>> 1;
        if ((value & 1) != 0) {
            x ^= 0xFFFFFFFF;
        }
        return x;
    }

    public static int readUnsignedVarInt(ByteBuffer buffer) {
        int value = 0;
        int i = 0;
        byte b = 0;
        while (buffer.hasRemaining() && ((b = buffer.get()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            i += 7;
        }
        return value | b << i;
    }

    public static int readVarInt(ByteBuffer buffer) {
        int value = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        int x = value >>> 1;
        if ((value & 1) != 0) {
            x ^= 0xFFFFFFFF;
        }
        return x;
    }

    public static int writeUnsignedVarInt(int value, ByteArrayOutputStream out) {
        int position = 1;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
            ++position;
        }
        out.write(value & 0x7F);
        return position;
    }

    public static int writeVarInt(int value, ByteArrayOutputStream out) {
        int uValue = value << 1;
        if (value < 0) {
            uValue ^= 0xFFFFFFFF;
        }
        return ReadWriteForEncodingUtils.writeUnsignedVarInt(uValue, out);
    }

    public static int writeUnsignedVarInt(int value, OutputStream out) throws IOException {
        int position = 1;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
            ++position;
        }
        out.write(value & 0x7F);
        return position;
    }

    public static int writeVarInt(int value, OutputStream out) throws IOException {
        int uValue = value << 1;
        if (value < 0) {
            uValue ^= 0xFFFFFFFF;
        }
        return ReadWriteForEncodingUtils.writeUnsignedVarInt(uValue, out);
    }

    public static int writeUnsignedVarInt(int value, ByteBuffer buffer) {
        int position = 1;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            buffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
            ++position;
        }
        buffer.put((byte)(value & 0x7F));
        return position;
    }

    public static int writeVarInt(int value, ByteBuffer buffer) {
        int uValue = value << 1;
        if (value < 0) {
            uValue ^= 0xFFFFFFFF;
        }
        return ReadWriteForEncodingUtils.writeUnsignedVarInt(uValue, buffer);
    }

    public static int varIntSize(int value) {
        int uValue = value << 1;
        if (value < 0) {
            uValue ^= 0xFFFFFFFF;
        }
        int position = 1;
        while ((long)(uValue & 0xFFFFFF80) != 0L) {
            uValue >>>= 7;
            ++position;
        }
        return position;
    }

    public static int uVarIntSize(int value) {
        int position = 1;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            value >>>= 7;
            ++position;
        }
        return position;
    }

    public static void writeIntLittleEndianPaddedOnBitWidth(int value, OutputStream out, int bitWidth) throws IOException {
        int paddedByteNum = (bitWidth + 7) / 8;
        if (paddedByteNum > 4) {
            throw new IOException(String.format(TOO_LONG_BYTE_FORMAT, paddedByteNum));
        }
        int offset = 0;
        while (paddedByteNum > 0) {
            out.write(value >>> offset & 0xFF);
            offset += 8;
            --paddedByteNum;
        }
    }

    public static void writeLongLittleEndianPaddedOnBitWidth(long value, OutputStream out, int bitWidth) throws IOException {
        int paddedByteNum = (bitWidth + 7) / 8;
        if (paddedByteNum > 8) {
            throw new IOException(String.format(TOO_LONG_BYTE_FORMAT, paddedByteNum));
        }
        out.write(BytesUtils.longToBytes(value, paddedByteNum));
    }

    public static int readIntLittleEndianPaddedOnBitWidth(ByteBuffer buffer, int bitWidth) throws IOException {
        int paddedByteNum = (bitWidth + 7) / 8;
        if (paddedByteNum > 4) {
            throw new IOException(String.format(TOO_LONG_BYTE_FORMAT, paddedByteNum));
        }
        int result = 0;
        int offset = 0;
        while (paddedByteNum > 0) {
            int ch = ReadWriteIOUtils.read(buffer);
            result += ch << offset;
            offset += 8;
            --paddedByteNum;
        }
        return result;
    }

    public static long readLongLittleEndianPaddedOnBitWidth(ByteBuffer buffer, int bitWidth) throws IOException {
        int paddedByteNum = (bitWidth + 7) / 8;
        if (paddedByteNum > 8) {
            throw new IOException(String.format(TOO_LONG_BYTE_FORMAT, paddedByteNum));
        }
        long result = 0L;
        for (int i = 0; i < paddedByteNum; ++i) {
            int ch = ReadWriteIOUtils.read(buffer);
            result <<= 8;
            result |= (long)(ch & 0xFF);
        }
        return result;
    }
}

