/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryTimeoutRuntimeException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.control.SessionTimeoutManager;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTimeManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(QueryTimeManager.class);
    private Map<Long, QueryContext> queryContextMap = new ConcurrentHashMap<Long, QueryContext>();
    private ScheduledExecutorService executorService;
    private Map<Long, ScheduledFuture<?>> queryScheduledTaskMap = new ConcurrentHashMap();

    private QueryTimeManager() {
        this.executorService = IoTDBThreadPoolFactory.newScheduledThreadPool(1, "query-time-manager");
    }

    public void registerQuery(QueryContext context) {
        this.queryContextMap.put(context.getQueryId(), context);
        if (context.getTimeout() < 0L) {
            context.setTimeout(IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold());
        }
        if (context.getTimeout() != 0L) {
            ScheduledFuture<?> scheduledFuture = this.executorService.schedule(() -> {
                this.killQuery(context.getQueryId());
                logger.warn(String.format("Query is time out (%dms) with queryId %d", context.getTimeout(), context.getQueryId()));
            }, context.getTimeout(), TimeUnit.MILLISECONDS);
            this.queryScheduledTaskMap.put(context.getQueryId(), scheduledFuture);
        }
    }

    public void killQuery(long queryId) {
        if (this.queryContextMap.get(queryId) == null) {
            return;
        }
        this.queryContextMap.get(queryId).setInterrupted(true);
    }

    public AtomicBoolean unRegisterQuery(long queryId, boolean fullQuit) {
        AtomicBoolean successRemoved = new AtomicBoolean(false);
        this.queryContextMap.computeIfPresent(queryId, (k, v) -> {
            successRemoved.set(true);
            ScheduledFuture<?> scheduledFuture = this.queryScheduledTaskMap.remove(queryId);
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            SessionTimeoutManager.getInstance().refresh(SessionManager.getInstance().getSessionIdByQueryId(queryId));
            return fullQuit ? null : v;
        });
        return successRemoved;
    }

    public static boolean checkQueryAlive(long queryId) {
        QueryContext queryContext = QueryTimeManager.getInstance().getQueryContext(queryId);
        if (queryContext == null) {
            return false;
        }
        if (queryContext.isInterrupted()) {
            if (QueryTimeManager.getInstance().unRegisterQuery(queryId, true).get()) {
                throw new QueryTimeoutRuntimeException();
            }
            return false;
        }
        return true;
    }

    public Map<Long, QueryContext> getQueryContextMap() {
        return this.queryContextMap;
    }

    public void clear() {
        this.queryContextMap.clear();
        this.queryScheduledTaskMap.clear();
    }

    public QueryContext getQueryContext(long queryId) {
        return this.queryContextMap.get(queryId);
    }

    public static QueryTimeManager getInstance() {
        return QueryTimeManagerHelper.INSTANCE;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            return;
        }
        this.executorService.shutdownNow();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.QUERY_TIME_MANAGER;
    }

    private static class QueryTimeManagerHelper {
        private static final QueryTimeManager INSTANCE = new QueryTimeManager();

        private QueryTimeManagerHelper() {
        }
    }
}

