/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly;

import com.google.common.math.Quantiles;
import java.util.ArrayList;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFIQR
implements UDTF {
    ArrayList<Double> value = new ArrayList();
    ArrayList<Long> timestamp = new ArrayList();
    static final String BATCH_COMPUTE = "batch";
    static final String STREAM_COMPUTE = "stream";
    String compute = "batch";
    double q1 = 0.0;
    double q3 = 0.0;
    double iqr = 0.0;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validate(x -> ((String)x).equalsIgnoreCase(BATCH_COMPUTE) || ((String)x).equalsIgnoreCase(STREAM_COMPUTE), "Parameter \"compute\" is illegal. Please use \"batch\" (for default) or \"stream\".", (Object)validator.getParameters().getStringOrDefault("compute", BATCH_COMPUTE)).validate(params -> (Double)params[0] < (Double)params[1], "parameter $q1$ should be smaller than $q3$", validator.getParameters().getDoubleOrDefault("q1", -1.0), validator.getParameters().getDoubleOrDefault("q3", 1.0));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.value.clear();
        this.timestamp.clear();
        this.q1 = 0.0;
        this.q3 = 0.0;
        this.iqr = 0.0;
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.compute = parameters.getStringOrDefault("compute", BATCH_COMPUTE);
        if (this.compute.equalsIgnoreCase(STREAM_COMPUTE)) {
            this.q1 = parameters.getDouble("q1");
            this.q3 = parameters.getDouble("q3");
            this.iqr = this.q3 - this.q1;
        }
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        if (this.compute.equalsIgnoreCase(STREAM_COMPUTE) && this.q3 > this.q1) {
            double v = Util.getValueAsDouble(row);
            if (v < this.q1 - 1.5 * this.iqr || v > this.q3 + 1.5 * this.iqr) {
                collector.putDouble(row.getTime(), v);
            }
        } else if (this.compute.equalsIgnoreCase(BATCH_COMPUTE)) {
            double v = Util.getValueAsDouble(row);
            this.value.add(v);
            this.timestamp.add(row.getTime());
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        if (this.compute.equalsIgnoreCase(BATCH_COMPUTE)) {
            this.q1 = Quantiles.quartiles().index(1).compute(this.value);
            this.q3 = Quantiles.quartiles().index(3).compute(this.value);
            this.iqr = this.q3 - this.q1;
        }
        for (int i = 0; i < this.value.size(); ++i) {
            double v = this.value.get(i);
            if (!(v < this.q1 - 1.5 * this.iqr) && !(v > this.q3 + 1.5 * this.iqr)) continue;
            collector.putDouble(this.timestamp.get(i), v);
        }
    }
}

