/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.frequency.util;

import java.util.Arrays;
import java.util.List;

public class DWTUtil {
    private int ncof;
    private int layer;
    private int ioff;
    private int joff;
    private double[] cc;
    private double[] cr;
    private double[] data;
    private double[] workspace = new double[1024];

    public DWTUtil(String method, String coef, int layer, List<Double> data) {
        this.data = data.stream().mapToDouble(Double::valueOf).toArray();
        this.layer = layer;
        if (method.equalsIgnoreCase("Haar") || method.equalsIgnoreCase("DB2")) {
            this.cc = new double[]{1.0 / Math.sqrt(2.0), 1.0 / Math.sqrt(2.0)};
        } else if (method.equalsIgnoreCase("DB4")) {
            this.cc = new double[]{0.4829629131445341, 0.8365163037378077, 0.2241438680420134, -0.1294095225512603};
        } else if (method.equalsIgnoreCase("DB6")) {
            this.cc = new double[]{0.3326705529500825, 0.8068915093110924, 0.4598775021184914, -0.1350110200102546, -0.0854412738820267, 0.0352262918857095};
        } else if (method.equalsIgnoreCase("DB8")) {
            this.cc = new double[]{0.2303778133088964, 0.7148465705529155, 0.6308807679398587, -0.0279837694168599, -0.1870348117190931, 0.0308413818355607, 0.0328830116668852, -0.010597401785069};
        } else {
            String[] coefString = coef.split(",");
            this.ncof = coefString.length;
            this.cc = new double[this.ncof];
            for (int i = 0; i < this.ncof; ++i) {
                this.cc[i] = Double.parseDouble(coefString[i]);
            }
        }
        this.ncof = this.cc.length;
        this.ioff = this.joff = -(this.ncof >> 1);
        this.cr = new double[this.ncof];
        double sig = -1.0;
        for (int i = 0; i < this.ncof; ++i) {
            this.cr[this.ncof - 1 - i] = sig * this.cc[i];
            sig = -sig;
        }
    }

    public static boolean isPower2(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    void forward(int n) {
        if (n < this.ncof) {
            return;
        }
        if (n > this.workspace.length) {
            this.workspace = new double[n];
        } else {
            Arrays.fill(this.workspace, 0, n, 0.0);
        }
        int nmod = this.ncof * n;
        int n1 = n - 1;
        int nh = n >> 1;
        int ii = 0;
        int i = 0;
        while (i < n) {
            int ni = i + 1 + nmod + this.ioff;
            int nj = i + 1 + nmod + this.joff;
            for (int k = 0; k < this.ncof; ++k) {
                int jf = n1 & ni + k;
                int jr = n1 & nj + k;
                int n2 = ii;
                this.workspace[n2] = this.workspace[n2] + this.cc[k] * this.data[jf];
                int n3 = ii + nh;
                this.workspace[n3] = this.workspace[n3] + this.cr[k] * this.data[jr];
            }
            i += 2;
            ++ii;
        }
        System.arraycopy(this.workspace, 0, this.data, 0, n);
    }

    public void waveletTransform() {
        int n = this.data.length;
        if (!DWTUtil.isPower2(n)) {
            throw new IllegalArgumentException("The data vector size is not a power of 2.");
        }
        if (n < this.ncof) {
            throw new IllegalArgumentException("The data vector size is less than wavelet coefficient size.");
        }
        int nn = n;
        for (int i = 0; i < this.layer && nn >= this.ncof; ++i) {
            this.forward(nn);
            n >>= 1;
        }
    }

    void backward(int n) {
        if (n < this.ncof) {
            return;
        }
        if (n > this.workspace.length) {
            this.workspace = new double[n];
        } else {
            Arrays.fill(this.workspace, 0, n, 0.0);
        }
        int nmod = this.ncof * n;
        int n1 = n - 1;
        int nh = n >> 1;
        int ii = 0;
        int i = 0;
        while (i < n) {
            double ai = this.data[ii];
            double ai1 = this.data[ii + nh];
            int ni = i + 1 + nmod + this.ioff;
            int nj = i + 1 + nmod + this.joff;
            for (int k = 0; k < this.ncof; ++k) {
                int jf = n1 & ni + k;
                int jr = n1 & nj + k;
                int n2 = jf;
                this.workspace[n2] = this.workspace[n2] + this.cc[k] * ai;
                int n3 = jr;
                this.workspace[n3] = this.workspace[n3] + this.cr[k] * ai1;
            }
            i += 2;
            ++ii;
        }
        System.arraycopy(this.workspace, 0, this.data, 0, n);
    }

    public void inverse() {
        int i;
        int n = this.data.length;
        if (!DWTUtil.isPower2(n)) {
            throw new IllegalArgumentException("The data vector size is not a power of 2.");
        }
        if (n < this.ncof) {
            throw new IllegalArgumentException("The data vector size is less than wavelet coefficient size.");
        }
        int nn = n;
        for (i = 0; i < this.layer - 1; ++i) {
            nn = n / 2;
        }
        for (i = 0; i < this.layer && nn <= n; n <<= 1, ++i) {
            this.backward(nn);
        }
    }

    public double[] getData() {
        return this.data;
    }
}

