/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableByteStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableByteStack;
import org.eclipse.collections.impl.factory.primitive.ByteStacks;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableByteArrayStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableByteEmptyStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableByteSingletonStack;

public class ImmutableByteStackFactoryImpl
implements ImmutableByteStackFactory {
    public static final ImmutableByteStackFactory INSTANCE = new ImmutableByteStackFactoryImpl();

    @Override
    public ImmutableByteStack empty() {
        return ImmutableByteEmptyStack.INSTANCE;
    }

    @Override
    public ImmutableByteStack of() {
        return this.empty();
    }

    @Override
    public ImmutableByteStack with() {
        return this.empty();
    }

    @Override
    public ImmutableByteStack of(byte one) {
        return this.with(one);
    }

    @Override
    public ImmutableByteStack with(byte one) {
        return new ImmutableByteSingletonStack(one);
    }

    @Override
    public ImmutableByteStack of(byte ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableByteStack with(byte ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableByteArrayStack.newStackWith(items);
    }

    @Override
    public ImmutableByteStack ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableByteStack withAll(ByteIterable items) {
        if (items instanceof ImmutableByteStack) {
            return (ImmutableByteStack)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableByteStack ofAll(Iterable<Byte> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableByteStack withAll(Iterable<Byte> iterable) {
        return ByteStacks.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableByteStack ofAllReversed(ByteIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public ImmutableByteStack withAllReversed(ByteIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableByteArrayStack.newStackFromTopToBottom(items);
    }
}

