/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.common;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.iotdb.tool.common.Constants;

public class OptionsUtil
extends Constants {
    private static boolean isImport = true;

    public static void setIsImport(boolean isImport) {
        OptionsUtil.isImport = isImport;
    }

    public static Options createHelpOptions() {
        Options options = new Options();
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg().desc("Display help information").build();
        options.addOption(opHelp);
        Option opFileType = Option.builder((String)"ft").longOpt("file_type").argName("format").hasArg().desc("File type?You can choose tsfile)\u3001csv) or sql).(required)").build();
        options.addOption(opFileType);
        Option opSqlDialect = Option.builder((String)"sql_dialect").longOpt("sql_dialect").argName("sql_dialect").hasArg().desc("Currently supports tree and table model, default tree. (optional)").build();
        options.addOption(opSqlDialect);
        return options;
    }

    public static Options createCommonOptions(Options options) {
        Option opSqlDialect = Option.builder((String)"sql_dialect").longOpt("sql_dialect").argName("sql_dialect").hasArg().desc("Currently supports tree and table model, default tree. (optional)").build();
        options.addOption(opSqlDialect);
        Option opHost = Option.builder((String)"h").longOpt("host").argName("host").hasArg().desc("Host Name (optional)").build();
        options.addOption(opHost);
        Option opPort = Option.builder((String)"p").longOpt("port").argName("port").hasArg().desc("Port (optional)").build();
        options.addOption(opPort);
        Option opUsername = Option.builder((String)"u").longOpt("username").argName("username").hasArg().desc("Username (optional)").build();
        options.addOption(opUsername);
        Option opPassword = Option.builder((String)"pw").longOpt("password").optionalArg(true).argName("password").hasArg().desc("Password (optional)").build();
        options.addOption(opPassword);
        return options;
    }

    public static Options createImportCommonOptions() {
        Options options = new Options();
        Option opFileType = Option.builder((String)"ft").longOpt("file_type").argName("format").required().hasArg().desc(isImport ? "Types of imported files: csv, sql, tsfile.(required)" : "Export file type ?You can choose tsfile)\u3001csv) or sql).(required)").build();
        options.addOption(opFileType);
        return OptionsUtil.createCommonOptions(options);
    }

    public static Options createTreeImportCommonOptions() {
        return OptionsUtil.createImportCommonOptions();
    }

    public static Options createTableImportCommonOptions() {
        Options options = OptionsUtil.createImportCommonOptions();
        Option opDatabase = Option.builder((String)"db").longOpt("database").argName("db").hasArg().required().desc("The database to be exported,only takes effect and required when sql_dialect is table .(optional)").build();
        options.addOption(opDatabase);
        return options;
    }

    public static Options createTreeExportCommonOptions() {
        Options options = OptionsUtil.createImportCommonOptions();
        Option opFile = Option.builder((String)"t").required().longOpt("target").argName("target_directory").hasArg().desc("Target file directory (required)").build();
        options.addOption(opFile);
        Option opOnSuccess = Option.builder((String)"pfn").longOpt("prefix_file_name").argName("prefix_file_name").hasArg().desc("Export file name .(optional)").build();
        options.addOption(opOnSuccess);
        Option opQuery = Option.builder((String)"q").longOpt("query").argName("query_command").hasArg().desc("The query command that you want to execute.If sql_dialect is table The 'q' parameter is only applicable to export types of CSV, and is not available for other types.If the '- q' parameter is not empty, then the parameters' creatTime ',' EndTime 'and' table 'are not effective.(optional)").build();
        options.addOption(opQuery);
        Option opTimeOut = Option.builder((String)"timeout").longOpt("query_timeout").argName("query_timeout").hasArg().desc("Timeout for session query.(optional)").build();
        options.addOption(opTimeOut);
        return options;
    }

    public static Options createTableExportCommonOptions() {
        Options options = OptionsUtil.createImportCommonOptions();
        Option opFile = Option.builder((String)"t").required().longOpt("target").argName("target_directory").hasArg().desc("Target file directory (required)").build();
        options.addOption(opFile);
        Option opOnSuccess = Option.builder((String)"pfn").longOpt("prefix_file_name").argName("prefix_file_name").hasArg().desc("Export file name .(optional)").build();
        options.addOption(opOnSuccess);
        Option opQuery = Option.builder((String)"q").longOpt("query").argName("query_command").hasArg().desc("The query command that you want to execute.If sql_dialect is table The 'q' parameter is only applicable to export types of CSV, and is not available for other types.If the '- q' parameter is not empty, then the parameters' creatTime ',' EndTime 'and' table 'are not effective.(optional)").build();
        options.addOption(opQuery);
        Option opTimeOut = Option.builder((String)"timeout").longOpt("query_timeout").argName("query_timeout").hasArg().desc("Timeout for session query.(optional)").build();
        options.addOption(opTimeOut);
        Option opDatabase = Option.builder((String)"db").longOpt("database").argName("db").hasArg().required().desc("The database to be exported,only takes effect and required when sql_dialect is table .(optional)").build();
        options.addOption(opDatabase);
        Option opTable = Option.builder((String)"table").longOpt("table").argName("table").hasArg().desc("The table to be exported,only takes effect when sql_dialect is table.(optional).If the '-q' parameter is specified, this parameter does not take effect. If the export type is tsfile or sql, this parameter is required. (optional)").build();
        options.addOption(opTable);
        Option opStartTime = Option.builder((String)"start_time").longOpt("start_time").argName("start_time").hasArg().desc("The start time to be exported (optional)").build();
        options.addOption(opStartTime);
        Option opEndTime = Option.builder((String)"end_time").longOpt("end_time").argName("end_time").hasArg().desc("The end time to be exported. (optional)").build();
        options.addOption(opEndTime);
        return options;
    }

    public static Options createTableExportCsvOptions() {
        Options options = OptionsUtil.createTableExportCommonOptions();
        Option opTable = Option.builder((String)"table").longOpt("table").argName("table").hasArg().desc("The table to be exported,only takes effect when sql_dialect is table.(optional).If the '-q' parameter is specified, this parameter does not take effect. If the export type is tsfile or sql, this parameter is required. (optional)").build();
        options.addOption(opTable);
        Option opDataType = Option.builder((String)"dt").longOpt("datatype").argName("datatype").hasArg().desc("Will the data type of timeseries be printed in the head line of the CSV file?\nYou can choose true) or false) . (optional)").build();
        options.addOption(opDataType);
        Option opLinesPerFile = Option.builder((String)"lpf").longOpt("lines_per_file").argName("lines_per_file").hasArg().desc("Lines per dump file,only effective in tree model.(optional)").build();
        options.addOption(opLinesPerFile);
        Option opTimeFormat = Option.builder((String)"tf").longOpt("time_format").argName("time_format").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd HH:mm:ss, default ISO8601.\n OutPut timestamp in sql file, No matter what time format is set(optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        return options;
    }

    public static Options createTableExportTsFileOptions() {
        Options options = OptionsUtil.createTableExportCommonOptions();
        Option opTable = Option.builder((String)"table").longOpt("table").argName("table").hasArg().desc("The table to be exported,only takes effect when sql_dialect is table.(optional).If the '-q' parameter is specified, this parameter does not take effect. If the export type is tsfile or sql, this parameter is required. (optional)").build();
        options.addOption(opTable);
        Option opDataType = Option.builder((String)"dt").longOpt("datatype").argName("datatype").hasArg().desc("Will the data type of timeseries be printed in the head line of the CSV file?\nYou can choose true) or false) . (optional)").build();
        options.addOption(opDataType);
        Option opTimeFormat = Option.builder((String)"tf").longOpt("time_format").argName("time_format").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd HH:mm:ss, default ISO8601.\n OutPut timestamp in sql file, No matter what time format is set(optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        return options;
    }

    public static Options createTableExportSqlOptions() {
        Options options = OptionsUtil.createTableExportCommonOptions();
        Option opTable = Option.builder((String)"table").longOpt("table").argName("table").hasArg().desc("The table to be exported,only takes effect when sql_dialect is table.(optional).If the '-q' parameter is specified, this parameter does not take effect. If the export type is tsfile or sql, this parameter is required. (optional)").build();
        options.addOption(opTable);
        Option opDataType = Option.builder((String)"dt").longOpt("datatype").argName("datatype").hasArg().desc("Will the data type of timeseries be printed in the head line of the CSV file?\nYou can choose true) or false) . (optional)").build();
        options.addOption(opDataType);
        Option opLinesPerFile = Option.builder((String)"lpf").longOpt("lines_per_file").argName("lines_per_file").hasArg().desc("Lines per dump file,only effective in tree model.(optional)").build();
        options.addOption(opLinesPerFile);
        Option opTimeFormat = Option.builder((String)"tf").longOpt("time_format").argName("time_format").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd HH:mm:ss, default ISO8601.\n OutPut timestamp in sql file, No matter what time format is set(optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        return options;
    }

    public static Options createExportCsvOptions() {
        Options options = OptionsUtil.createTreeExportCommonOptions();
        Option opDataType = Option.builder((String)"dt").longOpt("datatype").argName("datatype").hasArg().desc("Will the data type of timeseries be printed in the head line of the CSV file?\nYou can choose true) or false) . (optional)").build();
        options.addOption(opDataType);
        Option opLinesPerFile = Option.builder((String)"lpf").longOpt("lines_per_file").argName("lines_per_file").hasArg().desc("Lines per dump file,only effective in tree model.(optional)").build();
        options.addOption(opLinesPerFile);
        Option opTimeFormat = Option.builder((String)"tf").longOpt("time_format").argName("time_format").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd HH:mm:ss, default ISO8601.\n OutPut timestamp in sql file, No matter what time format is set(optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        return options;
    }

    public static Options createExportSqlOptions() {
        Options options = OptionsUtil.createTreeExportCommonOptions();
        Option opAligned = Option.builder((String)"aligned").longOpt("use_aligned").argName("export aligned insert sql").hasArgs().desc("Whether export to sql of aligned.(optional)").build();
        options.addOption(opAligned);
        Option opLinesPerFile = Option.builder((String)"lpf").longOpt("lines_per_file").argName("lines_per_file").hasArg().desc("Lines per dump file,only effective in tree model.(optional)").build();
        options.addOption(opLinesPerFile);
        Option opTimeFormat = Option.builder((String)"tf").longOpt("time_format").argName("time_format").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd HH:mm:ss, default ISO8601.\n OutPut timestamp in sql file, No matter what time format is set(optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        return options;
    }

    public static Options createExportTsFileOptions() {
        Options options = OptionsUtil.createTreeExportCommonOptions();
        return options;
    }

    public static Options createImportCsvOptions() {
        Options options = OptionsUtil.createTreeImportCommonOptions();
        Option opFile = Option.builder((String)"s").longOpt("source").argName("source").required().hasArg().desc("The local directory path of the script file (folder) to be loaded. (required)").build();
        options.addOption(opFile);
        Option opFailDir = Option.builder((String)"fd").longOpt("fail_dir").argName("fail_dir").hasArg().desc("Specifying a directory to save failed file, default YOUR_CSV_FILE_PATH.(optional)").build();
        options.addOption(opFailDir);
        Option opFailedLinesPerFile = Option.builder((String)"lpf").longOpt("lines_per_failed_file").argName("lines_per_failed_file").hasArgs().desc("Lines per failed file,only takes effect and required when sql_dialect is table .(option)").build();
        options.addOption(opFailedLinesPerFile);
        Option opAligned = Option.builder((String)"aligned").longOpt("use_aligned").argName("use the aligned interface").hasArg().desc("Whether to use the interface of aligned.(optional)").build();
        options.addOption(opAligned);
        Option opTypeInfer = Option.builder((String)"ti").longOpt("type_infer").argName("type_infer").numberOfArgs(5).hasArgs().valueSeparator(',').desc("Define type info by option:\"boolean=text,int=long, ... (optional)").build();
        options.addOption(opTypeInfer);
        Option opTimestampPrecision = Option.builder((String)"tp").longOpt("timestamp_precision").argName("timestamp precision (ms/us/ns)").hasArg().desc("Timestamp precision (ms/us/ns).(optional)").build();
        options.addOption(opTimestampPrecision);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        Option opBatchPointSize = Option.builder((String)"batch").longOpt("batch_size").argName("batch_size").hasArg().desc("100000 (optional)").build();
        options.addOption(opBatchPointSize);
        Option opThreadNum = Option.builder((String)"tn").longOpt("thread_num").argName("thread_num").hasArg().desc("The number of threads used to import tsfile, default is 8.(optional)").build();
        options.addOption(opThreadNum);
        return options;
    }

    public static Options createImportSqlOptions() {
        Options options = OptionsUtil.createTreeImportCommonOptions();
        Option opFile = Option.builder((String)"s").required().longOpt("source").argName("source").hasArg().desc("The local directory path of the script file (folder) to be loaded. (required)").build();
        options.addOption(opFile);
        Option opFailDir = Option.builder((String)"fd").longOpt("fail_dir").argName("fail_dir").hasArg().desc("Specifying a directory to save failed file, default YOUR_SQL_FILE_PATH.(optional)").build();
        options.addOption(opFailDir);
        Option opFailedLinesPerFile = Option.builder((String)"lpf").argName("lines_per_failed_file").hasArgs().desc("Lines per failed file,only takes effect and required when sql_dialect is table .(option)").build();
        options.addOption(opFailedLinesPerFile);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        Option opBatchPointSize = Option.builder((String)"batch").longOpt("batch_size").argName("batch_size").hasArg().desc("100000 (optional)").build();
        options.addOption(opBatchPointSize);
        Option opThreadNum = Option.builder((String)"tn").longOpt("thread_num").argName("thread_num").hasArgs().desc("The number of threads used to import tsfile, default is 8.(optional)").build();
        options.addOption(opThreadNum);
        return options;
    }

    public static Options createImportTsFileOptions() {
        Options options = OptionsUtil.createTreeImportCommonOptions();
        Option opFile = Option.builder((String)"s").required().longOpt("source").argName("source").hasArg().desc("The local directory path of the script file (folder) to be loaded. (required)").build();
        options.addOption(opFile);
        Option opOnSuccess = Option.builder((String)"os").longOpt("on_success").argName("on_success").required().hasArg().desc("When loading tsfile successfully, do operation on tsfile (and its .resource and .mods files), optional parameters are none, mv, cp, delete. (required)").build();
        options.addOption(opOnSuccess);
        Option opSuccessDir = Option.builder((String)"sd").longOpt("success_dir").argName("success_dir").hasArg().desc("The target folder when 'os' is 'mv' or 'cp'.(optional)").build();
        options.addOption(opSuccessDir);
        Option opOnFail = Option.builder((String)"of").longOpt("on_fail").argName("on_fail").required().hasArg().desc("When loading tsfile fail, do operation on tsfile (and its .resource and .mods files), optional parameters are none, mv, cp, delete. (required)").build();
        options.addOption(opOnFail);
        Option opFailDir = Option.builder((String)"fd").longOpt("fail_dir").argName("fail_dir").hasArg().desc("The target folder when 'of' is 'mv' or 'cp'.(optional)").build();
        options.addOption(opFailDir);
        Option opThreadNum = Option.builder((String)"tn").longOpt("thread_num").argName("thread_num").hasArg().desc("The number of threads used to import tsfile, default is 8.(optional)").build();
        options.addOption(opThreadNum);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        Option opTimestampPrecision = Option.builder((String)"tp").longOpt("timestamp_precision").argName("timestamp precision (ms/us/ns)").hasArg().desc("Timestamp precision (ms/us/ns).(optional)").build();
        options.addOption(opTimestampPrecision);
        return options;
    }

    public static Options createTableImportCsvOptions() {
        Options options = OptionsUtil.createTableImportCommonOptions();
        Option opTable = Option.builder((String)"table").longOpt("table").argName("table").hasArg().desc("The table to be exported,only takes effect when sql_dialect is table.(optional) and file_type is csv. (optional)").build();
        options.addOption(opTable);
        Option opFile = Option.builder((String)"s").longOpt("source").argName("source").required().hasArg().desc("The local directory path of the script file (folder) to be loaded. (required)").build();
        options.addOption(opFile);
        Option opFailDir = Option.builder((String)"fd").longOpt("fail_dir").argName("fail_dir").hasArg().desc("Specifying a directory to save failed file, default YOUR_CSV_FILE_PATH.(optional)").build();
        options.addOption(opFailDir);
        Option opFailedLinesPerFile = Option.builder((String)"lpf").longOpt("lines_per_failed_file").argName("lines_per_failed_file").hasArgs().desc("Lines per failed file,only takes effect and required when sql_dialect is table .(option)").build();
        options.addOption(opFailedLinesPerFile);
        Option opAligned = Option.builder((String)"aligned").longOpt("use_aligned").argName("use the aligned interface").hasArg().desc("Whether to use the interface of aligned.(optional)").build();
        options.addOption(opAligned);
        Option opTypeInfer = Option.builder((String)"ti").longOpt("type_infer").argName("type_infer").numberOfArgs(5).hasArgs().valueSeparator(',').desc("Define type info by option:\"boolean=text,int=long, ... (optional)").build();
        options.addOption(opTypeInfer);
        Option opTimestampPrecision = Option.builder((String)"tp").longOpt("timestamp_precision").argName("timestamp precision (ms/us/ns)").hasArg().desc("Timestamp precision (ms/us/ns).(optional)").build();
        options.addOption(opTimestampPrecision);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        Option opBatchPointSize = Option.builder((String)"batch").longOpt("batch_size").argName("batch_size").hasArg().desc("100000 (optional)").build();
        options.addOption(opBatchPointSize);
        Option opThreadNum = Option.builder((String)"tn").longOpt("thread_num").argName("thread_num").hasArg().desc("The number of threads used to import tsfile, default is 8.(optional)").build();
        options.addOption(opThreadNum);
        return options;
    }

    public static Options createTableImportSqlOptions() {
        Options options = OptionsUtil.createTableImportCommonOptions();
        Option opFile = Option.builder((String)"s").required().longOpt("source").argName("source").hasArg().desc("The local directory path of the script file (folder) to be loaded. (required)").build();
        options.addOption(opFile);
        Option opFailDir = Option.builder((String)"fd").longOpt("fail_dir").argName("fail_dir").hasArg().desc("Specifying a directory to save failed file, default YOUR_SQL_FILE_PATH.(optional)").build();
        options.addOption(opFailDir);
        Option opFailedLinesPerFile = Option.builder((String)"lpf").argName("lines_per_failed_file").hasArgs().desc("Lines per failed file,only takes effect and required when sql_dialect is table .(option)").build();
        options.addOption(opFailedLinesPerFile);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        Option opBatchPointSize = Option.builder((String)"batch").longOpt("batch_size").argName("batch_size").hasArg().desc("100000 (optional)").build();
        options.addOption(opBatchPointSize);
        Option opThreadNum = Option.builder((String)"tn").longOpt("thread_num").argName("thread_num").hasArgs().desc("The number of threads used to import tsfile, default is 8.(optional)").build();
        options.addOption(opThreadNum);
        return options;
    }

    public static Options createTableImportTsFileOptions() {
        Options options = OptionsUtil.createTableImportCommonOptions();
        Option opFile = Option.builder((String)"s").required().longOpt("source").argName("source").hasArg().desc("The local directory path of the script file (folder) to be loaded. (required)").build();
        options.addOption(opFile);
        Option opOnSuccess = Option.builder((String)"os").longOpt("on_success").argName("on_success").required().hasArg().desc("When loading tsfile successfully, do operation on tsfile (and its .resource and .mods files), optional parameters are none, mv, cp, delete. (required)").build();
        options.addOption(opOnSuccess);
        Option opSuccessDir = Option.builder((String)"sd").longOpt("success_dir").argName("success_dir").hasArg().desc("The target folder when 'os' is 'mv' or 'cp'.(optional)").build();
        options.addOption(opSuccessDir);
        Option opOnFail = Option.builder((String)"of").longOpt("on_fail").argName("on_fail").required().hasArg().desc("When loading tsfile fail, do operation on tsfile (and its .resource and .mods files), optional parameters are none, mv, cp, delete. (required)").build();
        options.addOption(opOnFail);
        Option opFailDir = Option.builder((String)"fd").longOpt("fail_dir").argName("fail_dir").hasArg().desc("The target folder when 'of' is 'mv' or 'cp'.(optional)").build();
        options.addOption(opFailDir);
        Option opThreadNum = Option.builder((String)"tn").longOpt("thread_num").argName("thread_num").hasArg().desc("The number of threads used to import tsfile, default is 8.(optional)").build();
        options.addOption(opThreadNum);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 .(optional)").build();
        options.addOption(opTimeZone);
        Option opTimestampPrecision = Option.builder((String)"tp").longOpt("timestamp_precision").argName("timestamp precision (ms/us/ns)").hasArg().desc("Timestamp precision (ms/us/ns).(optional)").build();
        options.addOption(opTimestampPrecision);
        return options;
    }

    public static Options createSubscriptionTsFileOptions() {
        Options options = new Options();
        Option opSqlDialect = Option.builder((String)"sql_dialect").longOpt("sql_dialect").argName("sql_dialect").hasArg().desc("Currently supports tree and table model, default tree. (optional)").build();
        options.addOption(opSqlDialect);
        Option opHost = Option.builder((String)"h").longOpt("host").argName("host").hasArg().desc("Host Name (optional)").build();
        options.addOption(opHost);
        Option opPort = Option.builder((String)"p").longOpt("port").argName("port").hasArg().desc("Port (optional)").build();
        options.addOption(opPort);
        Option opUsername = Option.builder((String)"u").longOpt("username").argName("username").hasArg().desc("Username (optional)").build();
        options.addOption(opUsername);
        Option opPassword = Option.builder((String)"pw").longOpt("password").optionalArg(true).argName("password").hasArg().desc("Password (optional)").build();
        options.addOption(opPassword);
        Option opPath = Option.builder((String)"path").longOpt("path").argName("path").hasArg().desc("The path to be exported,only takes effect when sql_dialect is tree.(optional)").build();
        options.addOption(opPath);
        Option opDatabase = Option.builder((String)"db").longOpt("database").argName("db").hasArg().desc("The database to be exported,only takes effect and required when sql_dialect is table .(optional)").build();
        options.addOption(opDatabase);
        Option opTable = Option.builder((String)"table").longOpt("table").argName("table").hasArg().desc("The table to be exported,only takes effect when sql_dialect is table.(optional)").build();
        options.addOption(opTable);
        Option opStartTime = Option.builder((String)"start_time").longOpt("start_time").argName("start_time").hasArg().desc("The start time to be exported (optional)").build();
        options.addOption(opStartTime);
        Option opEndTime = Option.builder((String)"end_time").longOpt("end_time").argName("end_time").hasArg().desc("The end time to be exported. (optional)").build();
        options.addOption(opEndTime);
        Option opFile = Option.builder((String)"t").longOpt("target").argName("target_directory").hasArg().desc("Target file directory.default ./target (optional)").build();
        options.addOption(opFile);
        Option opThreadNum = Option.builder((String)"tn").longOpt("thread_num").argName("thread_num").hasArg().desc("The number of threads used to import tsfile, default is 8.(optional)").build();
        options.addOption(opThreadNum);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    public static Options createExportSchemaOptions() {
        Options options = OptionsUtil.createCommonOptions(new Options());
        Option opTargetFile = Option.builder((String)"t").required().longOpt("target_directory").hasArg().argName("target").desc("Target file directory (required)").build();
        options.addOption(opTargetFile);
        Option targetPathPattern = Option.builder((String)"path").longOpt("path_pattern").hasArg().argName("exportPathPattern").desc("Export Path Pattern (optional)").build();
        options.addOption(targetPathPattern);
        Option targetFileName = Option.builder((String)"pfn").longOpt("prefix_file_name").hasArg().argName("prefix_file_name").desc("Export file name .(optional)").build();
        options.addOption(targetFileName);
        Option opLinesPerFile = Option.builder((String)"lpf").longOpt("lines_per_file").hasArg().argName("lines_per_file").desc("Lines per dump file,only effective in tree model.(optional)").build();
        options.addOption(opLinesPerFile);
        Option opTimeout = Option.builder((String)"timeout").longOpt("query_timeout").hasArg().argName("timeout").desc("Timeout for session query.(optional)").build();
        options.addOption(opTimeout);
        Option opDatabase = Option.builder((String)"db").longOpt("database").argName("db").hasArg().desc("The database to be exported,only takes effect and required when sql_dialect is table .(optional)").build();
        options.addOption(opDatabase);
        Option opTable = Option.builder((String)"table").longOpt("table").argName("table").hasArg().desc("The table to be exported,only takes effect when sql_dialect is table.(optional).If the '-q' parameter is specified, this parameter does not take effect. If the export type is tsfile or sql, this parameter is required. (optional)").build();
        options.addOption(opTable);
        Option opHelp = Option.builder((String)"help").longOpt("help").desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    public static Options createImportSchemaOptions() {
        Options options = OptionsUtil.createCommonOptions(new Options());
        Option opFile = Option.builder((String)"s").required().longOpt("source").argName("source").hasArg().desc("The local directory path of the script file (folder) to be loaded. (required)").build();
        options.addOption(opFile);
        Option opFailedFile = Option.builder((String)"fd").longOpt("fail_dir").hasArg().argName("failDir").desc("Specifying a directory to save failed file, default YOUR_CSV_FILE_PATH (optional)").build();
        options.addOption(opFailedFile);
        Option opBatchPointSize = Option.builder((String)"batch").longOpt("batch_size").hasArg().argName("batch_size").desc("10000 (only not aligned and sql_dialect tree optional)").build();
        options.addOption(opBatchPointSize);
        Option opFailedLinesPerFile = Option.builder((String)"lpf").longOpt("lines_per_failed_file").hasArg().argName("lines_per_failed_file").desc("Lines per failed file,only takes effect and required when sql_dialect is table .(option)").build();
        options.addOption(opFailedLinesPerFile);
        Option opDatabase = Option.builder((String)"db").longOpt("database").argName("db").hasArg().desc("The database to be exported,only takes effect and required when sql_dialect is table .(optional)").build();
        options.addOption(opDatabase);
        Option opHelp = Option.builder((String)"help").longOpt("help").desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }
}

